/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.datagen.data;

import com.portingdeadmods.portingdeadlibs.api.fluids.PDLFluid;
import com.portingdeadmods.power_armor.registries.PABlocks;
import com.portingdeadmods.power_armor.registries.PAItems;
import com.portingdeadmods.power_armor.registries.PATags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EMTagsProvider {
    public static void createTagProviders(DataGenerator generator, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper, boolean isServer) {
        BlocksProvider provider = new BlocksProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(isServer, (DataProvider)provider);
        generator.addProvider(isServer, (DataProvider)new ItemsProvider(packOutput, lookupProvider, provider.contentsGetter()));
        generator.addProvider(isServer, (DataProvider)new FluidsProvider(packOutput, lookupProvider, existingFileHelper));
    }

    protected static class BlocksProvider
    extends BlockTagsProvider {
        public BlocksProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "power_armor", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag((TagKey<Block>)BlockTags.NEEDS_STONE_TOOL, (Block)PABlocks.MACHINE_FRAME.get());
            this.tag((TagKey<Block>)BlockTags.NEEDS_STONE_TOOL, (Block)PABlocks.COMPRESSOR.get());
            this.tag((TagKey<Block>)BlockTags.NEEDS_STONE_TOOL, (Block)PABlocks.ARMOR_MODIFICATION_TABLE.get());
            this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, (Block)PABlocks.MACHINE_FRAME.get());
            this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, (Block)PABlocks.COMPRESSOR.get());
            this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, (Block)PABlocks.ARMOR_MODIFICATION_TABLE.get());
        }

        private void tag(TagKey<Block> itemTagKey, Block ... blocks) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(itemTagKey);
            for (Block block : blocks) {
                tag.add((Object)block);
            }
        }

        @SafeVarargs
        private void tag(TagKey<Block> itemTagKey, TagKey<Block> ... blocks) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(itemTagKey);
            for (TagKey<Block> block : blocks) {
                tag.addTag(block);
            }
        }
    }

    protected static class ItemsProvider
    extends ItemTagsProvider {
        public ItemsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags) {
            super(output, lookupProvider, blockTags);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(PATags.ItemTags.PLATES, PATags.ItemTags.PLATES_COPPER, PATags.ItemTags.PLATES_IRON);
            this.tag(PATags.ItemTags.WIRES, PATags.ItemTags.WIRES_COPPER);
            this.tag(PATags.ItemTags.PLATES_COPPER, (ItemLike)PAItems.COPPER_PLATE.get());
            this.tag(PATags.ItemTags.PLATES_IRON, (ItemLike)PAItems.IRON_PLATE.get());
            this.tag(PATags.ItemTags.WIRES_COPPER, (ItemLike)PAItems.COPPER_WIRE.get());
        }

        private void tag(TagKey<Item> itemTagKey, ItemLike ... items) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(itemTagKey);
            for (ItemLike item : items) {
                tag.add((Object)item.asItem());
            }
        }

        @SafeVarargs
        private void tag(TagKey<Item> itemTagKey, TagKey<Item> ... items) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(itemTagKey);
            for (TagKey<Item> item : items) {
                tag.addTag(item);
            }
        }
    }

    public static class FluidsProvider
    extends FluidTagsProvider {
        public FluidsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, provider, "power_armor", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
        }

        private void tag(TagKey<Fluid> fluidTagKey, PDLFluid ... fluids) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(fluidTagKey);
            for (PDLFluid fluid : fluids) {
                tag.add((Object)fluid.getStillFluid());
            }
        }

        private void tag(TagKey<Fluid> fluidTagKey, Fluid ... fluids) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(fluidTagKey);
            for (Fluid fluid : fluids) {
                tag.add((Object)fluid);
            }
        }

        @SafeVarargs
        private void tag(TagKey<Fluid> fluidTagKey, TagKey<Fluid> ... fluids) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(fluidTagKey);
            for (TagKey<Fluid> fluid : fluids) {
                tag.addTag(fluid);
            }
        }
    }
}

