/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.events;

import com.portingdeadmods.power_armor.api.AttackType;
import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.client.PAKeybinds;
import com.portingdeadmods.power_armor.content.items.ArmorRemoveHandler;
import com.portingdeadmods.power_armor.data.PAComponents;
import com.portingdeadmods.power_armor.data.components.ArmorModulesComponent;
import com.portingdeadmods.power_armor.registries.PAArmorModules;
import com.portingdeadmods.power_armor.utils.ArmorModuleUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="power_armor")
public final class CommonEvents {
    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (ArmorModuleUtils.hasModule(stack, PAArmorModules.JETPACK) && energyStorage != null && energyStorage.getEnergyStored() > 0) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        ItemStack stack = event.getFrom();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = stack.getItem();
            if (livingEntity instanceof ArmorRemoveHandler) {
                ArmorRemoveHandler armorRemoveHandler = (ArmorRemoveHandler)livingEntity;
                armorRemoveHandler.onArmorRemoved(player, stack);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAttacked(LivingDamageEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (ItemStack stack : player.getArmorSlots()) {
                ArmorModulesComponent modules = (ArmorModulesComponent)stack.getOrDefault(PAComponents.ARMOR_MODULES, (Object)ArmorModulesComponent.EMPTY);
                for (ArmorModule armorModule : modules.modulesUnsafe()) {
                    armorModule.onPlayerAttacked(player, stack);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (((KeyMapping)PAKeybinds.LASER_ATTACK.get()).isDown()) {
            AttackType type = ArmorModuleUtils.getAttackType((Player)player);
            if (type.vanilla()) {
                return;
            }
            type.handle((Player)player, (Entity)player, player.swingingArm);
        }
    }

    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
    }
}

