/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.networking;

import com.portingdeadmods.power_armor.PowerArmor;
import com.portingdeadmods.power_armor.content.menus.ArmorModificationTableMenu;
import com.portingdeadmods.power_armor.content.menus.ArmorSlot;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ArmorWidgetOpenClosePayload(boolean open) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ArmorWidgetOpenClosePayload> TYPE = new CustomPacketPayload.Type(PowerArmor.rl("armor_widget_open_close"));
    public static final StreamCodec<ByteBuf, ArmorWidgetOpenClosePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ArmorWidgetOpenClosePayload::open, ArmorWidgetOpenClosePayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp = context.player().containerMenu;
            if (patt0$temp instanceof ArmorModificationTableMenu) {
                ArmorModificationTableMenu menu = (ArmorModificationTableMenu)patt0$temp;
                for (ArmorSlot upgradeSlot : menu.getArmorSlots()) {
                    upgradeSlot.setActive(this.open);
                }
            }
        }).exceptionally(err -> {
            PowerArmor.LOGGER.error("Failed to handle ArmorWidgetOpenClosePayload payload", err);
            return null;
        });
    }
}

