/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.networking;

import com.portingdeadmods.power_armor.PowerArmor;
import com.portingdeadmods.power_armor.content.menus.ArmorModificationTableMenu;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ArmorWidgetSetSlotPositionsPayload(int startY) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ArmorWidgetSetSlotPositionsPayload> TYPE = new CustomPacketPayload.Type(PowerArmor.rl("armor_widget_set_slot_positions"));
    public static final StreamCodec<ByteBuf, ArmorWidgetSetSlotPositionsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ArmorWidgetSetSlotPositionsPayload::startY, ArmorWidgetSetSlotPositionsPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp = context.player().containerMenu;
            if (patt0$temp instanceof ArmorModificationTableMenu) {
                ArmorModificationTableMenu menu = (ArmorModificationTableMenu)patt0$temp;
                menu.setArmorSlotPositions(this.startY);
            }
        }).exceptionally(err -> {
            PowerArmor.LOGGER.error("Failed to handle ArmorWidgetSetSlotPositionsPayload payload", err);
            return null;
        });
    }
}

