/*
 * Decompiled with CFR 0.152.
 */
package torcherino;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import torcherino.ClientHelper;
import torcherino.Torcherino;
import torcherino.api.TorcherinoAPI;
import torcherino.block.CopperLanterinoBlock;
import torcherino.block.ForgeTorcherinoBlock;
import torcherino.block.ForgeWallTorcherinoBlock;
import torcherino.block.JackoLanterinoBlock;
import torcherino.block.LanterinoBlock;
import torcherino.block.TorcherinoBlock;
import torcherino.block.WeatheringLanterinoBlock;
import torcherino.block.api.LanterinoDegradable;
import torcherino.block.api.LanterinoOxidizableRegistry;
import torcherino.block.entity.TorcherinoBlockEntity;
import torcherino.particle.TorcherinoParticleTypes;

@Mod.EventBusSubscriber(modid="torcherino")
public final class ModContent {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"torcherino");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"torcherino");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"torcherino");
    private static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"torcherino");
    static Supplier<TorcherinoBlock> b;
    private static final Set<ResourceLocation> toBlacklist;

    public static void initialise(BusGroup bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        TorcherinoParticleTypes.PARTICLE_TYPES.register(bus);
        TILE_ENTITIES.register(bus);
        TILE_ENTITIES.register("torcherino", () -> new BlockEntityType(TorcherinoBlockEntity::new, Set.of(BLOCKS.getEntries().stream().map(Supplier::get).toList().toArray(new Block[0]))));
        toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)"torcherino"));
        TorcherinoAPI.INSTANCE.getTiers().keySet().forEach(ModContent::register);
    }

    private static String getPath(ResourceLocation tierID, String type) {
        return (String)(tierID.getPath().equals("normal") ? "" : tierID.getPath() + "_") + type;
    }

    private static void register(ResourceLocation tierID) {
        if (tierID.getNamespace().equals("torcherino")) {
            String torcherinoPath = ModContent.getPath(tierID, "torcherino");
            String jackoLanterinoPath = ModContent.getPath(tierID, "lanterino");
            String lanterinoPath = ModContent.getPath(tierID, "lantern");
            String copperLanterinoId = ModContent.getPath(tierID, "copper_lantern");
            String exposedCopperId = "exposed_" + copperLanterinoId;
            String weatheredCopperId = "weathered_" + copperLanterinoId;
            String oxidizedCopperId = "oxidized_" + copperLanterinoId;
            String waxedCopperId = "waxed_" + copperLanterinoId;
            String waxedexposedCopperId = "waxed_exposed_" + copperLanterinoId;
            String waxedweatheredCopperId = "waxed_weathered_" + copperLanterinoId;
            String waxedoxidizedCopperId = "waxed_oxidized_" + copperLanterinoId;
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)torcherinoPath));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)("wall_" + torcherinoPath)));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)jackoLanterinoPath));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)lanterinoPath));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)copperLanterinoId));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)exposedCopperId));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)weatheredCopperId));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)oxidizedCopperId));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)waxedCopperId));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)waxedexposedCopperId));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)waxedweatheredCopperId));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)waxedoxidizedCopperId));
            toBlacklist.add(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)copperLanterinoId));
            RegistryObject standingBlock = BLOCKS.register(torcherinoPath, () -> new ForgeTorcherinoBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).pushReaction(PushReaction.IGNORE).setId(Torcherino.KeyofBlock(torcherinoPath)), tierID));
            RegistryObject wallBlock = BLOCKS.register("wall_" + torcherinoPath, () -> ModContent.lambda$register$2(torcherinoPath, (Supplier)standingBlock, tierID));
            RegistryObject jackoLanterinoBlock = BLOCKS.register(jackoLanterinoPath, () -> new JackoLanterinoBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JACK_O_LANTERN).pushReaction(PushReaction.IGNORE).setId(Torcherino.KeyofBlock(jackoLanterinoPath)), tierID));
            RegistryObject lanterinoBlock = BLOCKS.register(lanterinoPath, () -> new LanterinoBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).pushReaction(PushReaction.IGNORE).setId(Torcherino.KeyofBlock(lanterinoPath)), tierID));
            RegistryObject copperLantern = BLOCKS.register(copperLanterinoId, () -> new WeatheringLanterinoBlock(LanterinoDegradable.DegradationLevel.UNAFFECTED, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).randomTicks().setId(Torcherino.KeyofBlock(copperLanterinoId)), tierID));
            RegistryObject exposedCopper = BLOCKS.register(exposedCopperId, () -> new WeatheringLanterinoBlock(LanterinoDegradable.DegradationLevel.EXPOSED, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).randomTicks().setId(Torcherino.KeyofBlock(exposedCopperId)), tierID));
            RegistryObject weatheredCopper = BLOCKS.register(weatheredCopperId, () -> new WeatheringLanterinoBlock(LanterinoDegradable.DegradationLevel.WEATHERED, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).randomTicks().setId(Torcherino.KeyofBlock(weatheredCopperId)), tierID));
            RegistryObject oxidizedCopper = BLOCKS.register(oxidizedCopperId, () -> new WeatheringLanterinoBlock(LanterinoDegradable.DegradationLevel.OXIDIZED, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).randomTicks().setId(Torcherino.KeyofBlock(oxidizedCopperId)), tierID));
            RegistryObject waxedCopper = BLOCKS.register(waxedCopperId, () -> new CopperLanterinoBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).randomTicks().setId(Torcherino.KeyofBlock(waxedCopperId)), tierID));
            RegistryObject waxedExposedCopper = BLOCKS.register(waxedexposedCopperId, () -> new CopperLanterinoBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).randomTicks().setId(Torcherino.KeyofBlock(waxedexposedCopperId)), tierID));
            RegistryObject waxedWeatheredCopper = BLOCKS.register(waxedweatheredCopperId, () -> new CopperLanterinoBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).randomTicks().setId(Torcherino.KeyofBlock(waxedweatheredCopperId)), tierID));
            RegistryObject waxedOxidizedCopper = BLOCKS.register(waxedoxidizedCopperId, () -> new CopperLanterinoBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).randomTicks().setId(Torcherino.KeyofBlock(waxedoxidizedCopperId)), tierID));
            ITEMS.register(torcherinoPath, () -> ModContent.lambda$register$21((Supplier)standingBlock, (Supplier)wallBlock, torcherinoPath));
            ITEMS.register(jackoLanterinoPath, () -> ModContent.lambda$register$22((Supplier)jackoLanterinoBlock, jackoLanterinoPath));
            ITEMS.register(lanterinoPath, () -> ModContent.lambda$register$23((Supplier)lanterinoBlock, lanterinoPath));
            ITEMS.register(copperLanterinoId, () -> ModContent.lambda$register$24((Supplier)copperLantern, copperLanterinoId));
            ITEMS.register(exposedCopperId, () -> ModContent.lambda$register$25((Supplier)exposedCopper, exposedCopperId));
            ITEMS.register(weatheredCopperId, () -> ModContent.lambda$register$26((Supplier)weatheredCopper, weatheredCopperId));
            ITEMS.register(oxidizedCopperId, () -> ModContent.lambda$register$27((Supplier)oxidizedCopper, oxidizedCopperId));
            ITEMS.register(waxedCopperId, () -> ModContent.lambda$register$28((Supplier)waxedCopper, waxedCopperId));
            ITEMS.register(waxedexposedCopperId, () -> ModContent.lambda$register$29((Supplier)waxedExposedCopper, waxedexposedCopperId));
            ITEMS.register(waxedweatheredCopperId, () -> ModContent.lambda$register$30((Supplier)waxedWeatheredCopper, waxedweatheredCopperId));
            ITEMS.register(waxedoxidizedCopperId, () -> ModContent.lambda$register$31((Supplier)waxedOxidizedCopper, waxedoxidizedCopperId));
            LanterinoOxidizableRegistry.addPendingTier(tierID, (Supplier<WeatheringLanterinoBlock>)copperLantern, (Supplier<WeatheringLanterinoBlock>)exposedCopper, (Supplier<WeatheringLanterinoBlock>)weatheredCopper, (Supplier<WeatheringLanterinoBlock>)oxidizedCopper, (Supplier<CopperLanterinoBlock>)waxedCopper, (Supplier<CopperLanterinoBlock>)waxedExposedCopper, (Supplier<CopperLanterinoBlock>)waxedWeatheredCopper, (Supplier<CopperLanterinoBlock>)waxedOxidizedCopper);
            if (FMLLoader.getDist().isClient()) {
                ClientHelper.registerCutout((Supplier<? extends Block>)standingBlock);
                ClientHelper.registerCutout((Supplier<? extends Block>)wallBlock);
                ClientHelper.registerCutout((Supplier<? extends Block>)lanterinoBlock);
                ClientHelper.registerCutout((Supplier<? extends Block>)copperLantern);
                ClientHelper.registerCutout((Supplier<? extends Block>)exposedCopper);
                ClientHelper.registerCutout((Supplier<? extends Block>)weatheredCopper);
                ClientHelper.registerCutout((Supplier<? extends Block>)oxidizedCopper);
                ClientHelper.registerCutout((Supplier<? extends Block>)waxedCopper);
                ClientHelper.registerCutout((Supplier<? extends Block>)waxedExposedCopper);
                ClientHelper.registerCutout((Supplier<? extends Block>)waxedWeatheredCopper);
                ClientHelper.registerCutout((Supplier<? extends Block>)waxedOxidizedCopper);
            }
        }
    }

    @SubscribeEvent
    public static void blackliststuff(FMLCommonSetupEvent event) {
        for (ResourceLocation block : toBlacklist) {
            TorcherinoAPI.INSTANCE.blacklistBlock(block);
        }
        TorcherinoAPI.INSTANCE.blacklistBlock(Blocks.WATER);
        TorcherinoAPI.INSTANCE.blacklistBlock(Blocks.LAVA);
        TorcherinoAPI.INSTANCE.blacklistBlock(Blocks.AIR);
        TorcherinoAPI.INSTANCE.blacklistBlock(Blocks.CAVE_AIR);
        TorcherinoAPI.INSTANCE.blacklistBlock(Blocks.VOID_AIR);
    }

    @SubscribeEvent
    public static void creativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            ITEMS.getEntries().stream().map(RegistryObject::get).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    private static /* synthetic */ BlockItem lambda$register$31(Supplier waxedOxidizedCopper, String waxedoxidizedCopperId) {
        return new BlockItem((Block)waxedOxidizedCopper.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(waxedoxidizedCopperId)));
    }

    private static /* synthetic */ BlockItem lambda$register$30(Supplier waxedWeatheredCopper, String waxedweatheredCopperId) {
        return new BlockItem((Block)waxedWeatheredCopper.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(waxedweatheredCopperId)));
    }

    private static /* synthetic */ BlockItem lambda$register$29(Supplier waxedExposedCopper, String waxedexposedCopperId) {
        return new BlockItem((Block)waxedExposedCopper.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(waxedexposedCopperId)));
    }

    private static /* synthetic */ BlockItem lambda$register$28(Supplier waxedCopper, String waxedCopperId) {
        return new BlockItem((Block)waxedCopper.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(waxedCopperId)));
    }

    private static /* synthetic */ BlockItem lambda$register$27(Supplier oxidizedCopper, String oxidizedCopperId) {
        return new BlockItem((Block)oxidizedCopper.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(oxidizedCopperId)));
    }

    private static /* synthetic */ BlockItem lambda$register$26(Supplier weatheredCopper, String weatheredCopperId) {
        return new BlockItem((Block)weatheredCopper.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(weatheredCopperId)));
    }

    private static /* synthetic */ BlockItem lambda$register$25(Supplier exposedCopper, String exposedCopperId) {
        return new BlockItem((Block)exposedCopper.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(exposedCopperId)));
    }

    private static /* synthetic */ BlockItem lambda$register$24(Supplier copperLantern, String copperLanterinoId) {
        return new BlockItem((Block)copperLantern.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(copperLanterinoId)));
    }

    private static /* synthetic */ BlockItem lambda$register$23(Supplier lanterinoBlock, String lanterinoPath) {
        return new BlockItem((Block)lanterinoBlock.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(lanterinoPath)));
    }

    private static /* synthetic */ BlockItem lambda$register$22(Supplier jackoLanterinoBlock, String jackoLanterinoPath) {
        return new BlockItem((Block)jackoLanterinoBlock.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(jackoLanterinoPath)));
    }

    private static /* synthetic */ StandingAndWallBlockItem lambda$register$21(Supplier standingBlock, Supplier wallBlock, String torcherinoPath) {
        return new StandingAndWallBlockItem((Block)standingBlock.get(), (Block)wallBlock.get(), Direction.DOWN, new Item.Properties().useBlockDescriptionPrefix().setId(Torcherino.KeyofItem(torcherinoPath)));
    }

    private static /* synthetic */ ForgeWallTorcherinoBlock lambda$register$2(String torcherinoPath, Supplier standingBlock, ResourceLocation tierID) {
        return new ForgeWallTorcherinoBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).pushReaction(PushReaction.IGNORE).setId(Torcherino.KeyofBlock("wall_" + torcherinoPath)).overrideDescription(((ForgeTorcherinoBlock)standingBlock.get()).getDescriptionId()).overrideLootTable(((ForgeTorcherinoBlock)standingBlock.get()).getLootTable()), tierID);
    }

    static {
        toBlacklist = new HashSet<ResourceLocation>();
    }
}

