/*
 * Decompiled with CFR 0.152.
 */
package torcherino;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import torcherino.ModContent;
import torcherino.api.TorcherinoAPI;
import torcherino.block.api.LanterinoOxidizableRegistry;
import torcherino.config.Config;
import torcherino.platform.NetworkUtilsImpl;

@Mod(value="torcherino")
public final class Torcherino {
    public static final Logger LOGGER = LogManager.getLogger(Torcherino.class);
    public static final String MOD_ID = "torcherino";

    public static ResourceLocation resloc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static ResourceKey<Block> KeyofBlock(String path) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path));
    }

    public static ResourceKey<Item> KeyofItem(String path) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path));
    }

    public Torcherino(FMLJavaModLoadingContext context) {
        BusGroup eventBus = context.getModBusGroup();
        Config.initialize();
        ModContent.initialise(eventBus);
        NetworkUtilsImpl.getInstance().initialize();
        FMLCommonSetupEvent.getBus((BusGroup)eventBus).addListener(this::init);
        InterModProcessEvent.getBus((BusGroup)eventBus).addListener(this::processIMC);
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> LanterinoOxidizableRegistry.init());
    }

    public static ResourceLocation getRl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @SubscribeEvent
    public void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            String method = message.getMethod();
            Object value = message.getMessageSupplier().get();
            if (method.equals("blacklist_block")) {
                if (value instanceof ResourceLocation) {
                    TorcherinoAPI.INSTANCE.blacklistBlock((ResourceLocation)value);
                } else if (value instanceof Block) {
                    TorcherinoAPI.INSTANCE.blacklistBlock((Block)value);
                } else {
                    LOGGER.error("Received blacklist_block message with invalid value, must be either a Block or ResourceLocation.");
                }
            } else if (method.equals("blacklist_tile")) {
                if (value instanceof ResourceLocation) {
                    TorcherinoAPI.INSTANCE.blacklistBlockEntity((ResourceLocation)value);
                } else if (value instanceof BlockEntityType) {
                    TorcherinoAPI.INSTANCE.blacklistBlockEntity((BlockEntityType)value);
                } else {
                    LOGGER.error("Received blacklist_tile message with invalid value, must be either a TileEntityType or ResourceLocation.");
                }
            } else {
                LOGGER.error("Received IMC message with invalid method, must be either: \"blacklist_block\" or \"blacklist_tile\".");
            }
        });
    }
}

