/*
 * Decompiled with CFR 0.152.
 */
package torcherino;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import torcherino.api.Tier;
import torcherino.api.TorcherinoAPI;

public final class TorcherinoImpl
implements TorcherinoAPI {
    public static final String MOD_ID = "torcherino";
    public static final Logger LOGGER = LogManager.getLogger((String)"torcherino-api");
    private final Map<ResourceLocation, Tier> localTiers = new HashMap<ResourceLocation, Tier>();
    private final Set<Block> blacklistedBlocks = new HashSet<Block>();
    private final Set<BlockEntityType<?>> blacklistedTiles = new HashSet();
    private Map<ResourceLocation, Tier> remoteTiers = new HashMap<ResourceLocation, Tier>();

    public void registerTier(ResourceLocation name, int maxSpeed, int xzRange, int yRange) {
        if (this.localTiers.containsKey(name)) {
            LOGGER.warn("Tier with id {} has already been registered.", (Object)name);
            return;
        }
        Tier tier = new Tier(maxSpeed, xzRange, yRange);
        this.localTiers.put(name, tier);
    }

    @Override
    public boolean blacklistBlock(ResourceLocation blockId) {
        Optional block = BuiltInRegistries.BLOCK.getOptional(blockId);
        if (block.isPresent()) {
            if (this.blacklistedBlocks.contains(block.get())) {
                LOGGER.warn("Block with id {} is already blacklisted.", (Object)block);
                return false;
            }
            this.blacklistedBlocks.add((Block)block.get());
            return true;
        }
        LOGGER.warn("Block with id {} does not exist.", (Object)block);
        return false;
    }

    @Override
    public boolean blacklistBlock(Block block) {
        if (this.blacklistedBlocks.contains(block)) {
            LOGGER.warn("Block with id {} is already blacklisted.", (Object)BuiltInRegistries.BLOCK.getKey((Object)block));
            return false;
        }
        this.blacklistedBlocks.add(block);
        return true;
    }

    @Override
    public boolean isBlockBlacklisted(Block block) {
        return this.blacklistedBlocks.contains(block);
    }

    @Override
    public boolean blacklistBlockEntity(ResourceLocation blockEntityTypeId) {
        Optional blockEntityType = BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(blockEntityTypeId);
        if (blockEntityType.isPresent()) {
            if (this.blacklistedTiles.contains(blockEntityType.get())) {
                LOGGER.warn("BlockEntityType with id {} is already blacklisted.", (Object)blockEntityTypeId);
                return false;
            }
            this.blacklistedTiles.add((BlockEntityType)blockEntityType.get());
            return true;
        }
        LOGGER.warn("BlockEntityType with id {} does not exist.", (Object)blockEntityTypeId);
        return false;
    }

    @Override
    public boolean blacklistBlockEntity(BlockEntityType<?> blockEntityType) {
        if (this.blacklistedTiles.contains(blockEntityType)) {
            LOGGER.warn("BlockEntityType with id {} is already blacklisted.", (Object)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(blockEntityType));
            return false;
        }
        this.blacklistedTiles.add(blockEntityType);
        return true;
    }

    @Override
    public boolean isBlockEntityBlacklisted(BlockEntityType<?> blockEntityType) {
        return this.blacklistedTiles.contains(blockEntityType);
    }

    public void setRemoteTiers(Map<ResourceLocation, Tier> tiers) {
        this.remoteTiers = tiers;
    }

    @Override
    public ImmutableMap<ResourceLocation, Tier> getTiers() {
        return ImmutableMap.copyOf(this.localTiers);
    }

    @Override
    public Tier getTier(ResourceLocation name) {
        return this.remoteTiers.getOrDefault(name, null);
    }
}

