/*
 * Decompiled with CFR 0.152.
 */
package torcherino.block;

import com.google.common.collect.BiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import torcherino.api.TierSupplier;
import torcherino.block.TorcherinoLogic;
import torcherino.block.api.LanterinoOxidizableRegistry;
import torcherino.block.entity.TorcherinoBlockEntity;

public class CopperLanterinoBlock
extends LanternBlock
implements EntityBlock,
TierSupplier {
    private final ResourceLocation tierID;
    private static final Map<ResourceLocation, Supplier<BiMap<Block, Block>>> NEXT_BY_TIER = new HashMap<ResourceLocation, Supplier<BiMap<Block, Block>>>();
    private static final Map<ResourceLocation, Supplier<BiMap<Block, Block>>> PREVIOUS_BY_TIER = new HashMap<ResourceLocation, Supplier<BiMap<Block, Block>>>();
    private static final Map<ResourceLocation, Supplier<BiMap<Block, Block>>> WAXABLES_BY_TIER = new HashMap<ResourceLocation, Supplier<BiMap<Block, Block>>>();
    private static final Map<ResourceLocation, Supplier<BiMap<Block, Block>>> UNWAXABLES_BY_TIER = new HashMap<ResourceLocation, Supplier<BiMap<Block, Block>>>();

    public CopperLanterinoBlock(BlockBehaviour.Properties properties, ResourceLocation tier) {
        super(properties);
        this.tierID = tier;
    }

    private static boolean isEmittingStrongRedstonePower(Level level, BlockPos pos, Direction direction) {
        return level.getBlockState(pos).getDirectSignal((BlockGetter)level, pos, direction) > 0;
    }

    @Override
    public ResourceLocation getTier() {
        return this.tierID;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TorcherinoBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TorcherinoLogic.getTicker(level, state, type);
    }

    @Deprecated
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public void onPlace(BlockState newState, Level level, BlockPos pos, BlockState state, boolean boolean_1) {
        this.neighborChanged(null, level, pos, null, null, false);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionHand hand = InteractionHand.MAIN_HAND;
        return TorcherinoLogic.useWithoutItem(state, level, pos, player, hand, hit);
    }

    @NotNull
    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BiMap<Block, Block> waxables;
        Block waxed;
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        boolean handled = false;
        if (item == Items.HONEYCOMB && !level.isClientSide() && (waxed = (Block)(waxables = LanterinoOxidizableRegistry.getWaxMap(this.tierID)).get((Object)state.getBlock())) != null) {
            CopperLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, waxed.defaultBlockState());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.levelEvent((Entity)player, 3003, pos, 0);
            handled = true;
        }
        if (item instanceof AxeItem && !level.isClientSide()) {
            BiMap<Block, Block> prevMap;
            Block prev;
            BiMap<Block, Block> waxOffMap = LanterinoOxidizableRegistry.getUnwaxMap(this.tierID);
            Block unwaxed = (Block)waxOffMap.get((Object)state.getBlock());
            if (unwaxed != null) {
                CopperLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, unwaxed.defaultBlockState());
                stack.hurtAndBreak(1, (ServerLevel)level, null, p -> {});
                level.levelEvent((Entity)player, 3005, pos, 0);
                handled = true;
            }
            if ((prev = (Block)(prevMap = LanterinoOxidizableRegistry.getPreviousByBlock(this.tierID)).get((Object)state.getBlock())) != null) {
                CopperLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, prev.defaultBlockState());
                stack.hurtAndBreak(1, (ServerLevel)level, null, p -> {});
                level.levelEvent((Entity)player, 3004, pos, 0);
                handled = true;
            }
        }
        return handled ? InteractionResult.SUCCESS : super.useItemOn(itemStack, state, level, pos, player, hand, hit);
    }

    public static void swapPreserveTorcherinoBE(ServerLevel level, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockEntity oldBE = level.getBlockEntity(pos);
        TorcherinoBlockEntity.Data data = null;
        if (oldBE instanceof TorcherinoBlockEntity) {
            TorcherinoBlockEntity torcherino = (TorcherinoBlockEntity)oldBE;
            data = TorcherinoBlockEntity.Data.from(torcherino);
        }
        level.setBlock(pos, newState, 3);
        BlockEntity newBE = level.getBlockEntity(pos);
        if (data != null && newBE instanceof TorcherinoBlockEntity) {
            TorcherinoBlockEntity torcherino = (TorcherinoBlockEntity)newBE;
            torcherino.restore(data);
            torcherino.setChanged();
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, Orientation orientation, boolean boolean_1) {
        TorcherinoLogic.neighborUpdate(state, level, pos, neighborBlock, orientation, boolean_1, be -> {
            if (state == null) {
                return;
            }
            if (((Boolean)state.getValue((Property)BlockStateProperties.HANGING)).equals(true)) {
                be.setPoweredByRedstone(level.hasSignal(pos.above(), Direction.UP));
            } else {
                boolean powered = CopperLanterinoBlock.isEmittingStrongRedstonePower(level, pos.west(), Direction.WEST) || CopperLanterinoBlock.isEmittingStrongRedstonePower(level, pos.east(), Direction.EAST) || CopperLanterinoBlock.isEmittingStrongRedstonePower(level, pos.south(), Direction.SOUTH) || CopperLanterinoBlock.isEmittingStrongRedstonePower(level, pos.north(), Direction.NORTH);
                be.setPoweredByRedstone(powered);
            }
        });
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TorcherinoLogic.onPlaced(level, pos, state, placer, stack, (Block)this);
    }
}

