/*
 * Decompiled with CFR 0.152.
 */
package torcherino.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import torcherino.api.TierSupplier;
import torcherino.block.ForgeTorcherinoBlock;
import torcherino.block.TorcherinoLogic;
import torcherino.block.entity.TorcherinoBlockEntity;
import torcherino.particle.TorcherinoParticleTypes;

public final class ForgeWallTorcherinoBlock
extends ForgeTorcherinoBlock
implements EntityBlock,
TierSupplier {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    protected static final float AABB_OFFSET = 2.5f;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    private final ResourceLocation tierID;

    public ForgeWallTorcherinoBlock(BlockBehaviour.Properties properties, ResourceLocation tier) {
        super(properties, tier);
        this.tierID = tier;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public VoxelShape getShape(BlockState p_58152_, BlockGetter p_58153_, BlockPos p_58154_, CollisionContext p_58155_) {
        return ForgeWallTorcherinoBlock.getShape(p_58152_);
    }

    public static VoxelShape getShape(BlockState p_58157_) {
        return AABBS.get(p_58157_.getValue(FACING));
    }

    @Override
    public boolean canSurvive(BlockState p_58133_, LevelReader p_58134_, BlockPos p_58135_) {
        Direction $$3 = (Direction)p_58133_.getValue(FACING);
        BlockPos $$4 = p_58135_.relative($$3.getOpposite());
        BlockState $$5 = p_58134_.getBlockState($$4);
        return $$5.isFaceSturdy((BlockGetter)p_58134_, $$4, $$3);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_58126_) {
        Direction[] $$4;
        BlockState $$1 = this.defaultBlockState();
        Level $$2 = p_58126_.getLevel();
        BlockPos $$3 = p_58126_.getClickedPos();
        Direction[] var6 = $$4 = p_58126_.getNearestLookingDirections();
        int var7 = $$4.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction $$6;
            Direction $$5 = var6[var8];
            if (!$$5.getAxis().isHorizontal() || !($$1 = (BlockState)$$1.setValue(FACING, (Comparable)($$6 = $$5.getOpposite()))).canSurvive((LevelReader)$$2, $$3)) continue;
            return $$1;
        }
        return null;
    }

    @Override
    protected BlockState updateShape(BlockState p_58143_, LevelReader p_374329_, ScheduledTickAccess p_374207_, BlockPos p_58147_, Direction p_58144_, BlockPos p_58148_, BlockState p_58145_, RandomSource p_374234_) {
        return p_58144_.getOpposite() == p_58143_.getValue(FACING) && !p_58143_.canSurvive(p_374329_, p_58147_) ? Blocks.AIR.defaultBlockState() : p_58143_;
    }

    public BlockState rotate(BlockState p_58140_, Rotation p_58141_) {
        return (BlockState)p_58140_.setValue(FACING, (Comparable)p_58141_.rotate((Direction)p_58140_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_58137_, Mirror p_58138_) {
        return p_58137_.rotate(p_58138_.getRotation((Direction)p_58137_.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_58150_) {
        p_58150_.add(new Property[]{FACING});
    }

    @Override
    public ResourceLocation getTier() {
        return this.tierID;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TorcherinoBlockEntity(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TorcherinoLogic.getTicker(level, state, type);
    }

    @Deprecated
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.IGNORE;
    }

    @Override
    public void onPlace(BlockState newState, Level level, BlockPos pos, BlockState state, boolean boolean_1) {
        this.neighborChanged(newState, level, pos, null, null, false);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionHand hand = InteractionHand.MAIN_HAND;
        return TorcherinoLogic.useWithoutItem(state, level, pos, player, hand, hit);
    }

    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, Orientation orientation, boolean boolean_1) {
        TorcherinoLogic.neighborUpdate(state, level, pos, neighborBlock, orientation, boolean_1, be -> be.setPoweredByRedstone(level.hasNeighborSignal(pos)));
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TorcherinoLogic.onPlaced(level, pos, state, placer, stack, this);
    }

    @Override
    public void animateTick(BlockState $$0, Level $$1, BlockPos $$2, RandomSource $$3) {
        Direction $$4 = (Direction)$$0.getValue(FACING);
        double $$5 = (double)$$2.getX() + 0.5;
        double $$6 = (double)$$2.getY() + 0.7;
        double $$7 = (double)$$2.getZ() + 0.5;
        double $$8 = 0.22;
        double $$9 = 0.27;
        Direction $$10 = $$4.getOpposite();
        $$1.addParticle((ParticleOptions)ParticleTypes.SMOKE, $$5 + 0.27 * (double)$$10.getStepX(), $$6 + 0.22, $$7 + 0.27 * (double)$$10.getStepZ(), 0.0, 0.0, 0.0);
        ResourceLocation blockName = ForgeRegistries.BLOCKS.getKey((Object)$$0.getBlock());
        if (blockName != null && blockName.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)"wall_torcherino"))) {
            $$1.addParticle((ParticleOptions)TorcherinoParticleTypes.Normal_Torcherino_Flame.get(), $$5 + 0.27 * (double)$$10.getStepX(), $$6 + 0.22, $$7 + 0.27 * (double)$$10.getStepZ(), 0.0, 0.0, 0.0);
        } else if (blockName != null && blockName.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)"wall_compressed_torcherino"))) {
            $$1.addParticle((ParticleOptions)TorcherinoParticleTypes.Compressed_Torcherino_Flame.get(), $$5 + 0.27 * (double)$$10.getStepX(), $$6 + 0.22, $$7 + 0.27 * (double)$$10.getStepZ(), 0.0, 0.0, 0.0);
        } else if (blockName != null && blockName.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)"wall_double_compressed_torcherino"))) {
            $$1.addParticle((ParticleOptions)TorcherinoParticleTypes.Double_Compressed_Torcherino_Flame.get(), $$5 + 0.27 * (double)$$10.getStepX(), $$6 + 0.22, $$7 + 0.27 * (double)$$10.getStepZ(), 0.0, 0.0, 0.0);
        }
    }
}

