/*
 * Decompiled with CFR 0.152.
 */
package torcherino.block;

import com.google.common.collect.BiMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import torcherino.api.TierSupplier;
import torcherino.block.CopperLanterinoBlock;
import torcherino.block.api.LanterinoDegradable;
import torcherino.block.api.LanterinoOxidizableRegistry;
import torcherino.block.entity.TorcherinoBlockEntity;

public class WeatheringLanterinoBlock
extends CopperLanterinoBlock
implements LanterinoDegradable,
EntityBlock,
TierSupplier {
    private final LanterinoDegradable.DegradationLevel weatherState;
    private final ResourceLocation tierID;

    public WeatheringLanterinoBlock(LanterinoDegradable.DegradationLevel weatherState, BlockBehaviour.Properties properties, ResourceLocation tier) {
        super(properties, tier);
        this.weatherState = weatherState;
        this.tierID = tier;
    }

    @Override
    public ResourceLocation getTier() {
        return this.tierID;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity newBE;
        this.changeOverTime(state, level, pos, random);
        BlockEntity be = level.getBlockEntity(pos);
        Optional<Block> nextOpt = LanterinoDegradable.getNext(state.getBlock(), this.getTier());
        TorcherinoBlockEntity.Data saved = null;
        if (be instanceof TorcherinoBlockEntity) {
            TorcherinoBlockEntity oldBE = (TorcherinoBlockEntity)be;
            saved = TorcherinoBlockEntity.Data.from(oldBE);
        }
        BlockState newState = nextOpt.get().defaultBlockState();
        level.setBlock(pos, newState, 3);
        if (saved != null && (newBE = level.getBlockEntity(pos)) instanceof TorcherinoBlockEntity) {
            TorcherinoBlockEntity torcherinoBE = (TorcherinoBlockEntity)newBE;
            torcherinoBE.restore(saved);
        }
    }

    @Override
    @NotNull
    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BiMap<Block, Block> waxables;
        Block waxed;
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        boolean handled = false;
        if (item == Items.HONEYCOMB && !level.isClientSide() && (waxed = (Block)(waxables = LanterinoOxidizableRegistry.getWaxMap(this.getTier())).get((Object)state.getBlock())) != null) {
            WeatheringLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, waxed.defaultBlockState());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.levelEvent((Entity)player, 3003, pos, 0);
            handled = true;
        }
        if (item instanceof AxeItem && !level.isClientSide()) {
            BiMap<Block, Block> prevMap;
            Block prev;
            BiMap<Block, Block> waxOffMap = LanterinoOxidizableRegistry.getUnwaxMap(this.getTier());
            Block unwaxed = (Block)waxOffMap.get((Object)state.getBlock());
            if (unwaxed != null) {
                WeatheringLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, unwaxed.defaultBlockState());
                stack.hurtAndBreak(1, (ServerLevel)level, null, p -> {});
                level.levelEvent((Entity)player, 3005, pos, 0);
                handled = true;
            }
            if ((prev = (Block)(prevMap = LanterinoOxidizableRegistry.getPreviousByBlock(this.getTier())).get((Object)state.getBlock())) != null) {
                WeatheringLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, prev.defaultBlockState());
                stack.hurtAndBreak(1, (ServerLevel)level, null, p -> {});
                level.levelEvent((Entity)player, 3004, pos, 0);
                handled = true;
            }
        }
        return handled ? InteractionResult.SUCCESS : super.useItemOn(itemStack, state, level, pos, player, hand, hit);
    }

    public static void swapPreserveTorcherinoBE(ServerLevel level, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockEntity oldBE = level.getBlockEntity(pos);
        TorcherinoBlockEntity.Data data = null;
        if (oldBE instanceof TorcherinoBlockEntity) {
            TorcherinoBlockEntity torcherino = (TorcherinoBlockEntity)oldBE;
            data = TorcherinoBlockEntity.Data.from(torcherino);
        }
        level.setBlock(pos, newState, 3);
        BlockEntity newBE = level.getBlockEntity(pos);
        if (data != null && newBE instanceof TorcherinoBlockEntity) {
            TorcherinoBlockEntity torcherino = (TorcherinoBlockEntity)newBE;
            torcherino.restore(data);
            torcherino.setChanged();
        }
    }

    protected boolean isRandomlyTicking(BlockState blockState) {
        return LanterinoDegradable.getNext(blockState.getBlock(), this.getTier()).isPresent();
    }

    public LanterinoDegradable.DegradationLevel getAge() {
        return this.weatherState;
    }
}

