/*
 * Decompiled with CFR 0.152.
 */
package torcherino.block.api;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;
import torcherino.block.WeatheringLanterinoBlock;
import torcherino.block.api.LanterinoOxidizableRegistry;

public interface LanterinoDegradable
extends ChangeOverTimeBlock<DegradationLevel> {
    public static Optional<Block> getPrevious(Block pBlock) {
        if (pBlock instanceof WeatheringLanterinoBlock) {
            WeatheringLanterinoBlock weatheringLanterinoBlock = (WeatheringLanterinoBlock)pBlock;
            ResourceLocation tierID = weatheringLanterinoBlock.getTier();
            return Optional.ofNullable((Block)LanterinoOxidizableRegistry.getPreviousByBlock(tierID).get((Object)pBlock));
        }
        return Optional.empty();
    }

    public static Block getFirst(Block pBlock) {
        Block block = pBlock;
        if (block instanceof WeatheringLanterinoBlock) {
            WeatheringLanterinoBlock weatheringLanterinoBlock = (WeatheringLanterinoBlock)block;
            ResourceLocation tierID = weatheringLanterinoBlock.getTier();
            Block block1 = (Block)LanterinoOxidizableRegistry.getPreviousByBlock(tierID).get((Object)pBlock);
            while (block1 != null) {
                block = block1;
                block1 = (Block)LanterinoOxidizableRegistry.getPreviousByBlock(tierID).get((Object)block1);
            }
        }
        return block;
    }

    public static Optional<BlockState> getPrevious(BlockState pState) {
        return LanterinoDegradable.getPrevious(pState.getBlock()).map(p_154903_ -> p_154903_.withPropertiesOf(pState));
    }

    public static Optional<Block> getNext(Block pBlock, ResourceLocation tierID) {
        return Optional.ofNullable((Block)LanterinoOxidizableRegistry.getNextByBlock(tierID).get((Object)pBlock));
    }

    public static BlockState getFirst(BlockState pState) {
        return LanterinoDegradable.getFirst(pState.getBlock()).withPropertiesOf(pState);
    }

    default public Optional<BlockState> getNext(BlockState pState) {
        Block block = pState.getBlock();
        if (block instanceof WeatheringLanterinoBlock) {
            WeatheringLanterinoBlock weatheringLanterinoBlock = (WeatheringLanterinoBlock)block;
            ResourceLocation tierID = weatheringLanterinoBlock.getTier();
            return LanterinoDegradable.getNext(pState.getBlock(), tierID).map(p_154896_ -> p_154896_.withPropertiesOf(pState));
        }
        return Optional.empty();
    }

    default public float getChanceModifier() {
        return this.getAge() == DegradationLevel.UNAFFECTED ? 0.75f : 1.0f;
    }

    public static enum DegradationLevel {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

