/*
 * Decompiled with CFR 0.152.
 */
package torcherino.block.api;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import torcherino.block.CopperLanterinoBlock;
import torcherino.block.WeatheringLanterinoBlock;

public class LanterinoOxidizableRegistry {
    private static final Map<ResourceLocation, java.util.function.Supplier<BiMap<Block, Block>>> NEXT_BY_TIER = new HashMap<ResourceLocation, java.util.function.Supplier<BiMap<Block, Block>>>();
    private static final Map<ResourceLocation, java.util.function.Supplier<BiMap<Block, Block>>> PREVIOUS_BY_TIER = new HashMap<ResourceLocation, java.util.function.Supplier<BiMap<Block, Block>>>();
    private static final Map<ResourceLocation, java.util.function.Supplier<BiMap<Block, Block>>> WAXABLES_BY_TIER = new HashMap<ResourceLocation, java.util.function.Supplier<BiMap<Block, Block>>>();
    private static final Map<ResourceLocation, java.util.function.Supplier<BiMap<Block, Block>>> UNWAXABLES_BY_TIER = new HashMap<ResourceLocation, java.util.function.Supplier<BiMap<Block, Block>>>();
    private static final List<Runnable> pendingRegistrations = new ArrayList<Runnable>();

    public static void addPendingTier(ResourceLocation tierID, java.util.function.Supplier<WeatheringLanterinoBlock> copper, java.util.function.Supplier<WeatheringLanterinoBlock> exposed, java.util.function.Supplier<WeatheringLanterinoBlock> weathered, java.util.function.Supplier<WeatheringLanterinoBlock> oxidized, java.util.function.Supplier<CopperLanterinoBlock> waxed, java.util.function.Supplier<CopperLanterinoBlock> waxedExposed, java.util.function.Supplier<CopperLanterinoBlock> waxedWeathered, java.util.function.Supplier<CopperLanterinoBlock> waxedOxidized) {
        pendingRegistrations.add(() -> LanterinoOxidizableRegistry.registerTier(tierID, copper, exposed, weathered, oxidized, waxed, waxedExposed, waxedWeathered, waxedOxidized));
    }

    public static void init() {
        for (Runnable r : pendingRegistrations) {
            r.run();
        }
        pendingRegistrations.clear();
    }

    public static void debugPrintAll() {
        System.out.println("===== LanterinoOxidizableRegistry DEBUG =====");
        for (ResourceLocation tierID : NEXT_BY_TIER.keySet()) {
            Object e2;
            System.out.println("Tier: " + String.valueOf(tierID));
            BiMap<Block, Block> next = NEXT_BY_TIER.get(tierID).get();
            System.out.println("  NEXT:");
            for (Object e2 : next.entrySet()) {
                System.out.println("    " + ((Block)e2.getKey()).toString() + " -> " + ((Block)e2.getValue()).toString());
            }
            BiMap<Block, Block> prev = PREVIOUS_BY_TIER.get(tierID).get();
            System.out.println("  PREVIOUS:");
            e2 = prev.entrySet().iterator();
            while (e2.hasNext()) {
                Map.Entry e3 = (Map.Entry)e2.next();
                System.out.println("    " + ((Block)e3.getKey()).toString() + " -> " + ((Block)e3.getValue()).toString());
            }
            BiMap<Block, Block> wax = WAXABLES_BY_TIER.get(tierID).get();
            System.out.println("  WAXABLES:");
            for (Map.Entry e4 : wax.entrySet()) {
                System.out.println("    " + ((Block)e4.getKey()).toString() + " -> " + ((Block)e4.getValue()).toString());
            }
            BiMap<Block, Block> unwax = UNWAXABLES_BY_TIER.get(tierID).get();
            System.out.println("  UNWAXABLES:");
            for (Map.Entry e5 : unwax.entrySet()) {
                System.out.println("    " + ((Block)e5.getKey()).toString() + " -> " + ((Block)e5.getValue()).toString());
            }
        }
        System.out.println("===== END DEBUG =====");
    }

    private static void registerTier(ResourceLocation tierID, java.util.function.Supplier<WeatheringLanterinoBlock> copper, java.util.function.Supplier<WeatheringLanterinoBlock> exposed, java.util.function.Supplier<WeatheringLanterinoBlock> weathered, java.util.function.Supplier<WeatheringLanterinoBlock> oxidized, java.util.function.Supplier<CopperLanterinoBlock> waxed, java.util.function.Supplier<CopperLanterinoBlock> waxedExposed, java.util.function.Supplier<CopperLanterinoBlock> waxedWeathered, java.util.function.Supplier<CopperLanterinoBlock> waxedOxidized) {
        Supplier nextMap = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)copper.get()), (Object)((Block)exposed.get())).put((Object)((Block)exposed.get()), (Object)((Block)weathered.get())).put((Object)((Block)weathered.get()), (Object)((Block)oxidized.get())).build());
        NEXT_BY_TIER.put(tierID, (java.util.function.Supplier<BiMap<Block, Block>>)nextMap);
        PREVIOUS_BY_TIER.put(tierID, (java.util.function.Supplier<BiMap<Block, Block>>)Suppliers.memoize(() -> LanterinoOxidizableRegistry.lambda$registerTier$2((java.util.function.Supplier)nextMap)));
        Supplier waxMap = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)copper.get()), (Object)((Block)waxed.get())).put((Object)((Block)exposed.get()), (Object)((Block)waxedExposed.get())).put((Object)((Block)weathered.get()), (Object)((Block)waxedWeathered.get())).put((Object)((Block)oxidized.get()), (Object)((Block)waxedOxidized.get())).build());
        WAXABLES_BY_TIER.put(tierID, (java.util.function.Supplier<BiMap<Block, Block>>)waxMap);
        UNWAXABLES_BY_TIER.put(tierID, (java.util.function.Supplier<BiMap<Block, Block>>)Suppliers.memoize(() -> LanterinoOxidizableRegistry.lambda$registerTier$4((java.util.function.Supplier)waxMap)));
    }

    public static BiMap<Block, Block> getNextByBlock(ResourceLocation tierID) {
        return NEXT_BY_TIER.getOrDefault(tierID, (java.util.function.Supplier<BiMap<Block, Block>>)Suppliers.memoize(ImmutableBiMap::of)).get();
    }

    public static BiMap<Block, Block> getPreviousByBlock(ResourceLocation tierID) {
        return PREVIOUS_BY_TIER.getOrDefault(tierID, (java.util.function.Supplier<BiMap<Block, Block>>)Suppliers.memoize(ImmutableBiMap::of)).get();
    }

    public static BiMap<Block, Block> getWaxMap(ResourceLocation tierID) {
        return WAXABLES_BY_TIER.getOrDefault(tierID, (java.util.function.Supplier<BiMap<Block, Block>>)Suppliers.memoize(ImmutableBiMap::of)).get();
    }

    public static BiMap<Block, Block> getUnwaxMap(ResourceLocation tierID) {
        return UNWAXABLES_BY_TIER.getOrDefault(tierID, (java.util.function.Supplier<BiMap<Block, Block>>)Suppliers.memoize(ImmutableBiMap::of)).get();
    }

    private static /* synthetic */ BiMap lambda$registerTier$4(java.util.function.Supplier waxMap) {
        return ((BiMap)waxMap.get()).inverse();
    }

    private static /* synthetic */ BiMap lambda$registerTier$2(java.util.function.Supplier nextMap) {
        return ((BiMap)nextMap.get()).inverse();
    }
}

