/*
 * Decompiled with CFR 0.152.
 */
package torcherino.block.entity;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import torcherino.api.Tier;
import torcherino.api.TierSupplier;
import torcherino.api.TorcherinoAPI;
import torcherino.config.Config;
import torcherino.platform.NetworkUtils;

public class TorcherinoBlockEntity
extends BlockEntity
implements Nameable,
TierSupplier {
    public static int randomTicks;
    private Component customName;
    private int xRange;
    private int yRange;
    private int zRange;
    private int speed;
    private int redstoneMode;
    private Iterable<BlockPos> area;
    private boolean active;
    private ResourceLocation tierID;
    private String uuid = "";

    public TorcherinoBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)((Holder.Reference)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)"torcherino")).get()).value(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TorcherinoBlockEntity entity) {
        if (!entity.active || entity.speed == 0 || entity.xRange == 0 && entity.yRange == 0 && entity.zRange == 0) {
            return;
        }
        if (!Config.INSTANCE.online_mode.equals("") && !NetworkUtils.getInstance().s_isPlayerOnline(entity.getOwner())) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            randomTicks = serverlevel.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        }
        entity.area.forEach(entity::tickBlock);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public String getOwner() {
        return this.uuid;
    }

    public void setOwner(String s) {
        this.uuid = s;
    }

    @NotNull
    public Component getName() {
        return this.hasCustomName() ? this.customName : Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public void setLevel(@NotNull Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            level.getServer().schedule((Runnable)new TickTask(level.getServer().getTickCount(), () -> this.getBlockState().handleNeighborChanged(level, this.worldPosition, null, null, false)));
        }
    }

    private void tickBlock(BlockPos pos) {
        BlockState blockState = this.level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (TorcherinoAPI.INSTANCE.isBlockBlacklisted(block)) {
            return;
        }
        if (this.level instanceof ServerLevel && blockState.isRandomlyTicking() && this.level.tickRateManager().runsNormally() && this.level.getRandom().nextInt(Mth.clamp((int)(4096 / (this.speed * Config.INSTANCE.random_tick_rate)), (int)1, (int)4096)) < randomTicks) {
            blockState.randomTick((ServerLevel)this.level, pos, this.level.getRandom());
        }
        if (!(block instanceof EntityBlock)) {
            return;
        }
        EntityBlock entityBlock = (EntityBlock)block;
        BlockEntity blockEntity = this.level.getBlockEntity(pos);
        if (blockEntity != null) {
            BlockEntityTicker ticker = entityBlock.getTicker(this.level, blockState, blockEntity.getType());
            if (blockEntity.isRemoved() || TorcherinoAPI.INSTANCE.isBlockEntityBlacklisted(blockEntity.getType()) || ticker == null) {
                return;
            }
            for (int i = 0; i < this.speed && !blockEntity.isRemoved(); ++i) {
                ticker.tick(this.level, pos, blockState, blockEntity);
            }
        }
    }

    public boolean readClientData(int xRange, int zRange, int yRange, int speed, int redstoneMode) {
        Tier tier = (Tier)TorcherinoAPI.INSTANCE.getTiers().get((Object)this.getTier());
        if (this.valueInRange(xRange, 0, tier.xzRange()) && this.valueInRange(zRange, 0, tier.xzRange()) && this.valueInRange(yRange, 0, tier.yRange()) && this.valueInRange(speed, 0, tier.maxSpeed()) && this.valueInRange(redstoneMode, 0, 3)) {
            this.xRange = xRange;
            this.zRange = zRange;
            this.yRange = yRange;
            this.speed = speed;
            this.redstoneMode = redstoneMode;
            this.area = BlockPos.betweenClosed((int)(this.worldPosition.getX() - xRange), (int)(this.worldPosition.getY() - yRange), (int)(this.worldPosition.getZ() - zRange), (int)(this.worldPosition.getX() + xRange), (int)(this.worldPosition.getY() + yRange), (int)(this.worldPosition.getZ() + zRange));
            this.getBlockState().handleNeighborChanged(this.level, this.worldPosition, null, null, false);
            return true;
        }
        return false;
    }

    private boolean valueInRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    @Override
    public ResourceLocation getTier() {
        Block block;
        if (this.tierID == null && (block = this.getBlockState().getBlock()) instanceof TierSupplier) {
            TierSupplier supplier = (TierSupplier)block;
            this.tierID = supplier.getTier();
        }
        return this.tierID;
    }

    public void setPoweredByRedstone(boolean powered) {
        switch (this.redstoneMode) {
            case 0: {
                this.active = !powered;
                break;
            }
            case 1: {
                this.active = powered;
                break;
            }
            case 2: {
                this.active = true;
                break;
            }
            case 3: {
                this.active = false;
            }
        }
    }

    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        if (this.hasCustomName()) {
            Component customName = this.getCustomName();
            JsonElement json = (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)customName).getOrThrow(error -> {
                throw new IllegalStateException("Failed to serialize component: " + error);
            });
            tag.putString("CustomName", json.toString());
        }
        tag.putInt("XRange", this.xRange);
        tag.putInt("ZRange", this.zRange);
        tag.putInt("YRange", this.yRange);
        tag.putInt("Speed", this.speed);
        tag.putInt("RedstoneMode", this.redstoneMode);
        tag.putBoolean("Active", this.active);
        tag.putString("Owner", this.getOwner() == null ? "" : this.getOwner());
    }

    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        if (tag.equals((Object)"CustomName")) {
            String jsonString = String.valueOf(tag.getString("CustomName"));
            Component name = (Component)ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)jsonString)).getOrThrow(error -> {
                throw new IllegalStateException("Failed to deserialize component: " + error);
            });
            this.setCustomName(name);
        }
        this.xRange = tag.getInt("XRange").orElse(0);
        this.zRange = tag.getInt("ZRange").orElse(0);
        this.yRange = tag.getInt("YRange").orElse(0);
        this.speed = tag.getInt("Speed").orElse(1);
        this.redstoneMode = tag.getInt("RedstoneMode").orElse(0);
        this.active = tag.getBooleanOr("Active", false);
        this.uuid = String.valueOf(tag.getString("Owner"));
        this.area = BlockPos.betweenClosed((int)(this.worldPosition.getX() - this.xRange), (int)(this.worldPosition.getY() - this.yRange), (int)(this.worldPosition.getZ() - this.zRange), (int)(this.worldPosition.getX() + this.xRange), (int)(this.worldPosition.getY() + this.yRange), (int)(this.worldPosition.getZ() + this.zRange));
    }

    public void openTorcherinoScreen(ServerPlayer player) {
        NetworkUtils.getInstance().s2c_openTorcherinoScreen(player, this.worldPosition, this.getName(), this.xRange, this.zRange, this.yRange, this.speed, this.redstoneMode);
    }

    public void restore(Data data) {
        if (data.customName != null) {
            this.setCustomName(data.customName);
        }
        this.readClientData(data.xRange, data.zRange, data.yRange, data.speed, data.redstoneMode);
        this.active = data.active;
        this.setOwner(data.uuid);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static class Data {
        public final Component customName;
        public final int xRange;
        public final int yRange;
        public final int zRange;
        public final int speed;
        public final int redstoneMode;
        public final boolean active;
        public final String uuid;

        private Data(Component customName, int xRange, int yRange, int zRange, int speed, int redstoneMode, boolean active, String uuid) {
            this.customName = customName;
            this.xRange = xRange;
            this.yRange = yRange;
            this.zRange = zRange;
            this.speed = speed;
            this.redstoneMode = redstoneMode;
            this.active = active;
            this.uuid = uuid;
        }

        public static Data from(TorcherinoBlockEntity be) {
            return new Data(be.getCustomName(), be.xRange, be.yRange, be.zRange, be.speed, be.redstoneMode, be.active, be.getOwner());
        }
    }
}

