/*
 * Decompiled with CFR 0.152.
 */
package torcherino.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import torcherino.api.Tier;
import torcherino.api.TorcherinoAPI;
import torcherino.client.screen.widgets.GradatedSliderWidget;
import torcherino.client.screen.widgets.StateButtonWidget;
import torcherino.platform.NetworkUtils;

public final class TorcherinoScreen
extends Screen {
    private static final ResourceLocation SCREEN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)"textures/screens/torcherino.png");
    private static final int screenWidth = 245;
    private static final int screenHeight = 123;
    private final BlockPos blockPos;
    private final Tier tier;
    private final Component cached_title;
    private int xRange;
    private int zRange;
    private int yRange;
    private int speed;
    private int redstoneMode;
    private int left;
    private int top;

    public TorcherinoScreen(Component title, int xRange, int zRange, int yRange, int speed, int redstoneMode, BlockPos pos, ResourceLocation tierID) {
        super(title);
        this.tier = TorcherinoAPI.INSTANCE.getTier(tierID);
        this.blockPos = pos;
        this.xRange = xRange;
        this.zRange = zRange;
        this.yRange = yRange;
        this.speed = speed == 0 ? 1 : speed;
        this.redstoneMode = redstoneMode;
        this.cached_title = title;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.left = (this.width - 245) / 2;
        this.top = (this.height - 123) / 2;
        this.addRenderableWidget((GuiEventListener)new GradatedSliderWidget(this.left + 8, this.top + 20, 205, (double)(this.speed - 1) / (double)(this.tier.maxSpeed() - 1), this.tier.maxSpeed()){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"gui.torcherino.speed", (Object[])new Object[]{100 * TorcherinoScreen.this.speed}));
            }

            protected void applyValue() {
                TorcherinoScreen.this.speed = 1 + (int)Math.round(this.value * (double)(TorcherinoScreen.this.tier.maxSpeed() - 1));
                this.value = (double)(TorcherinoScreen.this.speed - 1) / (double)(TorcherinoScreen.this.tier.maxSpeed() - 1);
            }
        });
        this.addRenderableWidget((GuiEventListener)new GradatedSliderWidget(this.left + 8, this.top + 45, 205, (double)this.xRange / (double)this.tier.xzRange(), this.tier.xzRange()){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"gui.torcherino.x_range", (Object[])new Object[]{TorcherinoScreen.this.xRange * 2 + 1}));
            }

            protected void applyValue() {
                TorcherinoScreen.this.xRange = (int)Math.round(this.value * (double)TorcherinoScreen.this.tier.xzRange());
                this.value = (double)TorcherinoScreen.this.xRange / (double)TorcherinoScreen.this.tier.xzRange();
            }
        });
        this.addRenderableWidget((GuiEventListener)new GradatedSliderWidget(this.left + 8, this.top + 70, 205, (double)this.zRange / (double)this.tier.xzRange(), this.tier.xzRange()){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"gui.torcherino.z_range", (Object[])new Object[]{TorcherinoScreen.this.zRange * 2 + 1}));
            }

            protected void applyValue() {
                TorcherinoScreen.this.zRange = (int)Math.round(this.value * (double)TorcherinoScreen.this.tier.xzRange());
                this.value = (double)TorcherinoScreen.this.zRange / (double)TorcherinoScreen.this.tier.xzRange();
            }
        });
        this.addRenderableWidget((GuiEventListener)new GradatedSliderWidget(this.left + 8, this.top + 95, 205, (double)this.yRange / (double)this.tier.yRange(), this.tier.yRange()){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"gui.torcherino.y_range", (Object[])new Object[]{TorcherinoScreen.this.yRange * 2 + 1}));
            }

            protected void applyValue() {
                TorcherinoScreen.this.yRange = (int)Math.round(this.value * (double)TorcherinoScreen.this.tier.yRange());
                this.value = (double)TorcherinoScreen.this.yRange / (double)TorcherinoScreen.this.tier.yRange();
            }
        });
        this.addRenderableWidget((GuiEventListener)new StateButtonWidget(this, this.left + 217, this.top + 20, this.font){
            ItemStack buttonIcon;

            @Override
            protected void initialize() {
                this.setButtonMessage();
                this.setButtonIcon();
            }

            private void setButtonMessage() {
                String translationKey = switch (TorcherinoScreen.this.redstoneMode) {
                    case 0 -> "gui.torcherino.mode.normal";
                    case 1 -> "gui.torcherino.mode.inverted";
                    case 2 -> "gui.torcherino.mode.ignored";
                    case 3 -> "gui.torcherino.mode.off";
                    default -> "gui.torcherino.mode.error";
                };
                this.setNarrationMessage((Component)Component.translatable((String)"gui.torcherino.mode", (Object[])new Object[]{Component.translatable((String)translationKey)}));
            }

            private void setButtonIcon() {
                switch (TorcherinoScreen.this.redstoneMode) {
                    case 0: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.REDSTONE);
                        break;
                    }
                    case 1: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.REDSTONE_TORCH);
                        break;
                    }
                    case 2: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.GUNPOWDER);
                        break;
                    }
                    case 3: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.REDSTONE_LAMP);
                        break;
                    }
                    default: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.FURNACE);
                    }
                }
            }

            @Override
            protected void nextState() {
                TorcherinoScreen.this.redstoneMode = (TorcherinoScreen.this.redstoneMode + 1) % 4;
                this.initialize();
            }

            @Override
            protected ItemStack getButtonIcon() {
                return this.buttonIcon;
            }
        });
    }

    public void renderBackground(GuiGraphics context, int x, int y, float partialTicks) {
        this.renderTransparentBackground(context);
        this.renderBg(context, x, y, partialTicks);
    }

    protected void renderBg(GuiGraphics context, int x, int y, float partialTicks) {
        context.blit(RenderPipelines.GUI_TEXTURED, SCREEN_TEXTURE, this.left, this.top, 0.0f, 0.0f, 245, 123, 256, 256);
        context.drawString(this.font, this.cached_title, (int)((float)(this.width - this.font.width((FormattedText)this.cached_title)) / 2.0f), this.top + 6, -12566464, false);
    }

    public void render(GuiGraphics context, int x, int y, float partialTicks) {
        super.render(context, x, y, partialTicks);
    }

    public boolean keyPressed(KeyEvent keyCode) {
        if (keyCode.isEscape() || this.minecraft.options.keyInventory.matches(keyCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode);
    }

    public void onClose() {
        NetworkUtils.getInstance().c2s_updateTorcherinoValues(this.blockPos, this.xRange, this.zRange, this.yRange, this.speed, this.redstoneMode);
        super.onClose();
    }
}

