/*
 * Decompiled with CFR 0.152.
 */
package torcherino.client.screen.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;

public abstract class StateButtonWidget
extends Button {
    private static final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    private final Screen screen;
    private Component narrationMessage;
    private Font font;

    public StateButtonWidget(Screen screen, int x, int y, Font font) {
        super(x, y, 20, 20, (Component)Component.empty(), b -> {}, Button.DEFAULT_NARRATION);
        this.screen = screen;
        this.font = font;
        this.initialize();
    }

    public Font getFont() {
        return this.font;
    }

    protected abstract void initialize();

    protected abstract void nextState();

    protected abstract ItemStack getButtonIcon();

    public final void renderWidget(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            context.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
            context.renderItem(this.getButtonIcon(), this.getX() + 2, this.getY() + 2);
            if (this.isHovered) {
                context.setTooltipForNextFrame(this.getFont(), this.narrationMessage, this.getX() + 14, this.getY() + 18);
            }
        }
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.nextState();
    }

    public MutableComponent createNarrationMessage() {
        return Component.translatable((String)"gui.narrate.button", (Object[])new Object[]{this.narrationMessage});
    }

    protected void setNarrationMessage(Component narrationMessage) {
        this.narrationMessage = narrationMessage;
    }
}

