/*
 * Decompiled with CFR 0.152.
 */
package torcherino.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import torcherino.TorcherinoImpl;
import torcherino.api.TorcherinoAPI;
import torcherino.config.ResourceLocationAdapter;
import torcherino.platform.PlatformUtils;

public class Config {
    public static Config INSTANCE;
    public final int random_tick_rate = 4;
    public final boolean log_placement = PlatformUtils.getInstance().isDedicatedServer();
    private final ResourceLocation[] blacklisted_blocks = new ResourceLocation[0];
    private final ResourceLocation[] blacklisted_blockentities = new ResourceLocation[0];
    private final Tier[] tiers = new Tier[]{new Tier("normal", 4, 4, 1), new Tier("compressed", 36, 4, 1), new Tier("double_compressed", 324, 4, 1)};
    public String online_mode = "";

    public static void initialize() {
        Gson gson = new GsonBuilder().disableInnerClassSerialization().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationAdapter()).setPrettyPrinting().create();
        Path configDir = PlatformUtils.getInstance().getConfigPath();
        Logger logger = LogManager.getLogger((String)"torcherino-config");
        MarkerManager.Log4jMarker marker = new MarkerManager.Log4jMarker("torcherino");
        Config config = null;
        try {
            Files.createDirectories(configDir.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.warn((Marker)marker, "Failed to create directory required for torcherino config, using default config.");
            config = new Config();
        }
        if (config == null) {
            if (Files.exists(configDir, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(configDir);){
                    config = (Config)gson.fromJson((Reader)reader, Config.class);
                }
                catch (IOException e) {
                    logger.warn((Marker)marker, "Failed to read torcherino config file, using default config.");
                    config = new Config();
                }
            } else {
                config = new Config();
                try (BufferedWriter writer = Files.newBufferedWriter(configDir, StandardOpenOption.CREATE_NEW);){
                    gson.toJson((Object)config, (Appendable)writer);
                }
                catch (IOException e) {
                    logger.warn((Marker)marker, "Failed to save default torcherino config file.");
                }
            }
        }
        INSTANCE = config;
        INSTANCE.onConfigLoaded();
    }

    private void onConfigLoaded() {
        this.online_mode = this.online_mode.toUpperCase();
        if (!this.online_mode.equals("ONLINE") && !this.online_mode.equals("RESTART")) {
            this.online_mode = "";
        }
        for (Tier tier : this.tiers) {
            ((TorcherinoImpl)TorcherinoAPI.INSTANCE).registerTier(ResourceLocation.fromNamespaceAndPath((String)"torcherino", (String)tier.name), tier.max_speed, tier.xz_range, tier.y_range);
        }
        for (Tier tier : this.blacklisted_blocks) {
            TorcherinoAPI.INSTANCE.blacklistBlock((ResourceLocation)tier);
        }
        for (Tier tier : this.blacklisted_blockentities) {
            TorcherinoAPI.INSTANCE.blacklistBlockEntity((ResourceLocation)tier);
        }
    }

    static class Tier {
        final String name;
        final int max_speed;
        final int xz_range;
        final int y_range;

        Tier(String name, int max_speed, int xz_range, int y_range) {
            this.name = name;
            this.max_speed = max_speed;
            this.xz_range = xz_range;
            this.y_range = y_range;
        }
    }
}

