/*
 * Decompiled with CFR 0.152.
 */
package torcherino.mixin;

import com.google.common.collect.BiMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import torcherino.block.CopperLanterinoBlock;
import torcherino.block.WeatheringLanterinoBlock;
import torcherino.block.api.LanterinoOxidizableRegistry;

@Mixin(value={AxeItem.class})
public abstract class AxeItemMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOn(UseOnContext useOnContext, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = useOnContext.getLevel();
        BlockPos pos = useOnContext.getClickedPos();
        BlockState state = useOnContext.getLevel().getBlockState(pos);
        Player player = useOnContext.getPlayer();
        ItemStack stack = useOnContext.getItemInHand();
        Block block = state.getBlock();
        if (block instanceof CopperLanterinoBlock) {
            ResourceLocation tierID;
            BiMap<Block, Block> waxOffMap;
            Block unwaxed;
            CopperLanterinoBlock copperLanterinoBlock = (CopperLanterinoBlock)block;
            if (!level.isClientSide() && (unwaxed = (Block)(waxOffMap = LanterinoOxidizableRegistry.getUnwaxMap(tierID = copperLanterinoBlock.getTier())).get((Object)state.getBlock())) != null) {
                WeatheringLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, unwaxed.defaultBlockState());
                stack.hurtAndBreak(1, (ServerLevel)level, null, p -> {});
                level.levelEvent((Entity)player, 3005, pos, 0);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
            if ((waxOffMap = state.getBlock()) instanceof WeatheringLanterinoBlock) {
                ResourceLocation tierID2;
                BiMap<Block, Block> prevMap;
                Block prev;
                WeatheringLanterinoBlock weatheringLanterinoBlock = (WeatheringLanterinoBlock)waxOffMap;
                if (!level.isClientSide() && (prev = (Block)(prevMap = LanterinoOxidizableRegistry.getPreviousByBlock(tierID2 = weatheringLanterinoBlock.getTier())).get((Object)state.getBlock())) != null) {
                    WeatheringLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, prev.defaultBlockState());
                    stack.hurtAndBreak(1, (ServerLevel)level, null, p -> {});
                    level.levelEvent((Entity)player, 3004, pos, 0);
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                }
            }
        }
    }
}

