/*
 * Decompiled with CFR 0.152.
 */
package torcherino.mixin;

import com.google.common.collect.BiMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import torcherino.block.WeatheringLanterinoBlock;
import torcherino.block.api.LanterinoOxidizableRegistry;

@Mixin(value={HoneycombItem.class})
public abstract class HoneycombItemMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOn(UseOnContext useOnContext, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = useOnContext.getLevel();
        BlockPos pos = useOnContext.getClickedPos();
        BlockState state = useOnContext.getLevel().getBlockState(pos);
        Player player = useOnContext.getPlayer();
        ItemStack stack = useOnContext.getItemInHand();
        Block block = state.getBlock();
        if (block instanceof WeatheringLanterinoBlock) {
            ResourceLocation tierID;
            BiMap<Block, Block> waxables;
            Block waxed;
            WeatheringLanterinoBlock weatheringLanterinoBlock = (WeatheringLanterinoBlock)block;
            if (!level.isClientSide() && (waxed = (Block)(waxables = LanterinoOxidizableRegistry.getWaxMap(tierID = weatheringLanterinoBlock.getTier())).get((Object)state.getBlock())) != null) {
                WeatheringLanterinoBlock.swapPreserveTorcherinoBE((ServerLevel)level, pos, state, waxed.defaultBlockState());
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                level.levelEvent((Entity)player, 3003, pos, 0);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
        }
    }
}

