/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.YACLUtil;

public class ConfigScreens {
    public static Screen generateMainConfigScreen(Screen parent) {
        List<OptionGroup> groups = YACLUtil.collectGroups(ConfigManager.defaultConfig, ConfigManager.config);
        groups.add(1, ConfigScreens.getParticleToggles());
        return YACLUtil.generateScreen(YACLUtil.getComponent("title"), groups, YACLUtil.collectOptions(ConfigManager.defaultConfig, ConfigManager.config), () -> ConfigScreens.generateMainConfigScreen(parent), parent);
    }

    static OptionGroup getParticleToggles() {
        ArrayList<Object> options = new ArrayList<Object>();
        options.add(YACLUtil.getScreenButtonOption(YACLUtil.getComponent("editParticles"), "", () -> ConfigScreens.generateParticleListScreen(Minecraft.getInstance().screen)));
        for (ConfigData.ParticleData particle : ConfigManager.config.particles) {
            try {
                options.add(YACLUtil.getBoolOption(new ConfigData.ParticleData(), particle, particle.getClass().getField("enabled")).name(YACLUtil.getComponent(particle.id)).build());
            }
            catch (NoSuchFieldException e) {
                ParticleRain.LOGGER.error(e.getMessage());
            }
        }
        return OptionGroup.createBuilder().name(YACLUtil.getComponent("particleToggles")).description(OptionDescription.of((Component[])new Component[]{YACLUtil.getComponentWithFallback("particles.description")})).options(options).build();
    }

    public static Screen generateParticleListScreen(Screen parent) {
        ArrayList options = new ArrayList();
        options.add((Option<?>)YACLUtil.getScreenButtonOption(YACLUtil.getComponent("button.add"), "", () -> {
            ConfigData.ParticleData particle = new ConfigData.ParticleData();
            ConfigManager.config.particles.add(particle);
            ConfigManager.save();
            return ConfigScreens.generateParticleEditScreen(ConfigScreens.generateParticleListScreen(parent), particle, particle);
        }));
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            ConfigData.ParticleData finalDefaultParticle = ConfigScreens.getDefaultParticle(opts);
            options.add((Option<?>)LabelOption.create((Component)Component.literal((String)"")));
            ButtonOption editButton = YACLUtil.getScreenButtonOption((Component)Component.literal((String)opts.id), "", () -> ConfigScreens.generateParticleEditScreen(Minecraft.getInstance().screen, opts, finalDefaultParticle));
            options.add((Option<?>)editButton);
            options.add((Option<?>)YACLUtil.getScreenButtonOption((Component)Component.translatable((String)"selectWorld.delete").withStyle(ChatFormatting.RED), "", () -> {
                ConfigManager.config.particles.remove(opts);
                ConfigManager.save();
                return ConfigScreens.generateParticleListScreen(parent);
            }));
        }
        return YACLUtil.generateScreen(YACLUtil.getComponent("editParticles"), null, options, () -> ConfigScreens.generateParticleListScreen(parent), parent);
    }

    private static ConfigData.ParticleData getDefaultParticle(ConfigData.ParticleData particleData) {
        for (ConfigData.ParticleData defaultData : ConfigManager.defaultConfig.particles) {
            if (!particleData.id.equals(defaultData.id)) continue;
            return defaultData;
        }
        return new ConfigData.ParticleData();
    }

    public static Screen generateParticleEditScreen(Screen parent, Object configObject, Object defaultObject) {
        List<OptionGroup> groups = null;
        try {
            Field usePresetParticle = ConfigData.ParticleData.class.getField("usePresetParticle");
            usePresetParticle.setAccessible(true);
            if (((Boolean)usePresetParticle.get(configObject)).booleanValue()) {
                Field presetParticleField = ConfigData.ParticleData.class.getField("presetParticleId");
                presetParticleField.setAccessible(true);
                String configId = VersionUtil.parseId((String)presetParticleField.get(configObject)).getPath();
                if (ParticleRain.particleConfigIds.contains(configId)) {
                    groups = List.of(YACLUtil.getObjectAsGroup(ConfigManager.defaultConfig, ConfigManager.config, ConfigData.class.getField(configId)));
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return YACLUtil.generateScreen(YACLUtil.getComponent("category.edit"), groups, YACLUtil.collectOptions(defaultObject, configObject), () -> ConfigScreens.generateParticleEditScreen(parent, configObject, defaultObject), parent);
    }
}

