/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigManager;

public abstract class Whitelist<T> {
    @ConfigManager.NoGUI
    private final transient ResourceKey<Registry<T>> registry;
    @ConfigManager.NoGUI
    public transient List<TagKey<T>> tags = new ArrayList<TagKey<T>>();
    @ConfigManager.NoGUI
    public transient List<ResourceLocation> ids = new ArrayList<ResourceLocation>();
    @ConfigManager.BooleanFormat(t="whitelist", f="blacklist")
    public boolean isWhitelist;

    Whitelist(ResourceKey<Registry<T>> registry, boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
        this.registry = registry;
    }

    Whitelist(ResourceKey<Registry<T>> registry) {
        this(registry, true);
    }

    public abstract List<String> getEntries();

    public String toString() {
        return this.getEntries().toString();
    }

    public void populateInternalLists() {
        this.ids.clear();
        this.tags.clear();
        for (String string : this.getEntries()) {
            ResourceLocation id;
            if (string.startsWith("#")) {
                id = VersionUtil.parseId(string.substring(1));
                if (id == null) continue;
                this.tags.add(TagKey.create(this.registry, (ResourceLocation)id));
                continue;
            }
            id = VersionUtil.parseId(string);
            if (id == null) continue;
            this.ids.add(id);
        }
    }

    public boolean contains(Holder<T> holder) {
        if (!this.getEntries().isEmpty()) {
            boolean hasMatch;
            for (TagKey<T> tag : this.tags) {
                hasMatch = holder.is(tag);
                if (this.isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            for (ResourceLocation id : this.ids) {
                hasMatch = holder.is(id);
                if (this.isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            return !this.isWhitelist;
        }
        return true;
    }

    @ConfigManager.OverrideName(value="Whitelist")
    public static class BiomeList
    extends Whitelist<Biome> {
        public final transient URI wikiLink = URI.create("https://wiki.fabricmc.net/community:common_tags#biome_tags");
        @ConfigManager.Group
        @ConfigManager.Dropdown(value=ConfigManager.SupplyBiomes.class)
        public List<String> entries;

        BiomeList(boolean isWhitelist, List<String> list) {
            super(Registries.BIOME, isWhitelist);
            this.entries = list;
        }

        public BiomeList() {
            super(Registries.BIOME);
            this.entries = new ArrayList<String>();
        }

        @Override
        public List<String> getEntries() {
            return this.entries;
        }
    }

    @ConfigManager.OverrideName(value="Whitelist")
    public static class BlockList
    extends Whitelist<Block> {
        public final transient URI wikiLink = URI.create("https://wiki.fabricmc.net/community:common_tags#block_tags");
        @ConfigManager.Group
        @ConfigManager.Dropdown(value=ConfigManager.SupplyBlocks.class)
        public List<String> entries;

        BlockList(boolean isWhitelist, List<String> list) {
            super(Registries.BLOCK, isWhitelist);
            this.entries = list;
        }

        public BlockList() {
            super(Registries.BLOCK);
            this.entries = new ArrayList<String>();
        }

        @Override
        public List<String> getEntries() {
            return this.entries;
        }
    }
}

