/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import dev.isxander.yacl3.gui.YACLScreen;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.ConfigScreens;
import pigcart.particlerain.mixin.yacl.YACLScreenAccessor;

public class YACLUtil {
    private static String lastScreenInitialized = "";

    public static void regenerateScreen(YACLScreen thisScreen, Supplier<Screen> generator) {
        String key = ((TranslatableContents)thisScreen.getTitle().getContents()).getKey();
        if (!lastScreenInitialized.equals(key)) {
            lastScreenInitialized = key;
            if (generator != null) {
                Minecraft.getInstance().setScreen(generator.get());
            }
        }
    }

    public static Screen generateScreen(Component title, Collection<OptionGroup> groups, Collection<Option<?>> options, Supplier<Screen> generator, Screen parent) {
        ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder();
        if (groups != null && !groups.isEmpty()) {
            categoryBuilder.groups(groups);
        }
        if (options != null && !options.isEmpty()) {
            categoryBuilder.options(options);
        }
        return YetAnotherConfigLib.createBuilder().title(title).category(categoryBuilder.name(title).build()).save(ConfigManager::save).screenInit(thisScreen -> YACLUtil.regenerateScreen(thisScreen, generator)).build().generateScreen(parent);
    }

    static ButtonOption getScreenButtonOption(Component name, String text, Supplier<Screen> screenSupplier) {
        return YACLUtil.getScreenButtonOption(name, text, true, screenSupplier);
    }

    private static ButtonOption getScreenButtonOption(Component name, String text, boolean available, Supplier<Screen> screenSupplier) {
        return ButtonOption.createBuilder().name(name).text((Component)Component.literal((String)text)).available(available).action((yaclScreen, buttonOption) -> Minecraft.getInstance().setScreen((Screen)screenSupplier.get())).build();
    }

    static <T> ButtonOption getListButtonOption(Object instance, Field field, ListOption<T> listOption) {
        String listText = "";
        try {
            listText = YACLUtil.cropText(field.get(instance).toString());
        }
        catch (IllegalAccessException e) {
            ParticleRain.LOGGER.error(e.getMessage());
        }
        boolean available = true;
        if (field.isAnnotationPresent(ConfigManager.OnlyEditableIf.class)) {
            ConfigManager.OnlyEditableIf annotation = field.getAnnotation(ConfigManager.OnlyEditableIf.class);
            try {
                Function function = (Function)annotation.value().getConstructors()[0].newInstance(new Object[0]);
                available = (Boolean)function.apply(instance);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return YACLUtil.getScreenButtonOption(YACLUtil.getComponent(instance.getClass().getSimpleName() + "." + field.getName()), listText, available, () -> YACLUtil.generateScreen(YACLUtil.getComponent("editList"), List.of(listOption), null, null, Minecraft.getInstance().screen));
    }

    static List<OptionGroup> collectGroups(Object defaultInstance, Object instance) {
        Field[] fields;
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        for (Field field : fields = instance.getClass().getFields()) {
            if (!field.isAnnotationPresent(ConfigManager.Group.class)) continue;
            if (field.isAnnotationPresent(ConfigManager.Dropdown.class)) {
                ConfigManager.Dropdown annotation = field.getAnnotation(ConfigManager.Dropdown.class);
                try {
                    List strings = (List)((Supplier)annotation.value().getConstructors()[0].newInstance(new Object[0])).get();
                    groups.add((OptionGroup)YACLUtil.getStringDropdownListOption(defaultInstance, instance, field, strings));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (field.getType().equals(List.class)) {
                groups.add((OptionGroup)YACLUtil.getListOption(defaultInstance, instance, field));
                continue;
            }
            field.setAccessible(true);
            try {
                groups.add(YACLUtil.getObjectAsGroup(defaultInstance, instance, field));
            }
            catch (IllegalAccessException e) {
                ParticleRain.LOGGER.error(e.toString());
            }
        }
        return groups;
    }

    static OptionGroup getObjectAsGroup(Object defaultInstance, Object instance, Field field) throws IllegalAccessException {
        if (field == null) {
            return null;
        }
        return OptionGroup.createBuilder().name(YACLUtil.getComponent(field.getType().getSimpleName())).description(OptionDescription.of((Component[])new Component[]{YACLUtil.getComponentWithFallback(field.getName() + ".description")})).options(YACLUtil.collectOptions(field.get(defaultInstance), field.get(instance))).build();
    }

    static List<Option<?>> collectOptions(Object defaultInstance, Object instance) {
        Field[] fields;
        ArrayList options = new ArrayList();
        for (Field field : fields = instance.getClass().getFields()) {
            if (field.isAnnotationPresent(ConfigManager.NoGUI.class) || field.isAnnotationPresent(ConfigManager.Group.class)) continue;
            if (field.isAnnotationPresent(ConfigManager.OnlyVisibleIf.class)) {
                ConfigManager.OnlyVisibleIf annotation = field.getAnnotation(ConfigManager.OnlyVisibleIf.class);
                try {
                    Function function = (Function)annotation.value().getConstructors()[0].newInstance(new Object[0]);
                    boolean optionIsVisible = (Boolean)function.apply(instance);
                    if (!optionIsVisible) {
                        continue;
                    }
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (field.isAnnotationPresent(ConfigManager.Label.class)) {
                options.add((Option<?>)LabelOption.create((Component)YACLUtil.getComponent(instance.getClass().getSimpleName() + "." + field.getDeclaredAnnotation(ConfigManager.Label.class).key())));
            }
            field.setAccessible(true);
            Class<?> type = field.getType();
            if (type.equals(Boolean.TYPE)) {
                options.add(YACLUtil.getBoolOption(defaultInstance, instance, field).build());
                continue;
            }
            if (type.equals(Float.TYPE)) {
                options.add(YACLUtil.getFloatOption(defaultInstance, instance, field));
                continue;
            }
            if (type.equals(Integer.TYPE)) {
                options.add(YACLUtil.getIntOption(defaultInstance, instance, field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigManager.Dropdown.class)) {
                ConfigManager.Dropdown annotation = field.getAnnotation(ConfigManager.Dropdown.class);
                try {
                    List strings = (List)((Supplier)annotation.value().getConstructors()[0].newInstance(new Object[0])).get();
                    if (type.equals(List.class)) {
                        options.add((Option<?>)YACLUtil.getStringDropdownListOption(defaultInstance, instance, field, strings));
                        continue;
                    }
                    options.add(YACLUtil.getStringDropdownOption(defaultInstance, instance, field, strings));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (type.equals(String.class)) {
                options.add(YACLUtil.getStringOption(defaultInstance, instance, field));
                continue;
            }
            if (type.isEnum()) {
                options.add(YACLUtil.getEnumOption(defaultInstance, instance, field, type));
                continue;
            }
            if (type.equals(URI.class)) {
                options.add((Option<?>)YACLUtil.getLinkButtonOption(instance, field));
                continue;
            }
            if (type.equals(Color.class)) {
                options.add(YACLUtil.getColorOption(defaultInstance, instance, field));
                continue;
            }
            if (type.equals(List.class)) {
                ListOption<?> listOption = YACLUtil.getListOption(defaultInstance, instance, field);
                if (listOption == null) continue;
                options.add((Option<?>)YACLUtil.getListButtonOption(instance, field, listOption));
                continue;
            }
            if (type.getFields().length != 0) {
                options.add((Option<?>)YACLUtil.getObjectAsOption(defaultInstance, instance, field));
                continue;
            }
            ParticleRain.LOGGER.error("Unable to create option for field {}", (Object)field.getName());
        }
        options.add((Option<?>)LabelOption.create((Component)CommonComponents.EMPTY));
        return options;
    }

    private static ListOption<?> getListOption(Object defaultInstance, Object instance, Field field) {
        Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        if (listType.equals(String.class)) {
            return YACLUtil.getStringListOption(defaultInstance, instance, field);
        }
        if (listType.isEnum()) {
            return YACLUtil.getEnumListOption(defaultInstance, instance, field, listType);
        }
        ParticleRain.LOGGER.error("Unable to create list for field {}", (Object)field.getName());
        return null;
    }

    private static ButtonOption getObjectAsOption(Object defaultInstance, Object instance, Field field) {
        try {
            Object newDefaultInstance = field.get(defaultInstance);
            Object newInstance = field.get(instance);
            Component name = YACLUtil.getComponent(field.getName());
            String text = "";
            if (!newInstance.toString().startsWith(newInstance.getClass().getName())) {
                text = YACLUtil.cropText(newInstance.toString());
            }
            return YACLUtil.getScreenButtonOption(name, text, () -> YACLUtil.generateScreen(YACLUtil.getComponent(field.getName()), YACLUtil.collectGroups(newDefaultInstance, newInstance), YACLUtil.collectOptions(newDefaultInstance, newInstance), null, Minecraft.getInstance().screen));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static ButtonOption getLinkButtonOption(Object instance, Field field) {
        String groupName = instance.getClass().getSimpleName();
        if (instance.getClass().isAnnotationPresent(ConfigManager.OverrideName.class)) {
            groupName = instance.getClass().getAnnotation(ConfigManager.OverrideName.class).value();
        }
        String fieldName = field.getName();
        try {
            return ButtonOption.createBuilder().name(YACLUtil.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)field.get(instance).toString())})).text((Component)Component.literal((String)"")).action((yaclScreen, buttonOption) -> {
                Minecraft minecraft = Minecraft.getInstance();
                try {
                    minecraft.setScreen((Screen)new ConfirmLinkScreen(result -> {
                        try {
                            if (result) {
                                Util.getPlatform().openUri((URI)field.get(instance));
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                        minecraft.setScreen((Screen)yaclScreen);
                    }, field.get(instance).toString(), true));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }).build();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Option<Color> getColorOption(Object defaultInstance, Object instance, Field field) {
        return YACLUtil.getOptionBuilder(defaultInstance, instance, field).controller(ColorControllerBuilder::create).build();
    }

    private static <T extends Enum<T>> Option<T> getEnumOption(Object defaultInstance, Object instance, Field field, Class<?> eClass) {
        return YACLUtil.getOptionBuilder(defaultInstance, instance, field).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(eClass)).build();
    }

    private static <T extends Enum<T>> ListOption<T> getEnumListOption(Object defaultInstance, Object instance, Field field, Class<?> eClass) {
        return YACLUtil.getListOptionBuilder(defaultInstance, instance, field).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(eClass)).build();
    }

    private static ListOption<String> getStringListOption(Object defaultInstance, Object instance, Field field) {
        return YACLUtil.getListOptionBuilder(defaultInstance, instance, field).controller(StringControllerBuilder::create).initial((Object)"").build();
    }

    static Option.Builder<Boolean> getBoolOption(Object defaultInstance, Object instance, Field field) {
        return YACLUtil.getOptionBuilder(defaultInstance, instance, field).controller(opt -> {
            if (field.isAnnotationPresent(ConfigManager.BooleanFormat.class)) {
                return BooleanControllerBuilder.create((Option)opt).formatValue(val -> YACLUtil.getComponent(val != false ? field.getAnnotation(ConfigManager.BooleanFormat.class).t() : field.getAnnotation(ConfigManager.BooleanFormat.class).f()));
            }
            return BooleanControllerBuilder.create((Option)opt).coloured(true);
        });
    }

    private static <T> ValueFormatter<T> getFormatter(Field field) {
        if (field.isAnnotationPresent(ConfigManager.Format.class)) {
            ConfigManager.Format annotation = field.getAnnotation(ConfigManager.Format.class);
            try {
                Function function = (Function)annotation.value().getConstructors()[0].newInstance(new Object[0]);
                return function::apply;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return val -> Component.literal((String)val.toString());
    }

    private static Option<Float> getFloatOption(Object defaultInstance, Object instance, Field field) {
        return YACLUtil.getOptionBuilder(defaultInstance, instance, field).controller(opt -> {
            if (field.isAnnotationPresent(ConfigManager.Slider.class)) {
                ConfigManager.Slider annotation = field.getAnnotation(ConfigManager.Slider.class);
                return ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).formatValue(YACLUtil.getFormatter(field))).range((Number)Float.valueOf(annotation.min()), (Number)Float.valueOf(annotation.max()))).step((Number)Float.valueOf(annotation.step()));
            }
            return FloatFieldControllerBuilder.create((Option)opt).formatValue(YACLUtil.getFormatter(field));
        }).build();
    }

    private static Option<Integer> getIntOption(Object defaultInstance, Object instance, Field field) {
        return YACLUtil.getOptionBuilder(defaultInstance, instance, field).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).formatValue(YACLUtil.getFormatter(field))).build();
    }

    private static Option<String> getStringOption(Object defaultInstance, Object instance, Field field) {
        return YACLUtil.getOptionBuilder(defaultInstance, instance, field).controller(StringControllerBuilder::create).build();
    }

    private static Option<String> getStringDropdownOption(Object defaultInstance, Object instance, Field field, List<String> strings) {
        BuiltInRegistries.PARTICLE_TYPE.keySet();
        return YACLUtil.getOptionBuilder(defaultInstance, instance, field).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(true).allowEmptyValue(true).values(strings)).build();
    }

    private static ListOption<String> getStringDropdownListOption(Object defaultInstance, Object instance, Field field, List<String> strings) {
        BuiltInRegistries.PARTICLE_TYPE.keySet();
        return YACLUtil.getListOptionBuilder(defaultInstance, instance, field).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(true).allowEmptyValue(true).values(strings)).initial((Object)"").build();
    }

    private static <T> Option.Builder<T> getOptionBuilder(Object defaultInstance, Object instance, Field field) {
        String groupName = instance.getClass().getSimpleName();
        if (instance.getClass().isAnnotationPresent(ConfigManager.OverrideName.class)) {
            groupName = instance.getClass().getAnnotation(ConfigManager.OverrideName.class).value();
        }
        String fieldName = field.getName();
        Binding<T> binding = YACLUtil.getBinding(defaultInstance, instance, field);
        Option.Builder optionBuilder = Option.createBuilder().name(YACLUtil.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((Component[])new Component[]{YACLUtil.getComponentWithFallback(groupName + "." + fieldName + ".description")}));
        optionBuilder.stateManager(StateManager.createInstant(binding));
        if (field.isAnnotationPresent(ConfigManager.OnlyEditableIf.class)) {
            ConfigManager.OnlyEditableIf annotation = field.getAnnotation(ConfigManager.OnlyEditableIf.class);
            try {
                Function function = (Function)annotation.value().getConstructors()[0].newInstance(new Object[0]);
                optionBuilder.available(((Boolean)function.apply(instance)).booleanValue());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return optionBuilder;
    }

    private static <T> ListOption.Builder<T> getListOptionBuilder(Object defaultGroup, Object group, Field field) {
        String groupName = group.getClass().getSimpleName();
        String fieldName = field.getName();
        return ListOption.createBuilder().name(YACLUtil.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((Component[])new Component[]{YACLUtil.getComponentWithFallback(groupName + "." + fieldName + ".description")})).binding(YACLUtil.getBinding(defaultGroup, group, field)).initial(() -> {
            try {
                Field defaultField = defaultGroup.getClass().getField(field.getName());
                defaultField.setAccessible(true);
                return ((List)defaultField.get(defaultGroup)).get(0);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static <T> Binding<T> getBinding(Object defaultInstance, Object instance, Field field) {
        Object defaultValue;
        try {
            Field defaultField = defaultInstance.getClass().getField(field.getName());
            defaultField.setAccessible(true);
            defaultValue = defaultField.get(defaultInstance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return Binding.generic((Object)defaultValue, () -> {
            try {
                return field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, newVal -> {
            try {
                String oldStr;
                Object oldVal = field.get(instance);
                String string = oldStr = oldVal == null ? "" : oldVal.toString();
                if (!newVal.toString().equals(oldStr)) {
                    ConfigManager.RegenScreen regenScreen;
                    field.set(instance, newVal);
                    ConfigManager.OnChange onChange = field.getDeclaredAnnotation(ConfigManager.OnChange.class);
                    if (onChange != null) {
                        ((Runnable)onChange.value().getConstructors()[0].newInstance(new Object[0])).run();
                    }
                    if ((regenScreen = field.getDeclaredAnnotation(ConfigManager.RegenScreen.class)) != null) {
                        Screen parent = ((YACLScreenAccessor)Minecraft.getInstance().screen).getParent();
                        Screen screen = ConfigScreens.generateParticleEditScreen(parent, instance, defaultInstance);
                        Minecraft.getInstance().setScreen(screen);
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                ParticleRain.LOGGER.error(e.getMessage());
            }
        });
    }

    static Component getComponent(String translationKey) {
        return Component.translatable((String)("particlerain." + translationKey));
    }

    static Component getComponentWithFallback(String translationKey) {
        return Component.translatableWithFallback((String)("particlerain." + translationKey), (String)"");
    }

    private static String cropText(String text) {
        if (((String)text).length() > 42) {
            text = ((String)text).substring(0, 42) + "...";
        }
        return text;
    }
}

