/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2400;
import net.minecraft.class_2428;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.ConfigScreens;
import pigcart.particlerain.particle.CustomParticle;

public class ParticleRain {
    public static int clientTicks = 0;
    public static final String MOD_ID = "particlerain";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particlerain");
    public static class_2400 MIST;
    public static class_2400 SHRUB;
    public static class_2400 RIPPLE;
    public static class_2400 STREAK;
    public static Set<String> particleConfigIds;
    public static class_3414 WEATHER_SNOW;
    public static class_3414 WEATHER_SNOW_ABOVE;
    public static class_3414 WEATHER_SANDSTORM;
    public static class_3414 WEATHER_SANDSTORM_ABOVE;

    private static List<String> getDebugLines() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return List.of();
        }
        class_2338 blockPos = class_2338.method_49638((class_2374)class_310.method_1551().field_1724.method_19538());
        class_6880 biome = level.method_23753(blockPos);
        class_1959.class_1963 precipitation = VersionUtil.getPrecipitationAt((class_1937)level, (class_6880<class_1959>)biome, blockPos);
        return List.of(String.format("Tracked particles: %d/%d", WeatherParticleManager.getParticleCount(), WeatherParticleManager.particleGroup.method_34045()), "after Weather Ticks Left: " + WeatherParticleManager.afterWeatherTicksLeft, "spawn Attempts Until Block FX Idle: " + WeatherParticleManager.spawnAttemptsUntilBlockFXIdle, "ticks Until Sky FX Idle: " + WeatherParticleManager.ticksUntilSkyFXIdle, "ticks Until Surface FX Idle: " + WeatherParticleManager.ticksUntilSurfaceFXIdle, "is Raining: " + level.method_8419(), "Biome Precipitation: " + String.valueOf(precipitation), "Wind multiplier: " + CustomParticle.yLevelWindMultiplier(blockPos.method_10264()));
    }

    public static void onInitializeClient() {
        ConfigManager.load();
        WEATHER_SNOW = ParticleRain.createSoundEvent("weather.snow");
        WEATHER_SNOW_ABOVE = ParticleRain.createSoundEvent("weather.snow.above");
        WEATHER_SANDSTORM = ParticleRain.createSoundEvent("weather.sandstorm");
        WEATHER_SANDSTORM_ABOVE = ParticleRain.createSoundEvent("weather.sandstorm.above");
    }

    public static void onTick(class_310 client) {
        class_4184 camera = client.field_1773.method_19418();
        if (!client.method_1493() && client.field_1687 != null && camera.method_19332()) {
            ++clientTicks;
            WeatherParticleManager.tick(client.field_1687, camera.method_19326());
        }
    }

    private static class_3414 createSoundEvent(String name) {
        class_2960 id = VersionUtil.getId(name);
        return class_3414.method_47908((class_2960)id);
    }

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).executes(ctx -> {
            VersionUtil.schedule(() -> class_310.method_1551().method_1507(ConfigScreens.generateMainConfigScreen(null)));
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            ParticleRain.getDebugLines().forEach(ParticleRain::addChatMsg);
            return 0;
        }));
    }

    private static void addChatMsg(String message) {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)message));
    }

    public static void doAdditionalWeatherSounds(class_638 level, class_2338 cameraPos, class_2338 rainPos, CallbackInfo ci) {
        class_2680 state;
        class_2498 soundType;
        if (ConfigManager.config.compat.doSpawnHeightLimit) {
            int cloudHeight;
            int n = cloudHeight = ConfigManager.config.compat.spawnHeightLimit == 0 ? VersionUtil.getCloudHeight(level) : ConfigManager.config.compat.spawnHeightLimit;
            if (rainPos.method_10264() > cloudHeight) {
                ci.cancel();
                return;
            }
        }
        boolean above = rainPos.method_10264() > cameraPos.method_10264() + 1 && level.method_8598(class_2902.class_2903.field_13197, cameraPos).method_10264() > class_3532.method_15375((float)cameraPos.method_10264());
        class_6880 biome = level.method_23753(rainPos);
        class_1959.class_1963 precipitation = VersionUtil.getPrecipitationAt((class_1937)level, (class_6880<class_1959>)biome, rainPos);
        if (precipitation == class_1959.class_1963.field_9383 && ConfigManager.config.sound.snowVolume > 0.0f) {
            class_3414 sound = above ? WEATHER_SNOW_ABOVE : WEATHER_SNOW;
            level.method_45446(rainPos, sound, class_3419.field_15252, ConfigManager.config.sound.snowVolume, above ? 0.5f : 1.0f, false);
        } else if (precipitation == class_1959.class_1963.field_9384 && (double)((class_1959)biome.comp_349()).method_8712() > 0.25 && ConfigManager.config.sound.windVolume > 0.0f) {
            class_3414 sound = above ? WEATHER_SANDSTORM_ABOVE : WEATHER_SANDSTORM;
            level.method_45446(rainPos, sound, class_3419.field_15252, ConfigManager.config.sound.windVolume, above ? 0.5f : 1.0f, false);
        } else if (ConfigManager.config.sound.blockVolume > 0.0f && !(soundType = (state = level.method_8320(rainPos)).method_26231()).equals(class_2498.field_11544)) {
            if (state.method_27852(class_2246.field_10179)) {
                class_3414 sound = (class_3414)((class_2766)state.method_11654((class_2769)class_2428.field_11325)).method_11886().comp_349();
                float pitch = class_2428.method_49818((int)level.field_9229.method_43048(24));
                level.method_45446(rainPos, sound, class_3419.field_15252, ConfigManager.config.sound.blockVolume, above ? pitch / 2.0f : pitch, false);
            } else {
                class_3414 sound = soundType.method_10596();
                level.method_45446(rainPos, sound, class_3419.field_15252, ConfigManager.config.sound.blockVolume, above ? 0.5f : 1.5f, false);
            }
        }
        if (ConfigManager.config.sound.rainVolume == 0.0f || !precipitation.equals((Object)class_1959.class_1963.field_9382)) {
            ci.cancel();
        }
    }

    static {
        particleConfigIds = Set.of("shrub", "ripple", "streak", "mist");
    }
}

