/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.Whitelist;
import pigcart.particlerain.particle.CustomParticle;
import pigcart.particlerain.particle.render.BlendedParticleRenderType;

public class ConfigData {
    @ConfigManager.NoGUI
    public byte configVersion = (byte)5;
    @ConfigManager.Group
    public PerformanceOptions perf = new PerformanceOptions();
    @ConfigManager.Group
    public SoundOptions sound = new SoundOptions();
    @ConfigManager.Group
    public WindOptions wind = new WindOptions();
    @ConfigManager.Group
    public CompatibilityOptions compat = new CompatibilityOptions();
    @ConfigManager.NoGUI
    public List<ParticleData> particles = new ArrayList<ParticleData>(List.of(new ParticleData("rain", true, 1.0f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9382), new Whitelist.BiomeList(), new Whitelist.BlockList(), true, SpawnPos.SKY, 0.9f, 0.5f, 1.0f, 0.0f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, List.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3"), TintType.WATER, RotationType.RELATIVE_VELOCITY), new ParticleData("snow", true, 0.4f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9383), new Whitelist.BiomeList(), new Whitelist.BlockList(), true, SpawnPos.SKY, 0.05f, 0.1f, 0.2f, 0.4f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, List.of("particlerain:snow_0", "particlerain:snow_1", "particlerain:snow_2", "particlerain:snow_3"), TintType.NONE, RotationType.COPY_CAMERA), new ParticleData("dust", true, 0.8f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9384), new Whitelist.BiomeList(), new Whitelist.BlockList(true, List.of("#minecraft:camel_sand_step_sound_blocks", "#minecraft:sand", "#minecraft:terracotta", "#c:sandstone_blocks")), true, SpawnPos.SKY, 0.2f, 0.7f, 1.0f, 0.0f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, List.of("particlerain:dust"), TintType.MAP, RotationType.COPY_CAMERA), new ParticleData("rain_haze", true, 0.1f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9382), new Whitelist.BiomeList(), new Whitelist.BlockList(), true, SpawnPos.SKY, 0.15f, 0.01f, 0.1f, 0.0f, 0.35f, 0.3f, true, RenderType.TRANSLUCENT, List.of("particlerain:fog_dithered"), TintType.FOG, RotationType.COPY_CAMERA), new ParticleData("snow_haze", true, 0.2f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9383), new Whitelist.BiomeList(), new Whitelist.BlockList(), true, SpawnPos.SKY, 0.05f, 0.01f, 0.1f, 0.0f, 0.35f, 0.3f, true, RenderType.TRANSLUCENT, List.of("particlerain:fog_dithered"), TintType.FOG, RotationType.COPY_CAMERA), new ParticleData("dust_haze", true, 0.1f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9384), new Whitelist.BiomeList(), new Whitelist.BlockList(true, List.of("#minecraft:camel_sand_step_sound_blocks", "#minecraft:sand", "#minecraft:terracotta", "#c:sandstone_blocks")), true, SpawnPos.SKY, 0.1f, 0.25f, 0.5f, 0.0f, 0.35f, 0.3f, true, RenderType.TRANSLUCENT, List.of("particlerain:fog_dithered"), TintType.MAP, RotationType.COPY_CAMERA), new ParticleData("minecraft:rain", "splatter", true, 1.0f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9382), new Whitelist.BiomeList(), new Whitelist.BlockList(false, List.of("minecraft:lava")), true, SpawnPos.BLOCK_TOP), new ParticleData("particlerain:ripple", "ripple", true, 1.0f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9382), new Whitelist.BiomeList(), new Whitelist.BlockList(true, List.of("minecraft:water")), true, SpawnPos.BLOCK_TOP), new ParticleData("minecraft:smoke", "smoke", true, 1.0f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9382), new Whitelist.BiomeList(), new Whitelist.BlockList(true, List.of("#minecraft:strider_warm_blocks", "#minecraft:infiniburn_overworld")), true, SpawnPos.BLOCK_TOP), new ParticleData("particlerain:streak", "streak", true, 0.2f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9382), new Whitelist.BiomeList(), new Whitelist.BlockList(true, List.of("#minecraft:impermeable", "#c:glass_panes", "#minecraft:mineable/pickaxe")), true, SpawnPos.BLOCK_SIDES), new ParticleData("particlerain:shrub", "shrub", true, 0.002f, Weather.DURING_WEATHER, List.of(class_1959.class_1963.field_9384), new Whitelist.BiomeList(), new Whitelist.BlockList(true, List.of("#minecraft:camel_sand_step_sound_blocks", "#minecraft:sand", "#minecraft:terracotta", "#c:sandstone_blocks")), true, SpawnPos.WORLD_SURFACE), new ParticleData("particlerain:mist", "mist_after_rain", true, 0.1f, Weather.AFTER_WEATHER, List.of(class_1959.class_1963.field_9382), new Whitelist.BiomeList(), new Whitelist.BlockList(true, List.of("#minecraft:dirt")), true, SpawnPos.WORLD_SURFACE), new ParticleData("particlerain:mist", "mist", true, 0.1f, Weather.ALWAYS, List.of(class_1959.class_1963.field_9382), new Whitelist.BiomeList(true, List.of("#c:is_wet/overworld", "#c:is_spooky")), new Whitelist.BlockList(true, List.of("#minecraft:dirt")), true, SpawnPos.WORLD_SURFACE)));
    @ConfigManager.NoGUI
    public ShrubOptions shrub = new ShrubOptions();
    @ConfigManager.NoGUI
    public RippleOptions ripple = new RippleOptions();
    @ConfigManager.NoGUI
    public StreakOptions streak = new StreakOptions();
    @ConfigManager.NoGUI
    public MistOptions mist = new MistOptions();

    public static class PerformanceOptions {
        @ConfigManager.OnChange(value=ConfigManager.ClearParticles.class)
        public int maxParticleAmount = 1500;
        public int particleDensity = 100;
        public int particleStormDensity = 200;
        public int particleDistance = 16;
        public int surfaceRange = 48;
    }

    public static class SoundOptions {
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.PercentOrOff.class)
        public float rainVolume = 0.2f;
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.PercentOrOff.class)
        public float snowVolume = 0.1f;
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.PercentOrOff.class)
        public float windVolume = 0.1f;
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.PercentOrOff.class)
        public float blockVolume = 0.07f;
    }

    public static class WindOptions {
        public float strength = 0.4f;
        public float strengthVariance = 0.3f;
        public float gustFrequency = 0.2f;
        public float modulationSpeed = 0.04f;
        public boolean yLevelAdjustment = true;
    }

    public static class CompatibilityOptions {
        public boolean renderDefaultWeather = false;
        public boolean doDefaultSplashing = false;
        @ConfigManager.OnChange(value=ConfigManager.ReloadResources.class)
        public boolean waterTint = true;
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.Percent.class)
        public float tintMix = 0.6f;
        @ConfigManager.NoGUI
        public boolean shaderpackTint = true;
        public boolean syncRegistries = true;
        public boolean crossBiomeBorder = false;
        public boolean useHeightmapTemp = true;
        public boolean doSpawnHeightLimit = true;
        @ConfigManager.Format(value=ConfigManager.ZeroIsAutomatic.class)
        public int spawnHeightLimit = 0;
    }

    public static class ParticleData {
        @ConfigManager.Dropdown(value=ConfigManager.SupplyParticleTypes.class)
        @ConfigManager.OnlyEditableIf(value=ConfigManager.ParticleNotCustom.class)
        public String presetParticleId = "minecraft:flame";
        @ConfigManager.NoGUI
        public transient class_2394 presetParticle = class_2398.field_11204;
        @ConfigManager.RegenScreen
        public boolean usePresetParticle = false;
        @ConfigManager.OnlyEditableIf(value=ConfigManager.ParticleIsNotDefault.class)
        public String id = "new_particle";
        @ConfigManager.Label(key="spawning")
        public boolean enabled = true;
        @ConfigManager.Slider(step=0.001f)
        @ConfigManager.Format(value=ConfigManager.Percent.class)
        public float density = 1.0f;
        public Weather weather = Weather.DURING_WEATHER;
        public List<class_1959.class_1963> precipitation = List.of(class_1959.class_1963.field_9382);
        public Whitelist.BiomeList biomeList = new Whitelist.BiomeList(true, new ArrayList<String>());
        public Whitelist.BlockList blockList = new Whitelist.BlockList(true, new ArrayList<String>());
        public boolean needsSkyAccess = false;
        public SpawnPos spawnPos = SpawnPos.SKY;
        @ConfigManager.Label(key="motion")
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float gravity = 0.9f;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float windStrength = 0.5f;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float stormWindStrength = 1.0f;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float rotationAmount = 0.0f;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public int lifetime = 3000;
        @ConfigManager.Label(key="appearance")
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.Percent.class)
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float opacity = 0.9f;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float size = 0.5f;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public boolean constantScreenSize = false;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public RenderType renderType = RenderType.TRANSLUCENT;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public List<String> spriteLocations = List.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3");
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public TintType tintType = TintType.NONE;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public Color customTint = Color.BLACK;
        @ConfigManager.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public RotationType rotationType = RotationType.COPY_CAMERA;

        ParticleData() {
        }

        ParticleData(String particle, String id, boolean enabled, float density, Weather weather, List<class_1959.class_1963> precipitation, Whitelist.BiomeList biomeList, Whitelist.BlockList blockList, boolean needsSkyAccess, SpawnPos spawnPos) {
            this.presetParticleId = particle;
            this.usePresetParticle = true;
            this.id = id;
            this.enabled = enabled;
            this.density = density;
            this.weather = weather;
            this.precipitation = precipitation;
            this.biomeList = biomeList;
            this.blockList = blockList;
            this.needsSkyAccess = needsSkyAccess;
            this.spawnPos = spawnPos;
        }

        public ParticleData(String id, boolean enabled, float density, Weather weather, List<class_1959.class_1963> precipitation, Whitelist.BiomeList biomeList, Whitelist.BlockList blockList, boolean needsSkyAccess, SpawnPos spawnPos, float gravity, float windStrength, float stormWindStrength, float rotationAmount, float opacity, float size, boolean constantScreenSize, RenderType renderType, List<String> spriteLocations, TintType tintType, RotationType rotationType) {
            this.id = id;
            this.enabled = enabled;
            this.density = density;
            this.weather = weather;
            this.precipitation = precipitation;
            this.biomeList = biomeList;
            this.blockList = blockList;
            this.needsSkyAccess = needsSkyAccess;
            this.spawnPos = spawnPos;
            this.gravity = gravity;
            this.windStrength = windStrength;
            this.stormWindStrength = stormWindStrength;
            this.rotationAmount = rotationAmount;
            this.opacity = opacity;
            this.size = size;
            this.constantScreenSize = constantScreenSize;
            this.renderType = renderType;
            this.spriteLocations = spriteLocations;
            this.tintType = tintType;
            this.rotationType = rotationType;
        }

        public void setPresetParticle() {
            Optional optional = class_7923.field_41180.method_17966(VersionUtil.parseId(this.presetParticleId));
            if (optional.isEmpty()) {
                ParticleRain.LOGGER.error("Incorrect configuration: {} is not a valid particle", (Object)this.presetParticleId);
            } else {
                this.presetParticle = (class_2394)optional.get();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Weather {
        DURING_WEATHER{

            @Override
            public boolean isCurrent(class_638 level) {
                return level.method_8419();
            }
        }
        ,
        ONLY_DURING_NORMAL_WEATHER{

            @Override
            public boolean isCurrent(class_638 level) {
                return level.method_8419() && !level.method_8546();
            }
        }
        ,
        ONLY_DURING_STORMY_WEATHER{

            @Override
            public boolean isCurrent(class_638 level) {
                return level.method_8546();
            }
        }
        ,
        AFTER_WEATHER{

            @Override
            public boolean isCurrent(class_638 level) {
                return WeatherParticleManager.afterWeatherTicksLeft > 0;
            }
        }
        ,
        CLEAR{

            @Override
            public boolean isCurrent(class_638 level) {
                return !level.method_8419();
            }
        }
        ,
        ALWAYS;


        public boolean isCurrent(class_638 level) {
            return true;
        }
    }

    public static enum SpawnPos {
        SKY,
        BLOCK_SIDES,
        BLOCK_BOTTOM,
        BLOCK_TOP,
        WORLD_SURFACE;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RenderType {
        OPAQUE{

            @Override
            public class_3999 get() {
                return class_3999.field_17828;
            }
        }
        ,
        TRANSLUCENT{

            @Override
            public class_3999 get() {
                return class_3999.field_17829;
            }
        }
        ,
        BLENDED;


        public class_3999 get() {
            return BlendedParticleRenderType.INSTANCE;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TintType {
        WATER{

            @Override
            public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
                Color waterColor = new Color(class_1163.method_4961((class_1920)level, (class_2338)pos));
                Color fogColor = new Color(((class_1959)level.method_23753(pos).comp_349()).method_24376());
                float rCol = class_3532.method_16439((float)ConfigManager.config.compat.tintMix, (float)waterColor.getRed(), (float)fogColor.getRed());
                float gCol = class_3532.method_16439((float)ConfigManager.config.compat.tintMix, (float)waterColor.getGreen(), (float)fogColor.getGreen());
                float bCol = class_3532.method_16439((float)ConfigManager.config.compat.tintMix, (float)waterColor.getBlue(), (float)fogColor.getBlue());
                p.method_3084(rCol / 255.0f, gCol / 255.0f, bCol / 255.0f);
            }
        }
        ,
        FOG{

            @Override
            public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
                Color color = new Color(((class_1959)level.method_23753(pos).comp_349()).method_24376()).darker();
                p.method_3084((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        }
        ,
        MAP{

            @Override
            public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
                Color color = VersionUtil.getMapColor(level, pos);
                p.method_3084((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        }
        ,
        CUSTOM{

            @Override
            public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
                p.method_3084((float)opts.customTint.getRed() / 255.0f, (float)opts.customTint.getGreen() / 255.0f, (float)opts.customTint.getBlue() / 255.0f);
            }
        }
        ,
        NONE;


        public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RotationType {
        COPY_CAMERA{

            @Override
            public void render(class_4588 h, class_4184 camera, float tickPercent, CustomParticle p) {
                p.renderCameraCopyQuad(h, camera, tickPercent);
            }
        }
        ,
        RELATIVE_VELOCITY{

            @Override
            public void render(class_4588 h, class_4184 camera, float tickPercent, CustomParticle p) {
                p.renderRelativeVelocityQuad(h, camera, tickPercent);
            }
        }
        ,
        WORLD_VELOCITY{

            @Override
            public void render(class_4588 h, class_4184 camera, float tickPercent, CustomParticle p) {
                p.renderWorldVelocityQuad(h, camera, tickPercent);
            }
        }
        ,
        LOOKAT_PLAYER{

            @Override
            public void render(class_4588 h, class_4184 camera, float tickPercent, CustomParticle p) {
                p.renderLookingQuad(h, camera, tickPercent);
            }
        };


        public void render(class_4588 h, class_4184 camera, float tickPercent, CustomParticle p) {
        }
    }

    @ConfigManager.OverrideName(value="ParticleData")
    public static class ShrubOptions {
        public float gravity = 0.2f;
        public float windStrength = 0.2f;
        public float stormWindStrength = 0.3f;
        public float size = 0.5f;
        public float rotationAmount = 0.6f;
        public float bounciness = 0.2f;
    }

    @ConfigManager.OverrideName(value="ParticleData")
    public static class RippleOptions {
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.Percent.class)
        public float opacity = 0.8f;
        public float size = 0.25f;
        @ConfigManager.OnChange(value=ConfigManager.ReloadResources.class)
        public int resolution = 16;
        @ConfigManager.OnChange(value=ConfigManager.ReloadResources.class)
        public boolean useResourcepackResolution = true;
    }

    @ConfigManager.OverrideName(value="ParticleData")
    public static class StreakOptions {
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.Percent.class)
        public float opacity = 0.9f;
        public float size = 0.5f;
    }

    @ConfigManager.OverrideName(value="ParticleData")
    public static class MistOptions {
        public int lifetime = 200;
        @ConfigManager.Slider
        @ConfigManager.Format(value=ConfigManager.Percent.class)
        public float opacity = 1.0f;
        public float size = 3.0f;
        public RenderStyle renderStyle = RenderStyle.BLENDED;

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum RenderStyle {
            BLENDED{

                @Override
                public class_1058 getSprite() {
                    return VersionUtil.getSprite(VersionUtil.getId("fog_translucent"));
                }

                @Override
                public class_3999 getRenderType() {
                    return BlendedParticleRenderType.INSTANCE;
                }
            }
            ,
            DITHERED;


            public class_1058 getSprite() {
                return VersionUtil.getSprite(VersionUtil.getId("fog_dithered"));
            }

            public class_3999 getRenderType() {
                return class_3999.field_17829;
            }
        }
    }
}

