/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import net.minecraft.class_1058;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;

public abstract class WeatherParticle
extends class_4003 {
    protected class_2338.class_2339 pos;
    protected class_2338.class_2339 oPos;
    boolean doCollisionAnim = false;
    float baseTemp;
    float targetOpacity;
    float oQuadSize;
    float distance;

    protected WeatherParticle(class_638 level, double x, double y, double z, class_1058 sprite) {
        super(level, x, y, z);
        this.method_18141(sprite);
        this.field_3862 = false;
        this.method_3080(this.field_17867, this.field_17867);
        this.field_3847 = ConfigManager.config.perf.particleDistance * 100;
        this.pos = new class_2338.class_2339(x, y, z);
        this.oPos = new class_2338.class_2339(x, y, z);
        this.baseTemp = ((class_1959)level.method_23753((class_2338)this.pos).comp_349()).method_8712();
    }

    public class_3999 method_18122() {
        return ConfigData.RenderType.TRANSLUCENT.get();
    }

    public void method_3070() {
        super.method_3070();
        this.oQuadSize = this.field_17867;
        this.distance = (float)class_310.method_1551().field_1773.method_19418().method_19326().method_1022(new class_243(this.field_3874, this.field_3854, this.field_3871));
        this.pos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        if (!this.pos.equals((Object)this.oPos)) {
            this.onPositionUpdate();
            this.oPos.method_10101((class_2382)this.pos);
        }
        if (this.doCollisionAnim) {
            this.tickCollisionAnim();
        }
        this.tickDistanceFade();
    }

    public void onPositionUpdate() {
        if (!ConfigManager.config.compat.crossBiomeBorder && (double)class_3532.method_15379((float)(((class_1959)this.field_3851.method_23753((class_2338)this.pos).comp_349()).method_8712() - this.baseTemp)) > 0.4) {
            this.doCollisionAnim = true;
        }
        if (this.field_3851.method_8320((class_2338)this.pos).method_26234((class_1922)this.field_3851, (class_2338)this.pos) || !this.field_3851.method_8316((class_2338)this.pos).method_15769()) {
            this.method_3085();
        }
    }

    public void tickDistanceFade() {
        float renderDistance = ConfigManager.config.perf.particleDistance;
        if (this.distance > renderDistance) {
            this.method_3085();
        } else {
            this.field_3841 = class_3532.method_16439((float)(this.distance / renderDistance), (float)this.targetOpacity, (float)0.0f);
        }
    }

    public float method_18132(float scaleFactor) {
        return class_3532.method_16439((float)scaleFactor, (float)this.oQuadSize, (float)this.field_17867);
    }

    public void tickCollisionAnim() {
        float deltaMovement = (float)new class_243(this.field_3852, this.field_3869, this.field_3850).method_1033();
        this.field_17867 -= deltaMovement;
        if (this.field_17867 <= 0.0f) {
            this.method_3085();
        }
    }

    public Quaternionf turnBackfaceFlipways(Quaternionf quaternion, Vector3f cameraOffset) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)cameraOffset);
        if (dot > 0.0f) {
            return quaternion.mul((Quaternionfc)class_7833.field_40716.rotation((float)Math.PI));
        }
        return quaternion;
    }

    protected void renderRotatedQuad(class_4588 vertexConsumer, Quaternionf quaternionf, float x, float y, float z, float tickPercent) {
        quaternionf.rotateY((float)Math.PI);
        float size = this.method_18132(tickPercent);
        float u0 = this.method_18133();
        float u1 = this.method_18134();
        float v0 = this.method_18135();
        float v1 = this.method_18136();
        int lightColor = this.method_3068(tickPercent);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f = vector3fs[k];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(size);
            vector3f.add(x, y, z);
        }
        vertexConsumer.method_22912((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).method_22913(u1, v1).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916(lightColor).method_1344();
        vertexConsumer.method_22912((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).method_22913(u1, v0).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916(lightColor).method_1344();
        vertexConsumer.method_22912((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).method_22913(u0, v0).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916(lightColor).method_1344();
        vertexConsumer.method_22912((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).method_22913(u0, v1).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916(lightColor).method_1344();
    }
}

