/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.mixin.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.WeatherEffectRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.config.ConfigManager;

@Mixin(value={WeatherEffectRenderer.class})
public abstract class WeatherEffectRendererMixin {
    @Shadow
    protected abstract Biome.Precipitation getPrecipitationAt(Level var1, BlockPos var2);

    @WrapOperation(method={"tickRainParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WeatherEffectRenderer;getPrecipitationAt(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;")})
    public Biome.Precipitation getPrecipitationAt(WeatherEffectRenderer instance, Level level, BlockPos blockPos3, Operation<Biome.Precipitation> original) {
        return Biome.Precipitation.RAIN;
    }

    @Inject(method={"tickRainParticles"}, at={@At(value="FIELD", opcode=181, shift=At.Shift.AFTER, ordinal=1, target="Lnet/minecraft/client/renderer/WeatherEffectRenderer;rainSoundTime:I")}, cancellable=true)
    public void hookWeatherSounds(ClientLevel level, Camera camera, int ticks, ParticleStatus particleStatus, CallbackInfo ci, @Local(ordinal=0) BlockPos blockPos, @Local(ordinal=1) BlockPos blockPos2) {
        ParticleRain.doAdditionalWeatherSounds(level, blockPos, blockPos2, ci);
    }

    @WrapOperation(method={"tickRainParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;playLocalSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V")})
    public void adjustRainVolume(ClientLevel instance, BlockPos blockPos, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, boolean distanceDelay, Operation<Void> original) {
        original.call(new Object[]{instance, blockPos, soundEvent, soundSource, Float.valueOf(ConfigManager.config.sound.rainVolume), Float.valueOf(pitch), distanceDelay});
    }

    @Inject(method={"tickRainParticles"}, at={@At(value="HEAD")})
    public void tickRainParticles(ClientLevel level, Camera camera, int ticks, ParticleStatus particleStatus, CallbackInfo ci, @Local(argsOnly=true) LocalRef<ParticleStatus> particleStatusLocalRef) {
        if (!ConfigManager.config.compat.doDefaultSplashing) {
            particleStatusLocalRef.set((Object)ParticleStatus.MINIMAL);
        }
    }

    @Inject(method={"render(Lnet/minecraft/world/level/Level;Lnet/minecraft/client/renderer/MultiBufferSource;IFLnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(Level level, MultiBufferSource bufferSource, int ticks, float partialTick, Vec3 cameraPosition, CallbackInfo ci) {
        if (!ConfigManager.config.compat.renderDefaultWeather) {
            ci.cancel();
        }
    }
}

