/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.block;

import com.mojang.serialization.MapCodec;
import eu.midnightdust.motschen.rocks.block.blockentity.NetherGeyserBlockEntity;
import eu.midnightdust.motschen.rocks.registry.RocksBlockEntities;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NetherGeyser
extends BaseEntityBlock
implements EntityBlock {
    public static final MapCodec<NetherGeyser> CODEC = NetherGeyser.simpleCodec(NetherGeyser::new);
    private static final VoxelShape SHAPE;
    public static final BooleanProperty ACTIVE;

    public NetherGeyser(BlockBehaviour.Properties properties) {
        super(properties.strength(10.0f).noCollision().noOcclusion().sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NetherGeyserBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return NetherGeyser.createTickerHelper(type, RocksBlockEntities.NETHER_GEYSER_BE.get(), NetherGeyserBlockEntity::tick);
    }

    public BlockState getStateForPlacement(BlockPlaceContext itemPlacementContext) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(itemPlacementContext)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos, Direction.UP);
    }

    static {
        ACTIVE = BooleanProperty.create((String)"active");
        SHAPE = NetherGeyser.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    }
}

