/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.block;

import com.mojang.serialization.MapCodec;
import eu.midnightdust.motschen.rocks.block.blockentity.OverworldGeyserBlockEntity;
import eu.midnightdust.motschen.rocks.registry.RocksBlockEntities;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OverworldGeyser
extends BaseEntityBlock
implements EntityBlock {
    public static final MapCodec<OverworldGeyser> CODEC = OverworldGeyser.simpleCodec(OverworldGeyser::new);
    private static final VoxelShape SHAPE;
    private static final VoxelShape SNOWY_SHAPE;
    public static final BooleanProperty ACTIVE;
    public static final BooleanProperty SNOWY;

    public OverworldGeyser(BlockBehaviour.Properties properties) {
        super(properties.strength(10.0f).noCollision().noOcclusion().sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OverworldGeyserBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return OverworldGeyser.createTickerHelper(type, RocksBlockEntities.OVERWORLD_GEYSER_BE.get(), OverworldGeyserBlockEntity::tick);
    }

    public BlockState getStateForPlacement(BlockPlaceContext itemPlacementContext) {
        return (BlockState)((BlockState)Objects.requireNonNull(super.getStateForPlacement(itemPlacementContext)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE, SNOWY});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)SNOWY)).booleanValue()) {
            return SNOWY_SHAPE;
        }
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos, Direction.UP);
    }

    static {
        ACTIVE = BooleanProperty.create((String)"active");
        SNOWY = BlockStateProperties.SNOWY;
        VoxelShape shape = OverworldGeyser.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
        VoxelShape snow_layer = OverworldGeyser.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape shape_snow = OverworldGeyser.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
        VoxelShape snowy = Shapes.or((VoxelShape)snow_layer, (VoxelShape)shape_snow);
        SHAPE = shape;
        SNOWY_SHAPE = snowy;
    }
}

