/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.block;

import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.blockstates.SeashellVariation;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Seashell
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE;
    private static final EnumProperty<SeashellVariation> SEASHELL_VARIATION;
    public static final BooleanProperty WATERLOGGED;

    public Seashell(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SEASHELL_VARIATION, (Comparable)((Object)SeashellVariation.PINK))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext itemPlacementContext) {
        FluidState fluidState = itemPlacementContext.getLevel().getFluidState(itemPlacementContext.getClickedPos());
        return (BlockState)((BlockState)Objects.requireNonNull(super.getStateForPlacement(itemPlacementContext)).setValue(SEASHELL_VARIATION, (Comparable)((Object)SeashellVariation.values()[itemPlacementContext.getLevel().random.nextIntBetweenInclusive(0, 2)]))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isCreative()) {
            if (state.getValue(SEASHELL_VARIATION) == SeashellVariation.YELLOW) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(SEASHELL_VARIATION, (Comparable)((Object)SeashellVariation.WHITE)));
            }
            if (state.getValue(SEASHELL_VARIATION) == SeashellVariation.WHITE) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(SEASHELL_VARIATION, (Comparable)((Object)SeashellVariation.PINK)));
            }
            if (state.getValue(SEASHELL_VARIATION) == SeashellVariation.PINK) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(SEASHELL_VARIATION, (Comparable)((Object)SeashellVariation.YELLOW)));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SEASHELL_VARIATION, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos, Direction.UP);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        return true;
    }

    static {
        SEASHELL_VARIATION = Rocks.SEASHELL_VARIATION;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        SHAPE = Seashell.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    }
}

