/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import eu.midnightdust.motschen.rocks.datagen.RocksDatagenProvider;
import eu.midnightdust.motschen.rocks.datagen.RocksLanguageProvider;
import eu.midnightdust.motschen.rocks.datagen.RocksLootTableProvider;
import eu.midnightdust.motschen.rocks.datagen.RocksModelProvider;
import eu.midnightdust.motschen.rocks.datagen.RocksRecipeProvider;
import eu.midnightdust.motschen.rocks.datagen.RocksTagProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber
public class RocksDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new RocksLanguageProvider(packOutput));
        generator.addProvider(true, (DataProvider)new RocksModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new RocksLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new RocksRecipeProvider.Runner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new RocksTagProvider.RocksBiomes(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new RocksDatagenProvider(packOutput, event.getLookupProvider(), Set.of("rocks")));
    }
}

