/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.registry.RocksRegistry;
import eu.midnightdust.motschen.rocks.util.RockType;
import eu.midnightdust.motschen.rocks.util.StickType;
import java.util.function.Supplier;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class RocksLanguageProvider
extends LanguageProvider {
    public RocksLanguageProvider(PackOutput output) {
        super(output, "rocks", "en_us");
    }

    protected void addTranslations() {
        this.createRepeatedTranslations(" Rock", " Fragment", " Stick");
        this.addBlock((Supplier)RocksRegistry.GEYSER, "Geyser");
        this.addBlock((Supplier)RocksRegistry.NETHER_GEYSER, "Nether Geyser");
        this.addBlock((Supplier)RocksRegistry.STARFISH, "Starfish");
        this.addBlock((Supplier)RocksRegistry.SEASHELL, "Seashell");
        this.addBlock((Supplier)RocksRegistry.PINECONE, "Pinecone");
    }

    public void createRepeatedTranslations(String rockWord, String splitterWord, String stickWord) {
        Block block;
        for (RockType rockType : RockType.values()) {
            block = (Block)BuiltInRegistries.BLOCK.getValue(Rocks.modLoc(rockType.getName()));
            String baseTranslation = I18n.get((String)rockType.getStoneBlock().getDescriptionId(), (Object[])new Object[0]);
            this.add(block, baseTranslation + rockWord);
            if (rockType == RockType.GRAVEL) continue;
            String splitterBaseTranslation = I18n.get((String)rockType.getFragment().getStoneBlock().getDescriptionId(), (Object[])new Object[0]);
            Item item = (Item)BuiltInRegistries.ITEM.getValue(Rocks.modLoc(rockType.getFragment().getName()));
            this.add(item, splitterBaseTranslation + splitterWord);
        }
        for (Enum enum_ : StickType.values()) {
            block = (Block)BuiltInRegistries.BLOCK.getValue(Rocks.modLoc(((StickType)enum_).getName() + "_stick"));
            Object object = ((StickType)enum_).getBaseBlock();
            if (!(object instanceof Block)) continue;
            Block logBlock = object;
            object = BuiltInRegistries.BLOCK.getValue(ResourceLocation.withDefaultNamespace((String)(((StickType)enum_).getName() + "_planks")));
            if (!(object instanceof Block)) continue;
            Object plankBlock = object;
            object = BuiltInRegistries.BLOCK.getValue(ResourceLocation.withDefaultNamespace((String)(((StickType)enum_).getName() + "_stairs")));
            if (!(object instanceof Block)) continue;
            Object stairBlock = object;
            String logTranslation = I18n.get((String)logBlock.getDescriptionId(), (Object[])new Object[0]);
            String plankTranslation = I18n.get((String)plankBlock.getDescriptionId(), (Object[])new Object[0]);
            String stairTranslation = I18n.get((String)stairBlock.getDescriptionId(), (Object[])new Object[0]);
            this.add(block, this.getCommonString(this.getCommonString(logTranslation, plankTranslation), this.getCommonString(plankTranslation, stairTranslation)) + stickWord);
        }
    }

    public String getCommonString(String first, String second) {
        StringBuilder commonTranslation = new StringBuilder();
        block0: for (String subFirst : first.split(" ")) {
            for (String subSecond : second.split(" ")) {
                Object commonPart = "";
                if (!second.contains(" ")) {
                    char c;
                    String temp;
                    char[] cArray = subFirst.toCharArray();
                    int n = cArray.length;
                    for (int i = 0; i < n && subSecond.startsWith(temp = (String)commonPart + (c = cArray[i])); ++i) {
                        commonPart = temp;
                    }
                } else if (subFirst.equals(subSecond)) {
                    commonPart = subSecond;
                }
                if (((String)commonPart).isEmpty()) continue;
                commonTranslation.append((String)commonPart).append(" ");
                continue block0;
            }
        }
        return commonTranslation.substring(0, commonTranslation.length() - 1);
    }
}

