/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.registry.RocksRegistry;
import eu.midnightdust.motschen.rocks.util.RockType;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class RocksLootTableProvider
extends LootTableProvider {
    public RocksLootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(RocksBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider);
    }

    private static class RocksBlockLoot
    extends BlockLootSubProvider {
        protected RocksBlockLoot(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
        }

        protected void generate() {
            Rocks.rocksByType.forEach((rockType, rock) -> this.addSilkTouchDrop((Block)rock.get(), rockType != RockType.GRAVEL ? Rocks.splittersByType.get(rockType).asOptional().orElse(Items.EGG) : Items.FLINT));
            Rocks.sticksByType.forEach((stickType, stick) -> this.addSilkTouchDrop((Block)stick.get(), Items.STICK));
            this.addSilkTouchDrop((Block)RocksRegistry.PINECONE.get(), Items.SPRUCE_SAPLING);
            this.addSilkTouchOrRareDrop((Block)RocksRegistry.SEASHELL.get(), Items.NAUTILUS_SHELL, 0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f);
            this.addCopyStateDrop((Block)RocksRegistry.STARFISH.get(), new Property[]{Rocks.STARFISH_VARIATION});
            this.add((Block)RocksRegistry.GEYSER.get(), RocksBlockLoot.noDrop());
            this.add((Block)RocksRegistry.NETHER_GEYSER.get(), RocksBlockLoot.noDrop());
        }

        public void addCopyStateDrop(Block block, Property<?> ... properties) {
            CopyBlockState.Builder lootFunction = CopyBlockState.copyState((Block)block);
            Arrays.stream(properties).forEach(arg_0 -> ((CopyBlockState.Builder)lootFunction).copy(arg_0));
            this.add(block, LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)lootFunction)))));
        }

        public void addSilkTouchDrop(Block block, Item alternative) {
            this.add(block, this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)alternative)));
        }

        public void addSilkTouchOrRareDrop(Block block, Item alternative, float ... chances) {
            HolderLookup.RegistryLookup impl = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.add(block, this.createSilkTouchDispatchTable(block, LootItem.lootTableItem((ItemLike)alternative).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)impl.getOrThrow(Enchantments.FORTUNE), (float[])chances))));
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return RocksRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

