/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import com.mojang.math.Quadrant;
import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.block.NetherGeyser;
import eu.midnightdust.motschen.rocks.block.OverworldGeyser;
import eu.midnightdust.motschen.rocks.block.Pinecone;
import eu.midnightdust.motschen.rocks.block.Seashell;
import eu.midnightdust.motschen.rocks.block.Starfish;
import eu.midnightdust.motschen.rocks.blockstates.StarfishVariation;
import eu.midnightdust.motschen.rocks.registry.RocksRegistry;
import eu.midnightdust.motschen.rocks.util.RockType;
import eu.midnightdust.motschen.rocks.util.StickType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;

public class RocksModelProvider
extends ModelProvider {
    public static final TextureSlot ZERO_TEXTURE_KEY = TextureSlot.create((String)"0");

    public RocksModelProvider(PackOutput output) {
        super(output, "rocks");
    }

    public static ResourceLocation getBlockId(String s) {
        return Rocks.modLoc("block/" + s);
    }

    public static ResourceLocation getItemId(String s) {
        return Rocks.modLoc("item/" + s);
    }

    public static ModelTemplate getSimpleParentModel(ResourceLocation parentId, String variant) {
        return new ModelTemplate(Optional.of(parentId), Optional.of(variant), new TextureSlot[]{ZERO_TEXTURE_KEY});
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        Item item;
        Block block;
        for (RockType rockType : RockType.values()) {
            block = (Block)BuiltInRegistries.BLOCK.getValue(Rocks.modLoc(rockType.getName()));
            RockModel.registerBlockModel(blockModels, block, rockType.getStoneBlock());
        }
        for (Enum enum_ : StickType.values()) {
            block = (Block)BuiltInRegistries.BLOCK.getValue(Rocks.modLoc(((StickType)enum_).getName() + "_stick"));
            StickModel.registerBlockModel(blockModels, block, ((StickType)enum_).getBaseBlock());
        }
        for (Enum enum_ : RockType.values()) {
            item = (Item)BuiltInRegistries.ITEM.getValue(Rocks.modLoc(((RockType)enum_).getName()));
            RocksModelProvider.registerParentedItemModel(itemModels, item, RocksModelProvider.getItemId("rock_base"), ((RockType)enum_).getStoneBlock());
            if (enum_ == RockType.GRAVEL) continue;
            Item splitter = (Item)BuiltInRegistries.ITEM.getValue(Rocks.modLoc(((RockType)enum_).getFragment().getName()));
            RocksModelProvider.registerParentedItemModel(itemModels, splitter, RocksModelProvider.getItemId("splitter_base"), ((RockType)enum_).getFragment().getStoneBlock());
        }
        for (Enum enum_ : StickType.values()) {
            item = (Item)BuiltInRegistries.ITEM.getValue(Rocks.modLoc(((StickType)enum_).getName() + "_stick"));
            RocksModelProvider.registerParentedItemModel(itemModels, item, RocksModelProvider.getItemId("stick_base"), ((StickType)enum_).getBaseBlock());
        }
        itemModels.declareCustomModelItem(RocksRegistry.GEYSER.asItem());
        itemModels.declareCustomModelItem(RocksRegistry.NETHER_GEYSER.asItem());
        this.registerStarfishItemVariations(itemModels, (Block)RocksRegistry.STARFISH.get());
        itemModels.declareCustomModelItem(RocksRegistry.SEASHELL.asItem());
        itemModels.declareCustomModelItem(RocksRegistry.PINECONE.asItem());
    }

    protected Stream<? extends Holder<Block>> getKnownBlocks() {
        ArrayList<DeferredHolder> blocks = new ArrayList<DeferredHolder>(RocksRegistry.BLOCKS.getEntries());
        blocks.removeIf(deferred -> deferred.get() instanceof OverworldGeyser || deferred.get() instanceof NetherGeyser || deferred.get() instanceof Pinecone || deferred.get() instanceof Seashell || deferred.get() instanceof Starfish);
        return blocks.stream();
    }

    public static void registerParentedItemModel(ItemModelGenerators modelGenerator, Item item, ResourceLocation parentId, Block textureSource) {
        TextureMapping textureMap = TextureMapping.singleSlot((TextureSlot)ZERO_TEXTURE_KEY, (ResourceLocation)TextureMapping.getBlockTexture((Block)textureSource));
        ResourceLocation itemModel = RocksModelProvider.getSimpleParentModel(parentId, "").create(item, textureMap, modelGenerator.modelOutput);
        modelGenerator.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)itemModel));
    }

    public final void registerStarfishItemVariations(ItemModelGenerators modelGenerator, Block starfish) {
        HashMap<StarfishVariation, ItemModel.Unbaked> variantMap = new HashMap<StarfishVariation, ItemModel.Unbaked>();
        for (StarfishVariation variation : StarfishVariation.values()) {
            variantMap.put(variation, ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Block)starfish, (String)("_" + variation.toString()))));
        }
        modelGenerator.itemModelOutput.accept(starfish.asItem(), ItemModelUtils.selectBlockItemProperty(Rocks.STARFISH_VARIATION, (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)starfish.asItem())), variantMap));
    }

    public static MultiVariant getRandomRotationWeightedVariant(ResourceLocation modelId) {
        WeightedList.Builder list = WeightedList.builder();
        for (Quadrant rotation : Quadrant.values()) {
            Variant rotatedVariant = new Variant(modelId, Variant.SimpleModelState.DEFAULT.withY(rotation));
            list.add((Object)rotatedVariant);
        }
        return new MultiVariant(list.build());
    }

    private static class RockModel {
        private RockModel() {
        }

        public static void registerBlockModel(BlockModelGenerators modelGenerator, Block rockBlock, Block textureSource) {
            TextureMapping textureMap = TextureMapping.singleSlot((TextureSlot)ZERO_TEXTURE_KEY, (ResourceLocation)TextureMapping.getBlockTexture((Block)textureSource));
            ResourceLocation largeRock = RocksModelProvider.getSimpleParentModel(RocksModelProvider.getBlockId("large_rock"), "_large").create(rockBlock, textureMap, modelGenerator.modelOutput);
            ResourceLocation mediumRock = RocksModelProvider.getSimpleParentModel(RocksModelProvider.getBlockId("medium_rock"), "_medium").create(rockBlock, textureMap, modelGenerator.modelOutput);
            ResourceLocation smallRock = RocksModelProvider.getSimpleParentModel(RocksModelProvider.getBlockId("small_rock"), "_small").create(rockBlock, textureMap, modelGenerator.modelOutput);
            ResourceLocation tinyRock = RocksModelProvider.getSimpleParentModel(RocksModelProvider.getBlockId("tiny_rock"), "_tiny").create(rockBlock, textureMap, modelGenerator.modelOutput);
            modelGenerator.blockStateOutput.accept(RockModel.createBlockState(rockBlock, new ResourceLocation[]{largeRock, mediumRock, smallRock, tinyRock}));
        }

        private static BlockModelDefinitionGenerator createBlockState(Block rockBlock, ResourceLocation[] modelIds) {
            return MultiVariantGenerator.dispatch((Block)rockBlock).with(PropertyDispatch.initial(Rocks.ROCK_VARIATION).generate(variation -> RocksModelProvider.getRandomRotationWeightedVariant(modelIds[3 - variation.ordinal()])));
        }
    }

    private static class StickModel {
        private StickModel() {
        }

        public static void registerBlockModel(BlockModelGenerators modelGenerator, Block stickBlock, Block textureSource) {
            TextureMapping textureMap = TextureMapping.singleSlot((TextureSlot)ZERO_TEXTURE_KEY, (ResourceLocation)TextureMapping.getBlockTexture((Block)textureSource));
            ResourceLocation largeRock = RocksModelProvider.getSimpleParentModel(RocksModelProvider.getBlockId("large_stick"), "_large").create(stickBlock, textureMap, modelGenerator.modelOutput);
            ResourceLocation mediumRock = RocksModelProvider.getSimpleParentModel(RocksModelProvider.getBlockId("medium_stick"), "_medium").create(stickBlock, textureMap, modelGenerator.modelOutput);
            ResourceLocation smallRock = RocksModelProvider.getSimpleParentModel(RocksModelProvider.getBlockId("small_stick"), "_small").create(stickBlock, textureMap, modelGenerator.modelOutput);
            modelGenerator.blockStateOutput.accept(StickModel.createBlockState(stickBlock, new ResourceLocation[]{largeRock, mediumRock, smallRock}));
        }

        private static BlockModelDefinitionGenerator createBlockState(Block stickBlock, ResourceLocation[] modelIds) {
            return MultiVariantGenerator.dispatch((Block)stickBlock).with(PropertyDispatch.initial(Rocks.STICK_VARIATION).generate(variation -> RocksModelProvider.getRandomRotationWeightedVariant(modelIds[2 - variation.ordinal()])));
        }
    }
}

