/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class RocksTagProvider {

    public static class RocksBiomes
    extends BiomeTagsProvider {
        public static final TagKey<Biome> IS_MANGROVE_SWAMP = RocksBiomes.create(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"is_mangrove_swamp"));
        public static final TagKey<Biome> IS_CHERRY_GROVE = RocksBiomes.create(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"is_cherry_grove"));
        public static final TagKey<Biome> IS_PALE_GARDEN = RocksBiomes.create(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"is_pale_garden"));

        public RocksBiomes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider, "rocks");
        }

        private static TagKey<Biome> create(ResourceLocation location) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)location);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(IS_MANGROVE_SWAMP).add((Object)Biomes.MANGROVE_SWAMP);
            this.tag(IS_CHERRY_GROVE).add((Object)Biomes.CHERRY_GROVE);
            this.tag(IS_PALE_GARDEN).add((Object)Biomes.PALE_GARDEN);
        }
    }
}

