/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.registry;

import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.block.NetherGeyser;
import eu.midnightdust.motschen.rocks.block.OverworldGeyser;
import eu.midnightdust.motschen.rocks.block.Pinecone;
import eu.midnightdust.motschen.rocks.block.Rock;
import eu.midnightdust.motschen.rocks.block.Seashell;
import eu.midnightdust.motschen.rocks.block.Starfish;
import eu.midnightdust.motschen.rocks.block.Stick;
import eu.midnightdust.motschen.rocks.util.RockType;
import eu.midnightdust.motschen.rocks.util.StickType;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RocksRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"rocks");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"rocks");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"rocks");
    public static final DeferredBlock<Rock> ROCK = RocksRegistry.registerRock("rock", RockType.STONE);
    public static final DeferredBlock<Rock> GRANITE_ROCK = RocksRegistry.registerRock("granite_rock", RockType.GRANITE);
    public static final DeferredBlock<Rock> DIORITE_ROCK = RocksRegistry.registerRock("diorite_rock", RockType.DIORITE);
    public static final DeferredBlock<Rock> ANDESITE_ROCK = RocksRegistry.registerRock("andesite_rock", RockType.ANDESITE);
    public static final DeferredBlock<Rock> SAND_ROCK = RocksRegistry.registerRock("sand_rock", RockType.SANDSTONE);
    public static final DeferredBlock<Rock> RED_SAND_ROCK = RocksRegistry.registerRock("red_sand_rock", RockType.RED_SANDSTONE);
    public static final DeferredBlock<Rock> GRAVEL_ROCK = RocksRegistry.registerRock("gravel_rock", RockType.GRAVEL);
    public static final DeferredBlock<Rock> END_STONE_ROCK = RocksRegistry.registerRock("end_stone_rock", RockType.END_STONE);
    public static final DeferredBlock<Rock> NETHERRACK_ROCK = RocksRegistry.registerRock("netherrack_rock", RockType.NETHERRACK);
    public static final DeferredBlock<Rock> SOUL_SOIL_ROCK = RocksRegistry.registerRock("soul_soil_rock", RockType.SOUL_SOIL);
    public static final DeferredBlock<Rock> ICE_ROCK = RocksRegistry.registerRock("ice_rock", RockType.ICE);
    public static final DeferredBlock<Stick> OAK_STICK = RocksRegistry.registerStick("oak_stick", StickType.OAK);
    public static final DeferredBlock<Stick> SPRUCE_STICK = RocksRegistry.registerStick("spruce_stick", StickType.SPRUCE);
    public static final DeferredBlock<Stick> BIRCH_STICK = RocksRegistry.registerStick("birch_stick", StickType.BIRCH);
    public static final DeferredBlock<Stick> ACACIA_STICK = RocksRegistry.registerStick("acacia_stick", StickType.ACACIA);
    public static final DeferredBlock<Stick> JUNGLE_STICK = RocksRegistry.registerStick("jungle_stick", StickType.JUNGLE);
    public static final DeferredBlock<Stick> DARK_OAK_STICK = RocksRegistry.registerStick("dark_oak_stick", StickType.DARK_OAK);
    public static final DeferredBlock<Stick> MANGROVE_STICK = RocksRegistry.registerStick("mangrove_stick", StickType.MANGROVE);
    public static final DeferredBlock<Stick> CHERRY_STICK = RocksRegistry.registerStick("cherry_stick", StickType.CHERRY);
    public static final DeferredBlock<Stick> BAMBOO_STICK = RocksRegistry.registerStick("bamboo_stick", StickType.BAMBOO);
    public static final DeferredBlock<Stick> PALE_OAK_STICK = RocksRegistry.registerStick("pale_oak_stick", StickType.PALE_OAK);
    public static final DeferredBlock<Stick> CRIMSON_STICK = RocksRegistry.registerStick("crimson_stick", StickType.CRIMSON);
    public static final DeferredBlock<Stick> WARPED_STICK = RocksRegistry.registerStick("warped_stick", StickType.WARPED);
    public static final DeferredBlock<Pinecone> PINECONE = RocksRegistry.registerBlockWithItem("pinecone", Pinecone::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY));
    public static final DeferredBlock<Seashell> SEASHELL = RocksRegistry.registerBlockWithItem("seashell", Seashell::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY));
    public static final DeferredBlock<Starfish> STARFISH = RocksRegistry.registerBlockWithItem("starfish", Starfish::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY));
    public static final DeferredBlock<OverworldGeyser> GEYSER = RocksRegistry.registerBlockWithItem("geyser", OverworldGeyser::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE));
    public static final DeferredBlock<NetherGeyser> NETHER_GEYSER = RocksRegistry.registerBlockWithItem("nether_geyser", NetherGeyser::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE));
    public static final DeferredItem<Item> COBBLESTONE_SPLITTER = RocksRegistry.registerSplitter("cobblestone_splitter", RockType.STONE);
    public static final DeferredItem<Item> GRANITE_SPLITTER = RocksRegistry.registerSplitter("granite_splitter", RockType.GRANITE);
    public static final DeferredItem<Item> DIORITE_SPLITTER = RocksRegistry.registerSplitter("diorite_splitter", RockType.DIORITE);
    public static final DeferredItem<Item> ANDESITE_SPLITTER = RocksRegistry.registerSplitter("andesite_splitter", RockType.ANDESITE);
    public static final DeferredItem<Item> SANDSTONE_SPLITTER = RocksRegistry.registerSplitter("sandstone_splitter", RockType.SANDSTONE);
    public static final DeferredItem<Item> RED_SANDSTONE_SPLITTER = RocksRegistry.registerSplitter("red_sandstone_splitter", RockType.RED_SANDSTONE);
    public static final DeferredItem<Item> END_STONE_SPLITTER = RocksRegistry.registerSplitter("end_stone_splitter", RockType.END_STONE);
    public static final DeferredItem<Item> NETHERRACK_SPLITTER = RocksRegistry.registerSplitter("netherrack_splitter", RockType.NETHERRACK);
    public static final DeferredItem<Item> SOUL_SOIL_SPLITTER = RocksRegistry.registerSplitter("soul_soil_splitter", RockType.SOUL_SOIL);
    public static final DeferredItem<Item> ICE_SPLITTER = RocksRegistry.registerSplitter("ice_splitter", RockType.ICE);
    public static final Supplier<CreativeModeTab> ROCKS_TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ROCK.get())).title((Component)Component.translatable((String)"itemGroup.rocks")).displayItems((displayParameters, output) -> {
        List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
        output.acceptAll(stacks);
    }).build());

    public static DeferredBlock<Rock> registerRock(String name, RockType type) {
        DeferredBlock<Rock> block = RocksRegistry.registerBlockWithItem(name, Rock::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY));
        Rocks.rocksByType.put(type, block);
        return block;
    }

    public static DeferredBlock<Stick> registerStick(String name, StickType type) {
        DeferredBlock<Stick> block = RocksRegistry.registerBlockWithItem(name, Stick::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY));
        Rocks.sticksByType.put(type, block);
        return block;
    }

    public static <B extends Block> DeferredBlock<B> registerBlockWithItem(String name, Function<BlockBehaviour.Properties, ? extends B> supplier, Supplier<BlockBehaviour.Properties> propertiesSupplier) {
        DeferredBlock block = BLOCKS.registerBlock(name, supplier, propertiesSupplier);
        ITEMS.registerSimpleBlockItem((Holder)block);
        return block;
    }

    public static DeferredItem<Item> registerSplitter(String name, RockType type) {
        DeferredItem item = ITEMS.registerSimpleItem(name);
        Rocks.splittersByType.put(type, (DeferredItem<Item>)item);
        return item;
    }
}

