/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.util;

import eu.midnightdust.motschen.rocks.Rocks;
import java.util.Arrays;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public enum RockType {
    STONE("rock"),
    ANDESITE("andesite_rock"),
    GRANITE("granite_rock"),
    DIORITE("diorite_rock"),
    GRAVEL("gravel_rock"),
    SANDSTONE("sand_rock"),
    RED_SANDSTONE("red_sand_rock"),
    NETHERRACK("netherrack_rock"),
    SOUL_SOIL("soul_soil_rock"),
    END_STONE("end_stone_rock"),
    ICE("ice_rock");

    private final String name;

    private RockType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getStoneId() {
        return ResourceLocation.withDefaultNamespace((String)this.toString().toLowerCase());
    }

    public Block getStoneBlock() {
        return (Block)BuiltInRegistries.BLOCK.getValue(this.getStoneId());
    }

    public ResourceLocation[] getVariations() {
        ResourceLocation[] variations = new ResourceLocation[]{Rocks.modLoc(this.name + "_tiny"), Rocks.modLoc(this.name + "_small"), Rocks.modLoc(this.name + "_medium"), Rocks.modLoc(this.name + "_large")};
        return variations;
    }

    public static RockType fromBlockName(String name) {
        return Arrays.stream(RockType.values()).filter(type -> name.replace("block.rocks.", "").replace("tiny", "").replace("small_", "").replace("medium_", "").replace("large_", "").equals(type.getName())).findFirst().orElse(STONE);
    }

    public Fragment getFragment() {
        return new Fragment(this);
    }

    public static class Fragment {
        private final RockType type;

        Fragment(RockType type) {
            this.type = type;
        }

        public String getName() {
            Object splitterName = this.type.name().toLowerCase() + "_splitter";
            if (this.type.equals((Object)STONE)) {
                splitterName = "cobblestone_splitter";
            }
            return splitterName;
        }

        public ResourceLocation getStoneId() {
            if (this.type == STONE) {
                return ResourceLocation.withDefaultNamespace((String)"cobblestone");
            }
            return ResourceLocation.withDefaultNamespace((String)this.type.toString().toLowerCase());
        }

        public Block getStoneBlock() {
            return (Block)BuiltInRegistries.BLOCK.getValue(this.getStoneId());
        }
    }
}

