/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.world;

import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.datagen.RocksTagProvider;
import eu.midnightdust.motschen.rocks.world.modifier.AddFeaturesBlacklistBiomeModifier;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class RocksBiomeModifiers {
    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        List<HolderSet.Named> overworld = List.of(biomeGetter.getOrThrow(BiomeTags.IS_OVERWORLD));
        List<HolderSet.Named> rockBlacklist = List.of(biomeGetter.getOrThrow(BiomeTags.IS_NETHER), biomeGetter.getOrThrow(BiomeTags.IS_END), biomeGetter.getOrThrow(BiomeTags.HAS_IGLOO), biomeGetter.getOrThrow(Tags.Biomes.IS_SANDY), biomeGetter.getOrThrow(BiomeTags.IS_BADLANDS), biomeGetter.getOrThrow(BiomeTags.IS_OCEAN));
        context.register(RocksBiomeModifiers.getModifierKey("rock"), (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("rock_mix"), (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("rock_mix"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("granite_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("granite_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("diorite_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("diorite_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("andesite_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("andesite_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("sand_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_BEACH), biomeGetter.getOrThrow(Tags.Biomes.IS_SANDY), biomeGetter.getOrThrow(BiomeTags.IS_BADLANDS)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("sand_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("red_sand_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(Tags.Biomes.IS_SANDY), biomeGetter.getOrThrow(BiomeTags.IS_BADLANDS)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("red_sand_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("ice_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(Tags.Biomes.IS_COLD), biomeGetter.getOrThrow(BiomeTags.HAS_IGLOO)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("ice_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("end_stone_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_END)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("end_stone_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("oak_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_FOREST), biomeGetter.getOrThrow(Tags.Biomes.IS_PLAINS), biomeGetter.getOrThrow(Tags.Biomes.IS_SWAMP)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("oak_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("birch_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_FOREST)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("birch_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("spruce_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_TAIGA)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("spruce_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("pinecone"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_TAIGA)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("pinecone"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("acacia_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_SAVANNA)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("acacia_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("jungle_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_JUNGLE)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("jungle_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("bamboo_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_JUNGLE)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("bamboo_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("pale_oak_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(RocksTagProvider.RocksBiomes.IS_PALE_GARDEN)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("pale_oak_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("dark_oak_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(Tags.Biomes.IS_DARK_FOREST)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("dark_oak_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("mangrove_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(RocksTagProvider.RocksBiomes.IS_MANGROVE_SWAMP)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("mangrove_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("cherry_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(RocksTagProvider.RocksBiomes.IS_CHERRY_GROVE)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("cherry_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("seashell"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_BEACH)), List.of(biomeGetter.getOrThrow(Tags.Biomes.IS_SNOWY)), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("seashell"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("starfish"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_BEACH)), List.of(biomeGetter.getOrThrow(Tags.Biomes.IS_SNOWY)), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("starfish"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("underwater_seashell"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_OCEAN)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("underwater_seashell"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("underwater_starfish"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_OCEAN)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("underwater_starfish"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("netherrack_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_NETHER)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("netherrack_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("soul_soil_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_NETHER)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("soul_soil_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("nether_gravel_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_NETHER)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("nether_gravel_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("nether_geyser"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_NETHER)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("nether_geyser"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("warped_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_NETHER)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("warped_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("crimson_stick"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(BiomeTags.IS_NETHER)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("crimson_stick"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("gravel_rock"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(), List.of(biomeGetter.getOrThrow(BiomeTags.IS_NETHER)), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("gravel_rock"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(RocksBiomeModifiers.getModifierKey("snowy_geyser"), (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.getOrThrow(Tags.Biomes.IS_SNOWY), biomeGetter.getOrThrow(BiomeTags.HAS_IGLOO)), List.of(), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(RocksBiomeModifiers.getKey("snowy_geyser"))}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
    }

    public static ResourceKey<PlacedFeature> getKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Rocks.modLoc(name));
    }

    public static ResourceKey<BiomeModifier> getModifierKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Rocks.modLoc(name));
    }
}

