/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.world.configured_feature;

import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.block.Rock;
import eu.midnightdust.motschen.rocks.blockstates.RockVariation;
import eu.midnightdust.motschen.rocks.util.RegistryUtil;
import eu.midnightdust.motschen.rocks.util.RockType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class RockFeatures {
    private static final Map<RockType, ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = new HashMap();
    public static ConfiguredFeature<?, ?> ROCK_MIX_FEATURE = new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(WeightedList.builder().add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.GRANITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.TINY))), 10).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.GRANITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.SMALL))), 7).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.GRANITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.MEDIUM))), 5).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.GRANITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.LARGE))), 1).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.DIORITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.TINY))), 10).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.DIORITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.SMALL))), 7).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.DIORITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.MEDIUM))), 5).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.DIORITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.LARGE))), 1).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.ANDESITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.TINY))), 10).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.ANDESITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.SMALL))), 7).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.ANDESITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.MEDIUM))), 5).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.ANDESITE).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.LARGE))), 1).build())));
    public static ConfiguredFeature<?, ?> NETHER_GRAVEL_ROCK_FEATURE = new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(WeightedList.builder().add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.GRAVEL).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.TINY))), 10).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.GRAVEL).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.SMALL))), 7).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.GRAVEL).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.MEDIUM))), 5).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)RockType.GRAVEL).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.LARGE))), 1).build())));
    public static PlacedFeature ROCK_MIX_PLACED_FEATURE = new PlacedFeature(Holder.direct(ROCK_MIX_FEATURE), RockFeatures.getModifiersInvertedGroundCheck(3, 1, Blocks.ICE, Blocks.PACKED_ICE, Blocks.SAND, Blocks.RED_SAND, Blocks.END_STONE));
    public static PlacedFeature NETHER_GRAVEL_ROCK_PLACED_FEATURE = new PlacedFeature(Holder.direct(NETHER_GRAVEL_ROCK_FEATURE), RockFeatures.getNetherModifiers(30, 1, Blocks.GRAVEL));

    public static List<PlacementModifier> getModifiers(int count, int rarity, Block ... groundBlocks) {
        return List.of(CountPlacement.of((int)count), RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])groundBlocks))));
    }

    public static List<PlacementModifier> getModifiersInvertedGroundCheck(int count, int rarity, Block ... groundBlocks) {
        return List.of(CountPlacement.of((int)count), RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])groundBlocks)))));
    }

    public static List<PlacementModifier> getNetherModifiers(int count, int rarity, Block ... groundBlocks) {
        return List.of(CountPlacement.of((int)count), RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])groundBlocks))));
    }

    public static List<PlacementModifier> getEndModifiers(int count, int rarity, Block ... groundBlocks) {
        return List.of(CountPlacement.of((int)count), RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])groundBlocks))));
    }

    public static void init() {
        for (RockType type : RockType.values()) {
            ConfiguredFeature ROCK_FEATURE = new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(WeightedList.builder().add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)type).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.TINY))), 10).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)type).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.SMALL))), 7).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)type).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.MEDIUM))), 5).add((Object)((BlockState)((Rock)((Object)Rocks.rocksByType.get((Object)type).get())).defaultBlockState().setValue(Rocks.ROCK_VARIATION, (Comparable)((Object)RockVariation.LARGE))), 1).build())));
            CONFIGURED_FEATURES.put(type, ROCK_FEATURE);
        }
    }

    public static void configuredBootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        RockFeatures.init();
        RegistryUtil.register(context, "rock_mix", ROCK_MIX_FEATURE);
        RegistryUtil.register(context, "nether_gravel_rock", NETHER_GRAVEL_ROCK_FEATURE);
        for (RockType type : RockType.values()) {
            RegistryUtil.register(context, type.getName(), CONFIGURED_FEATURES.get((Object)type));
        }
    }

    public static void placedBootstrap(BootstrapContext<PlacedFeature> context) {
        RegistryUtil.register(context, "rock_mix", ROCK_MIX_PLACED_FEATURE);
        RegistryUtil.register(context, "nether_gravel_rock", NETHER_GRAVEL_ROCK_PLACED_FEATURE);
        for (RockType type : RockType.values()) {
            PlacedFeature ROCK_PLACED_FEATURE = switch (type) {
                case RockType.STONE -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), RockFeatures.getModifiersInvertedGroundCheck(3, 1, Blocks.ICE, Blocks.PACKED_ICE, Blocks.SAND, Blocks.RED_SAND, Blocks.END_STONE));
                case RockType.SANDSTONE -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), RockFeatures.getModifiers(3, 1, Blocks.SAND, Blocks.SANDSTONE));
                case RockType.RED_SANDSTONE -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), RockFeatures.getModifiers(7, 1, Blocks.RED_SAND, Blocks.RED_SANDSTONE));
                case RockType.ICE -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), RockFeatures.getModifiers(3, 5, Blocks.ICE, Blocks.PACKED_ICE, Blocks.BLUE_ICE));
                case RockType.NETHERRACK -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), RockFeatures.getNetherModifiers(90, 1, Blocks.NETHERRACK, Blocks.WARPED_NYLIUM, Blocks.CRIMSON_NYLIUM));
                case RockType.SOUL_SOIL -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), RockFeatures.getNetherModifiers(60, 1, Blocks.SOUL_SOIL, Blocks.SOUL_SAND));
                case RockType.END_STONE -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), RockFeatures.getEndModifiers(3, 1, type.getStoneBlock()));
                default -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), RockFeatures.getModifiers(3, 1, type.getStoneBlock()));
            };
            RegistryUtil.register(context, type.getName(), ROCK_PLACED_FEATURE);
        }
    }
}

