/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.world.configured_feature;

import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.block.Stick;
import eu.midnightdust.motschen.rocks.blockstates.StickVariation;
import eu.midnightdust.motschen.rocks.util.RegistryUtil;
import eu.midnightdust.motschen.rocks.util.StickType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class StickFeatures {
    private static final Map<StickType, ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = new HashMap();

    public static List<PlacementModifier> getModifiers(int count, int rarity, Block ... groundBlocks) {
        return List.of(CountPlacement.of((int)count), RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])groundBlocks))));
    }

    public static List<PlacementModifier> getNetherModifiers(int count, int rarity, Block ... groundBlocks) {
        return List.of(CountPlacement.of((int)count), RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])groundBlocks))));
    }

    public static void init() {
        for (StickType type : StickType.values()) {
            ConfiguredFeature STICK_FEATURE = new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(WeightedList.builder().add((Object)((BlockState)((Stick)((Object)Rocks.sticksByType.get((Object)type).get())).defaultBlockState().setValue(Rocks.STICK_VARIATION, (Comparable)((Object)StickVariation.SMALL))), 7).add((Object)((BlockState)((Stick)((Object)Rocks.sticksByType.get((Object)type).get())).defaultBlockState().setValue(Rocks.STICK_VARIATION, (Comparable)((Object)StickVariation.MEDIUM))), 5).add((Object)((BlockState)((Stick)((Object)Rocks.sticksByType.get((Object)type).get())).defaultBlockState().setValue(Rocks.STICK_VARIATION, (Comparable)((Object)StickVariation.LARGE))), 1).build())));
            CONFIGURED_FEATURES.put(type, STICK_FEATURE);
        }
    }

    public static void configuredBootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        StickFeatures.init();
        for (StickType type : StickType.values()) {
            RegistryUtil.register(context, type.getName() + "_stick", CONFIGURED_FEATURES.get((Object)type));
        }
    }

    public static void placedBootstrap(BootstrapContext<PlacedFeature> context) {
        for (StickType type : StickType.values()) {
            PlacedFeature STICK_PLACED_FEATURE = switch (type) {
                case StickType.CRIMSON -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), StickFeatures.getNetherModifiers(90, 1, Blocks.CRIMSON_NYLIUM));
                case StickType.WARPED -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), StickFeatures.getNetherModifiers(90, 1, Blocks.WARPED_NYLIUM));
                case StickType.PALE_OAK -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), StickFeatures.getModifiers(20, 1, Blocks.GRASS_BLOCK, Blocks.PALE_MOSS_BLOCK));
                case StickType.SPRUCE -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), StickFeatures.getModifiers(3, 1, Blocks.GRASS_BLOCK, Blocks.SNOW_BLOCK, Blocks.PODZOL));
                default -> new PlacedFeature(Holder.direct(CONFIGURED_FEATURES.get((Object)type)), StickFeatures.getModifiers(3, 1, Blocks.GRASS_BLOCK, Blocks.MUD, Blocks.PODZOL));
            };
            RegistryUtil.register(context, type.getName() + "_stick", STICK_PLACED_FEATURE);
        }
    }
}

