/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.blockstates.StarfishVariation;
import eu.midnightdust.motschen.rocks.registry.RocksRegistry;
import eu.midnightdust.motschen.rocks.world.configured_feature.MiscFeatures;
import eu.midnightdust.motschen.rocks.world.configured_feature.NetherFeatures;
import eu.midnightdust.motschen.rocks.world.configured_feature.RockFeatures;
import eu.midnightdust.motschen.rocks.world.configured_feature.StickFeatures;
import eu.midnightdust.motschen.rocks.world.modifier.AddFeaturesBlacklistBiomeModifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RocksDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_236039_(event.includeServer(), (DataProvider)new Loots(generator));
            generator.m_236039_(event.includeServer(), (DataProvider)new Recipes(generator));
            generator.m_236039_(event.includeServer(), (DataProvider)new RocksBlockTags(generator, helper));
            generator.m_236039_(event.includeServer(), (DataProvider)new RocksBiomeTags(generator, helper));
            generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)helper, (String)"rocks", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, RocksDatagen.getConfiguredFeatures((RegistryOps<JsonElement>)ops)));
            generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)helper, (String)"rocks", (RegistryOps)ops, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, RocksDatagen.getBiomeModifiers((RegistryOps<JsonElement>)ops)));
        }
    }

    public static Map<ResourceLocation, PlacedFeature> getConfiguredFeatures(RegistryOps<JsonElement> ops) {
        HashMap map = Maps.newHashMap();
        ArrayList<PlacementModifier> miscModifiers = new ArrayList<PlacementModifier>(MiscFeatures.placementModifiers);
        miscModifiers.add((PlacementModifier)CountPlacement.m_191628_((int)1));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)MiscFeatures.SEASHELL_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), miscModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)MiscFeatures.STARFISH_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), miscModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)MiscFeatures.UNDERWATER_STARFISH_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), miscModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)MiscFeatures.UNDERWATER_SEASHELL_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), miscModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)MiscFeatures.SNOWY_GEYSER_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), miscModifiers));
        List<BlockPredicateFilter> geyserModifiers = List.of(CountPlacement.m_191628_((int)15), RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_(), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_224771_((Vec3i)new Vec3i(0, -1, 0), (List)ImmutableList.of((Object)Blocks.f_50134_)))));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)NetherFeatures.NETHERRACK_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), NetherFeatures.getNetherModifiers(90, 1, Blocks.f_50134_, Blocks.f_50690_, Blocks.f_50699_)));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)NetherFeatures.SOUL_SOIL_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), NetherFeatures.getNetherModifiers(60, 1, Blocks.f_50136_, Blocks.f_50135_)));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)NetherFeatures.NETHER_GRAVEL_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), NetherFeatures.getNetherModifiers(30, 1, Blocks.f_49994_)));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)NetherFeatures.NETHER_GEYSER_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), geyserModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)NetherFeatures.WARPED_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), StickFeatures.getNetherModifiers(90, 1, Blocks.f_50690_)));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)NetherFeatures.CRIMSON_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), StickFeatures.getNetherModifiers(90, 1, Blocks.f_50699_)));
        ArrayList<PlacementModifier> rockModifiers = new ArrayList<PlacementModifier>(RockFeatures.rockModifiers);
        rockModifiers.add((PlacementModifier)CountPlacement.m_191628_((int)3));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)RockFeatures.ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), rockModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)RockFeatures.GRANITE_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), rockModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)RockFeatures.DIORITE_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), rockModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)RockFeatures.ANDESITE_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), rockModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)RockFeatures.SAND_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), rockModifiers));
        ArrayList<PlacementModifier> redSandModifier = new ArrayList<PlacementModifier>(RockFeatures.rockModifiers);
        redSandModifier.add((PlacementModifier)CountPlacement.m_191628_((int)7));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)RockFeatures.RED_SAND_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), redSandModifier));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)RockFeatures.END_STONE_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), rockModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)RockFeatures.GRAVEL_ROCK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), rockModifiers));
        ArrayList<PlacementModifier> stickModifiers = new ArrayList<PlacementModifier>(StickFeatures.stickModifiers);
        stickModifiers.add((PlacementModifier)CountPlacement.m_191628_((int)3));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)StickFeatures.OAK_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), stickModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)StickFeatures.SPRUCE_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), stickModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)StickFeatures.PINECONE_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), stickModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)StickFeatures.BIRCH_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), stickModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)StickFeatures.ACACIA_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), stickModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)StickFeatures.JUNGLE_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), stickModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)StickFeatures.DARK_OAK_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), stickModifiers));
        map.putAll(RocksDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)StickFeatures.MANGROVE_STICK_FEATURE.m_203543_().get()).m_195975_(Registry.f_122881_).get(), stickModifiers));
        return map;
    }

    private static Map<ResourceLocation, PlacedFeature> generateConfiguredFeature(RegistryOps<JsonElement> ops, ResourceKey<ConfiguredFeature<?, ?>> featureKey, List<PlacementModifier> modifiers) {
        Holder featureKeyHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(featureKey);
        PlacedFeature feature = new PlacedFeature(featureKeyHolder, modifiers);
        return Map.of(featureKey.m_135782_(), feature);
    }

    public static Map<ResourceLocation, BiomeModifier> getBiomeModifiers(RegistryOps<JsonElement> ops) {
        HashMap map = Maps.newHashMap();
        List<TagKey<Biome>> overworld = List.of(BiomeTags.f_215817_);
        List<TagKey<Biome>> rockBlacklist = List.of(BiomeTags.f_207612_, BiomeTags.f_215818_, BiomeTags.f_207615_, Tags.Biomes.IS_SANDY, BiomeTags.f_207607_, BiomeTags.f_207603_);
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "rock"), overworld, rockBlacklist, GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "granite_rock"), overworld, rockBlacklist, GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "diorite_rock"), overworld, rockBlacklist, GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "andesite_rock"), overworld, rockBlacklist, GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "sand_rock"), List.of(BiomeTags.f_207604_, Tags.Biomes.IS_SANDY, BiomeTags.f_207607_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "red_sand_rock"), List.of(Tags.Biomes.IS_SANDY, BiomeTags.f_207607_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "endstone_rock"), List.of(BiomeTags.f_215818_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "oak_stick"), List.of(BiomeTags.f_207611_, Tags.Biomes.IS_PLAINS, Tags.Biomes.IS_SWAMP), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "birch_stick"), List.of(BiomeTags.f_207611_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "pinecone"), List.of(BiomeTags.f_207609_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "spruce_stick"), List.of(BiomeTags.f_207609_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "acacia_stick"), List.of(BiomeTags.f_215816_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "jungle_stick"), List.of(BiomeTags.f_207610_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "dark_oak_stick"), List.of(RocksBiomeTags.IS_DARK_FOREST), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "mangrove_stick"), List.of(RocksBiomeTags.IS_MANGROVE_SWAMP), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "seashell"), List.of(BiomeTags.f_207604_), List.of(Tags.Biomes.IS_SNOWY), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "starfish"), List.of(BiomeTags.f_207604_), List.of(Tags.Biomes.IS_SNOWY), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "underwater_seashell"), List.of(BiomeTags.f_207603_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "underwater_starfish"), List.of(BiomeTags.f_207603_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "snowy_geyser"), List.of(Tags.Biomes.IS_SNOWY), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "gravel_rock"), List.of(BiomeTags.f_207612_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "gravel_rock"), overworld, List.of(BiomeTags.f_215818_, BiomeTags.f_207612_), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "netherrack_rock"), List.of(BiomeTags.f_207612_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "soul_soil_rock"), List.of(BiomeTags.f_207612_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "nether_gravel_rock"), List.of(BiomeTags.f_207612_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "nether_geyser"), List.of(BiomeTags.f_207612_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "warped_stick"), List.of(BiomeTags.f_207612_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        map.putAll(RocksDatagen.generateBiomeModifier(ops, new ResourceLocation("rocks", "crimson_stick"), List.of(BiomeTags.f_207612_), List.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        return map;
    }

    private static Map<ResourceLocation, BiomeModifier> generateBiomeModifier(RegistryOps<JsonElement> ops, ResourceLocation location, @NotNull List<TagKey<Biome>> tags, @Nullable List<TagKey<Biome>> blacklistTags, GenerationStep.Decoration decorationType) {
        List<HolderSet<Biome>> tagHolders = tags.stream().map(tag -> new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), tag)).collect(Collectors.toList());
        List<HolderSet<Biome>> blacklistTagHolders = blacklistTags.isEmpty() ? List.of() : blacklistTags.stream().map(tag -> new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), tag)).collect(Collectors.toList());
        AddFeaturesBlacklistBiomeModifier addFeature = new AddFeaturesBlacklistBiomeModifier(tagHolders, blacklistTagHolders, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)location))}), decorationType);
        return Map.of(location, addFeature);
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(GeOreBlockTables::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        public static class GeOreBlockTables
        extends BlockLoot {
            private static final float[] NAUTILOUS_CHANCE = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

            protected void addTables() {
                this.m_124147_((Block)RocksRegistry.ACACIA_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.BIRCH_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.CRIMSON_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.DARK_OAK_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.JUNGLE_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.OAK_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.MANGROVE_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.SPRUCE_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.WARPED_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_124147_((Block)RocksRegistry.PINECONE.get(), (ItemLike)Items.f_42800_);
                this.m_124165_((Block)RocksRegistry.SEASHELL.get(), GeOreBlockTables.createSeashellDrop((Block)RocksRegistry.SEASHELL.get()));
                this.m_124165_((Block)RocksRegistry.STARFISH.get(), GeOreBlockTables.createStarfishDrop((Block)RocksRegistry.STARFISH.get()));
                this.m_124147_((Block)RocksRegistry.ANDESITE_ROCK.get(), (ItemLike)RocksRegistry.ANDESITE_SPLITTER.get());
                this.m_124147_((Block)RocksRegistry.DIORITE_ROCK.get(), (ItemLike)RocksRegistry.DIORITE_SPLITTER.get());
                this.m_124147_((Block)RocksRegistry.END_STONE_ROCK.get(), (ItemLike)RocksRegistry.END_STONE_SPLITTER.get());
                this.m_124147_((Block)RocksRegistry.GRANITE_ROCK.get(), (ItemLike)RocksRegistry.GRANITE_SPLITTER.get());
                this.m_124147_((Block)RocksRegistry.NETHERRACK_ROCK.get(), (ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get());
                this.m_124147_((Block)RocksRegistry.RED_SAND_ROCK.get(), (ItemLike)RocksRegistry.RED_SAND_ROCK_ITEM.get());
                this.m_124147_((Block)RocksRegistry.ROCK.get(), (ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get());
                this.m_124147_((Block)RocksRegistry.SAND_ROCK.get(), (ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get());
                this.m_124147_((Block)RocksRegistry.SOUL_SOIL_ROCK.get(), (ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get());
                this.m_124147_((Block)RocksRegistry.GRAVEL_ROCK.get(), (ItemLike)Items.f_42484_);
                this.m_124165_((Block)RocksRegistry.GEYSER.get(), GeOreBlockTables.m_124125_());
                this.m_124165_((Block)RocksRegistry.NETHER_GEYSER.get(), GeOreBlockTables.m_124125_());
            }

            protected static LootTable.Builder createSeashellDrop(Block block) {
                return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)GeOreBlockTables.m_236221_((ItemLike)block, (FunctionUserBuilder)((FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42715_).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NAUTILOUS_CHANCE))))));
            }

            protected static LootTable.Builder createStarfishDrop(Block starFish) {
                return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)GeOreBlockTables.m_236221_((ItemLike)starFish, (FunctionUserBuilder)((FunctionUserBuilder)LootItem.m_79579_((ItemLike)starFish).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)GeOreBlockTables.getStarfishTag("red"))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)starFish).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(Rocks.STARFISH_VARIATION, (Comparable)((Object)StarfishVariation.RED))))))).m_79076_((LootPoolEntryContainer.Builder)GeOreBlockTables.m_236221_((ItemLike)starFish, (FunctionUserBuilder)((FunctionUserBuilder)LootItem.m_79579_((ItemLike)starFish).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)GeOreBlockTables.getStarfishTag("pink"))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)starFish).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(Rocks.STARFISH_VARIATION, (Comparable)((Object)StarfishVariation.PINK))))))).m_79076_((LootPoolEntryContainer.Builder)GeOreBlockTables.m_236221_((ItemLike)starFish, (FunctionUserBuilder)((FunctionUserBuilder)LootItem.m_79579_((ItemLike)starFish).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)GeOreBlockTables.getStarfishTag("orange"))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)starFish).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(Rocks.STARFISH_VARIATION, (Comparable)((Object)StarfishVariation.ORANGE))))))));
            }

            private static CompoundTag getStarfishTag(String color) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("variation", color);
                return tag;
            }

            protected Iterable<Block> getKnownBlocks() {
                return RocksRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    public static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator generator) {
            super(generator);
        }

        protected void m_176531_(Consumer<FinishedRecipe> recipeConsumer) {
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50334_).m_126209_((ItemLike)RocksRegistry.ANDESITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.ANDESITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.ANDESITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.ANDESITE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "andesite_from_splitter"));
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50652_).m_126209_((ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "cobblestone_from_splitter"));
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50228_).m_126209_((ItemLike)RocksRegistry.DIORITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.DIORITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.DIORITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.DIORITE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "diorite_from_splitter"));
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50259_).m_126209_((ItemLike)RocksRegistry.END_STONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.END_STONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.END_STONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.END_STONE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "end_stone_from_splitter"));
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50122_).m_126209_((ItemLike)RocksRegistry.GRANITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.GRANITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.GRANITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.GRANITE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "granite_from_splitter"));
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50134_).m_126209_((ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "netherrack_from_splitter"));
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50394_).m_126209_((ItemLike)RocksRegistry.RED_SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.RED_SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.RED_SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.RED_SANDSTONE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "red_sandstone_from_splitter"));
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50062_).m_126209_((ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "sandstone_from_splitter"));
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50136_).m_126209_((ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "soul_soil_from_splitter"));
        }

        protected void m_236367_(CachedOutput output, JsonObject jsonObject, Path path) {
        }
    }

    public static class RocksBlockTags
    extends BlockTagsProvider {
        public RocksBlockTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "rocks", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(BlockTags.f_144282_).m_126584_((Object[])new Block[]{(Block)RocksRegistry.GEYSER.get(), (Block)RocksRegistry.NETHER_GEYSER.get()});
        }
    }

    public static class RocksBiomeTags
    extends BiomeTagsProvider {
        public static final TagKey<Biome> IS_DARK_FOREST = RocksBiomeTags.create(new ResourceLocation("forge", "is_dark_forest"));
        public static final TagKey<Biome> IS_MANGROVE_SWAMP = RocksBiomeTags.create(new ResourceLocation("forge", "is_mangrove_swamp"));

        public RocksBiomeTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "rocks", existingFileHelper);
        }

        private static TagKey<Biome> create(ResourceLocation location) {
            return TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)location);
        }

        protected void m_6577_() {
            this.m_206424_(IS_DARK_FOREST).m_211101_(new ResourceKey[]{Biomes.f_48151_});
            this.m_206424_(IS_MANGROVE_SWAMP).m_211101_(new ResourceKey[]{Biomes.f_220595_});
        }
    }
}

