/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger;

import com.mojang.logging.LogUtils;
import com.wardanger.DangerousConfig;
import com.wardanger.GearManager;
import com.wardanger.IllagerWeaponManager;
import com.wardanger.MobDeathHandler;
import com.wardanger.SkeletonWeaponManager;
import com.wardanger.SpiderSpeedEnhancement;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.slf4j.Logger;

@Mod(value="dangerous")
public class Dangerous {
    public static final String MODID = "dangerous";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String HEALTH_MODIFIED_TAG = "dangerous_hp_modified";
    private float healthMultiplier = 1.0f;
    private double maxHealthMultiplier;
    private double healthMultiplierIncrement;
    private int daysPerIncrement;
    private static long lastCheckedDay = 0L;
    private boolean finalFormReached = false;

    public Dangerous(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::onConfigReload);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DangerousConfig.COMMON_SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new SkeletonWeaponManager());
        NeoForge.EVENT_BUS.register((Object)new IllagerWeaponManager());
        NeoForge.EVENT_BUS.register((Object)new MobDeathHandler());
        NeoForge.EVENT_BUS.register((Object)new SpiderSpeedEnhancement());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Dangerous Mod setup complete.");
    }

    public void onConfigLoad(ModConfigEvent.Loading event) {
        this.loadConfigValues();
    }

    public void onConfigReload(ModConfigEvent.Reloading event) {
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        this.healthMultiplier = ((Double)DangerousConfig.CONFIG.baseHealthMultiplier.get()).floatValue();
        this.maxHealthMultiplier = (Double)DangerousConfig.CONFIG.maxHealthMultiplier.get();
        this.healthMultiplierIncrement = (Double)DangerousConfig.CONFIG.healthMultiplierIncrement.get();
        this.daysPerIncrement = (Integer)DangerousConfig.CONFIG.daysPerIncrement.get();
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            final ServerPlayer player = (ServerPlayer)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                final ServerLevel serverWorld = (ServerLevel)entity;
                boolean isFirstJoin = player.getPersistentData().getBoolean("dangerous_first_join");
                if (!isFirstJoin) {
                    player.getPersistentData().putBoolean("dangerous_first_join", true);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            Dangerous.this.sendWorldInfoToPlayer(player, serverWorld);
                        }
                    }, 2500L);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getPersistentData().putBoolean("dangerous_first_join", false);
        }
    }

    private void sendWorldInfoToPlayer(ServerPlayer player, ServerLevel world) {
        long currentDay = world.getDayTime() / 24000L;
        double healthMultiplier = ((Double)DangerousConfig.CONFIG.baseHealthMultiplier.get()).floatValue();
        int daysPerIncrement = (Integer)DangerousConfig.CONFIG.daysPerIncrement.get();
        long daysUntilNextIncrement = (long)daysPerIncrement - currentDay % (long)daysPerIncrement;
        MutableComponent dangerousMessage = Component.literal((String)"            === Dangerous Mod Stats ===").withStyle(style -> style.withBold(Boolean.valueOf(true)).withColor(0xFF5555));
        MutableComponent emptyLine = Component.literal((String)" ");
        MutableComponent combinedMessage = Component.literal((String)"Day: ").append((Component)Component.literal((String)("" + currentDay)).withStyle(style -> style.withColor(65280))).append((Component)Component.literal((String)" | Mob HP Multiplier: ")).append((Component)Component.literal((String)("" + healthMultiplier)).withStyle(style -> style.withColor(0xFFFF55))).append((Component)Component.literal((String)" | Days Until Next Increment: ")).append((Component)Component.literal((String)("" + daysUntilNextIncrement)).withStyle(style -> style.withColor(0x55FFFF)));
        if (((Boolean)DangerousConfig.CONFIG.enableChatAnnouncements.get()).booleanValue()) {
            player.sendSystemMessage((Component)dangerousMessage);
            player.sendSystemMessage((Component)emptyLine);
            player.sendSystemMessage((Component)combinedMessage);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Dangerous Mod is ready and loaded!");
        this.loadConfigValues();
        ServerLevel overworld = event.getServer().getLevel(ServerLevel.OVERWORLD);
        if (overworld != null) {
            long currentDay = overworld.getDayTime() / 24000L;
            this.initializeHealthMultiplier(currentDay);
        }
    }

    private void initializeHealthMultiplier(long currentDay) {
        long daysPassed = currentDay / (long)this.daysPerIncrement;
        int i = 0;
        while ((long)i < daysPassed) {
            if ((double)this.healthMultiplier < this.maxHealthMultiplier) {
                this.healthMultiplier += (float)this.healthMultiplierIncrement;
                if ((double)this.healthMultiplier > this.maxHealthMultiplier) {
                    this.healthMultiplier = (float)this.maxHealthMultiplier;
                    this.finalFormReached = true;
                    break;
                }
            }
            ++i;
        }
        lastCheckedDay = currentDay;
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Post event) {
        ServerLevel serverWorld;
        Level level = event.getLevel();
        if (level instanceof ServerLevel && !(serverWorld = (ServerLevel)level).isClientSide()) {
            long daysPassed;
            ServerLevelData worldData = (ServerLevelData)serverWorld.getServer().getWorldData();
            long currentDay = worldData.getDayTime() / 24000L;
            if (lastCheckedDay == 0L) {
                lastCheckedDay = currentDay;
            }
            if ((daysPassed = currentDay - lastCheckedDay) >= (long)this.daysPerIncrement) {
                long increments = daysPassed / (long)this.daysPerIncrement;
                for (long i = 0L; i < increments; ++i) {
                    this.increaseHealthMultiplier(serverWorld);
                }
                lastCheckedDay += increments * (long)this.daysPerIncrement;
            }
        }
    }

    private void increaseHealthMultiplier(ServerLevel world) {
        if ((double)this.healthMultiplier < this.maxHealthMultiplier) {
            this.healthMultiplier += (float)this.healthMultiplierIncrement;
            if ((double)this.healthMultiplier > this.maxHealthMultiplier) {
                this.healthMultiplier = (float)this.maxHealthMultiplier;
            }
            if (((Boolean)DangerousConfig.CONFIG.enableChatAnnouncements.get()).booleanValue()) {
                MutableComponent message = Component.literal((String)"The enemies become more DANGEROUS!").withStyle(style -> style.withBold(Boolean.valueOf(true)).withColor(0xFF5555));
                world.getPlayers(player -> true).forEach(arg_0 -> Dangerous.lambda$increaseHealthMultiplier$6((Component)message, arg_0));
                if ((double)this.healthMultiplier == this.maxHealthMultiplier && !this.finalFormReached) {
                    this.finalFormReached = true;
                    MutableComponent finalMessage = Component.literal((String)"The enemies have reached their FINAL FORM!").withStyle(style -> style.withBold(Boolean.valueOf(true)).withColor(0xFFAA00));
                    world.getPlayers(player -> true).forEach(arg_0 -> Dangerous.lambda$increaseHealthMultiplier$9((Component)finalMessage, arg_0));
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            Mob mob;
            ServerLevel serverWorld = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof Mob && (mob = (Mob)level) instanceof Monster) {
                Difficulty difficulty = serverWorld.getDifficulty();
                this.adjustHealthBasedOnDifficulty((LivingEntity)mob, difficulty, this.healthMultiplier);
                GearManager.equipMobBasedOnDifficulty(mob, serverWorld);
            }
        }
    }

    private void adjustHealthBasedOnDifficulty(LivingEntity entity, Difficulty difficulty, float multiplier) {
        CompoundTag entityData = entity.getPersistentData();
        if (!entityData.getBoolean(HEALTH_MODIFIED_TAG)) {
            float originalHealth = entity.getMaxHealth();
            float newHealth = switch (difficulty) {
                case Difficulty.EASY, Difficulty.NORMAL, Difficulty.HARD -> originalHealth * multiplier;
                default -> originalHealth;
            };
            Objects.requireNonNull(entity.getAttribute(Attributes.MAX_HEALTH)).setBaseValue((double)newHealth);
            entity.setHealth(newHealth);
            entityData.putBoolean(HEALTH_MODIFIED_TAG, true);
        }
    }

    private static /* synthetic */ void lambda$increaseHealthMultiplier$9(Component finalMessage, ServerPlayer player) {
        player.sendSystemMessage(finalMessage);
    }

    private static /* synthetic */ void lambda$increaseHealthMultiplier$6(Component message, ServerPlayer player) {
        player.sendSystemMessage(message);
    }

    @EventBusSubscriber(modid="dangerous", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Dangerous Mod client setup complete.");
        }
    }
}

