/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger;

import com.mojang.logging.LogUtils;
import com.wardanger.DangerousConfig;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public class GearManager {
    private static final Random RANDOM = new Random();
    private static final String EQUIPMENT_MODIFIED_TAG = "dangerous_equipment_modified";
    private static final int SURFACE_Y_THRESHOLD = 64;
    private static final int CAVE_Y_THRESHOLD = 0;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double BRUTE_NETHERITE_AXE_CHANCE = 0.05;
    private static final double BRUTE_DIAMOND_AXE_CHANCE = 0.15;
    private static final ResourceLocation OMINOUS_BANNER_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ominous_banner");

    public static void equipMobBasedOnDifficulty(Mob mob, ServerLevel world) {
        Difficulty difficulty = world.getDifficulty();
        CompoundTag entityData = mob.getPersistentData();
        if (entityData.getBoolean(EQUIPMENT_MODIFIED_TAG)) {
            return;
        }
        ResourceLocation zombieType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"zombie");
        ResourceLocation skeletonType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"skeleton");
        ResourceLocation creeperType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"creeper");
        ResourceLocation zombifiedPiglinType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"zombified_piglin");
        ResourceLocation piglinType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"piglin");
        ResourceLocation piglinBruteType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"piglin_brute");
        ResourceLocation pillagerType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"pillager");
        ResourceLocation vindicatorType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"vindicator");
        ResourceLocation evokerType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"evoker");
        ResourceLocation illusionerType = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"illusioner");
        ResourceLocation typeKey = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType());
        if (typeKey.equals((Object)zombieType)) {
            GearManager.giveZombieWeapon(mob, world);
            if (mob.getY() >= 64.0) {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.surfaceArmor.get(), (List)DangerousConfig.CONFIG.surfaceWeapons.get(), (List)DangerousConfig.CONFIG.surfaceArmorSets.get(), world);
            } else if (mob.getY() >= 0.0) {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.caveArmor.get(), (List)DangerousConfig.CONFIG.caveWeapons.get(), (List)DangerousConfig.CONFIG.caveArmorSets.get(), world);
            } else {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.deepCaveArmor.get(), (List)DangerousConfig.CONFIG.deepCaveWeapons.get(), (List)DangerousConfig.CONFIG.deepCaveArmorSets.get(), world);
            }
        } else if (typeKey.equals((Object)skeletonType)) {
            GearManager.giveSkeletonWeapon(mob, world);
            if (mob.getY() >= 64.0) {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.surfaceArmor.get(), (List)DangerousConfig.CONFIG.surfaceWeapons.get(), (List)DangerousConfig.CONFIG.surfaceArmorSets.get(), world);
            } else if (mob.getY() >= 0.0) {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.caveArmor.get(), (List)DangerousConfig.CONFIG.caveWeapons.get(), (List)DangerousConfig.CONFIG.caveArmorSets.get(), world);
            } else {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.deepCaveArmor.get(), (List)DangerousConfig.CONFIG.deepCaveWeapons.get(), (List)DangerousConfig.CONFIG.deepCaveArmorSets.get(), world);
            }
        } else if (typeKey.equals((Object)creeperType)) {
            GearManager.increaseCreeperSpeed((Creeper)mob);
        } else if (typeKey.equals((Object)zombifiedPiglinType)) {
            GearManager.giveGoldArmorPiecesIfChance(mob, difficulty, world);
        } else if (typeKey.equals((Object)piglinType)) {
            GearManager.giveGoldArmorPiecesIfChance(mob, difficulty, world);
        } else if (typeKey.equals((Object)piglinBruteType)) {
            GearManager.giveGoldArmorPiecesIfChance(mob, difficulty, world);
            GearManager.givePiglinBruteWeapon(mob, world);
        } else if (typeKey.equals((Object)pillagerType) || typeKey.equals((Object)vindicatorType) || typeKey.equals((Object)evokerType) || typeKey.equals((Object)illusionerType)) {
            GearManager.giveIllagerIronArmorPiecesIfChance(mob, difficulty, world);
            if (typeKey.equals((Object)pillagerType)) {
                GearManager.givePillagerMeleeIfChance(mob, world);
            } else if (typeKey.equals((Object)vindicatorType)) {
                GearManager.upgradeVindicatorWeaponIfLucky(mob, world);
            } else if (typeKey.equals((Object)evokerType)) {
                GearManager.giveIllagerIronArmorPiecesIfChance(mob, difficulty, world);
            }
        }
        entityData.putBoolean(EQUIPMENT_MODIFIED_TAG, true);
    }

    private static boolean isOminousBanner(ItemStack s) {
        if (s.isEmpty()) {
            return false;
        }
        return OMINOUS_BANNER_ID.equals((Object)BuiltInRegistries.ITEM.getKey((Object)s.getItem()));
    }

    private static void giveIllagerIronArmorPiecesIfChance(Mob mob, Difficulty difficulty, ServerLevel world) {
        double chance = GearManager.getGearChanceForDifficulty(difficulty);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.HEAD, GearManager.getItemByName("minecraft:iron_helmet"), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.CHEST, GearManager.getItemByName("minecraft:iron_chestplate"), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.LEGS, GearManager.getItemByName("minecraft:iron_leggings"), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.FEET, GearManager.getItemByName("minecraft:iron_boots"), chance, world);
    }

    private static void givePillagerMeleeIfChance(Mob mob, ServerLevel world) {
        double weaponChance = (Double)DangerousConfig.CONFIG.weaponChance.get();
        if (RANDOM.nextDouble() >= weaponChance) {
            return;
        }
        ItemStack off = mob.getOffhandItem();
        if (GearManager.isOminousBanner(off)) {
            return;
        }
        String[] candidates = new String[]{"minecraft:iron_sword", "minecraft:iron_axe", "minecraft:diamond_sword", "minecraft:diamond_axe"};
        String pick = candidates[RANDOM.nextInt(candidates.length)];
        ItemStack melee = GearManager.getItemByName(pick);
        if (melee.isEmpty()) {
            return;
        }
        GearManager.enchantItem(melee, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get(), world);
        GearManager.giveNBT(melee);
        if (mob.getOffhandItem().isEmpty()) {
            mob.setItemSlot(EquipmentSlot.OFFHAND, melee);
        } else if (mob.getMainHandItem().isEmpty()) {
            mob.setItemSlot(EquipmentSlot.MAINHAND, melee);
        }
    }

    private static void upgradeVindicatorWeaponIfLucky(Mob mob, ServerLevel world) {
        boolean meleeLike;
        double chance = (Double)DangerousConfig.CONFIG.weaponChance.get() * 0.7;
        if (RANDOM.nextDouble() >= chance) {
            return;
        }
        ItemStack main = mob.getMainHandItem();
        if (main.isEmpty()) {
            return;
        }
        ResourceLocation cur = BuiltInRegistries.ITEM.getKey((Object)main.getItem());
        boolean bl = meleeLike = cur.getPath().contains("sword") || cur.getPath().contains("axe");
        if (!meleeLike) {
            return;
        }
        String[] upgrades = new String[]{"minecraft:diamond_axe", "minecraft:diamond_sword"};
        String pick = upgrades[RANDOM.nextInt(upgrades.length)];
        ItemStack upgraded = GearManager.getItemByName(pick);
        if (upgraded.isEmpty()) {
            return;
        }
        GearManager.enchantItem(upgraded, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get(), world);
        GearManager.giveNBT(upgraded);
        mob.setItemSlot(EquipmentSlot.MAINHAND, upgraded);
    }

    private static void giveGoldArmorPiecesIfChance(Mob mob, Difficulty difficulty, ServerLevel world) {
        double chance = GearManager.getGearChanceForDifficulty(difficulty);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.HEAD, GearManager.getItemByName("minecraft:golden_helmet"), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.CHEST, GearManager.getItemByName("minecraft:golden_chestplate"), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.LEGS, GearManager.getItemByName("minecraft:golden_leggings"), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.FEET, GearManager.getItemByName("minecraft:golden_boots"), chance, world);
    }

    private static void equipFixedArmorIfChance(Mob mob, EquipmentSlot slot, ItemStack stack, double chance, ServerLevel world) {
        if (stack.isEmpty()) {
            return;
        }
        if (RANDOM.nextDouble() >= chance) {
            return;
        }
        GearManager.enchantItem(stack, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get(), world);
        GearManager.giveNBT(stack);
        mob.setItemSlot(slot, stack);
    }

    private static void givePiglinBruteWeapon(Mob mob, ServerLevel world) {
        ItemStack diamondAxe;
        ItemStack netheriteAxe;
        if (RANDOM.nextDouble() < 0.05 && !(netheriteAxe = GearManager.getItemByName("minecraft:netherite_axe")).isEmpty()) {
            GearManager.enchantItem(netheriteAxe, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get(), world);
            GearManager.giveNBT(netheriteAxe);
            mob.setItemSlot(EquipmentSlot.MAINHAND, netheriteAxe);
            return;
        }
        if (RANDOM.nextDouble() < 0.15 && !(diamondAxe = GearManager.getItemByName("minecraft:diamond_axe")).isEmpty()) {
            GearManager.enchantItem(diamondAxe, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get(), world);
            GearManager.giveNBT(diamondAxe);
            mob.setItemSlot(EquipmentSlot.MAINHAND, diamondAxe);
            return;
        }
        ItemStack goldAxe = GearManager.getItemByName("minecraft:golden_axe");
        if (!goldAxe.isEmpty() && mob.getMainHandItem().isEmpty()) {
            GearManager.enchantItem(goldAxe, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get(), world);
            GearManager.giveNBT(goldAxe);
            mob.setItemSlot(EquipmentSlot.MAINHAND, goldAxe);
        }
    }

    private static void giveLevelGear(Mob mob, Difficulty difficulty, List<String> armorList, List<String> weaponList, List<?> armorSetList, ServerLevel world) {
        if (GearManager.tryEquipArmorSet(mob, armorSetList, world)) {
            return;
        }
        GearManager.equipArmorIfChance(mob, EquipmentSlot.HEAD, "helmet", GearManager.getGearChanceForDifficulty(difficulty), armorList, world);
        GearManager.equipArmorIfChance(mob, EquipmentSlot.CHEST, "chestplate", GearManager.getGearChanceForDifficulty(difficulty), armorList, world);
        GearManager.equipArmorIfChance(mob, EquipmentSlot.LEGS, "leggings", GearManager.getGearChanceForDifficulty(difficulty), armorList, world);
        GearManager.equipArmorIfChance(mob, EquipmentSlot.FEET, "boots", GearManager.getGearChanceForDifficulty(difficulty), armorList, world);
    }

    private static boolean tryEquipArmorSet(Mob mob, List<?> armorSetList, ServerLevel world) {
        if (armorSetList == null || armorSetList.isEmpty()) {
            return false;
        }
        for (Object raw : armorSetList) {
            try {
                ArmorSet set;
                if (raw instanceof String) {
                    String s = (String)raw;
                    set = GearManager.parseArmorSetString(s);
                } else if (raw instanceof List) {
                    List lst = (List)raw;
                    set = GearManager.parseArmorSetList(lst);
                } else {
                    LOGGER.warn("Unknown armor set entry type: {}", raw);
                    continue;
                }
                if (set == null || RANDOM.nextDouble() >= set.chance()) continue;
                ItemStack head = GearManager.getItemByName(set.head().toString());
                ItemStack chest = GearManager.getItemByName(set.chest().toString());
                ItemStack legs = GearManager.getItemByName(set.legs().toString());
                ItemStack boots = GearManager.getItemByName(set.boots().toString());
                if (head.isEmpty() || chest.isEmpty() || legs.isEmpty() || boots.isEmpty()) {
                    LOGGER.warn("Armor set skipped due to missing item: {}", raw);
                    continue;
                }
                GearManager.enchantItem(head, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get(), world);
                GearManager.enchantItem(chest, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get(), world);
                GearManager.enchantItem(legs, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get(), world);
                GearManager.enchantItem(boots, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get(), world);
                GearManager.giveNBT(head);
                GearManager.giveNBT(chest);
                GearManager.giveNBT(legs);
                GearManager.giveNBT(boots);
                mob.setItemSlot(EquipmentSlot.HEAD, head);
                mob.setItemSlot(EquipmentSlot.CHEST, chest);
                mob.setItemSlot(EquipmentSlot.LEGS, legs);
                mob.setItemSlot(EquipmentSlot.FEET, boots);
                return true;
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to parse/apply armor set entry: {}", raw, (Object)t);
            }
        }
        return false;
    }

    private static ArmorSet parseArmorSetString(String raw) {
        double pct;
        String[] parts;
        if (raw == null) {
            return null;
        }
        String s = raw.trim();
        if (s.startsWith("[")) {
            s = s.substring(1);
        }
        if (s.endsWith("]")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((parts = s.split(",")).length != 5) {
            LOGGER.warn("Invalid armor set format (need 5 entries): {}", (Object)raw);
            return null;
        }
        String h = parts[0].trim();
        String c = parts[1].trim();
        String l = parts[2].trim();
        String b = parts[3].trim();
        String p = parts[4].trim();
        ResourceLocation rh = ResourceLocation.tryParse((String)h);
        ResourceLocation rc = ResourceLocation.tryParse((String)c);
        ResourceLocation rl = ResourceLocation.tryParse((String)l);
        ResourceLocation rb = ResourceLocation.tryParse((String)b);
        if (rh == null || rc == null || rl == null || rb == null) {
            LOGGER.warn("Invalid item id in armor set: {}", (Object)raw);
            return null;
        }
        try {
            pct = Double.parseDouble(p);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid percentage in armor set: {}", (Object)raw);
            return null;
        }
        double chance = GearManager.clamp01(GearManager.percentToUnit(pct));
        return new ArmorSet(rh, rc, rl, rb, chance);
    }

    private static ArmorSet parseArmorSetList(List<?> lst) {
        double pct;
        String l;
        String c;
        String h;
        Object op;
        Object ob;
        block12: {
            block11: {
                if (lst.size() != 5) {
                    LOGGER.warn("Invalid armor set list size (need 5): {}", lst);
                    return null;
                }
                Object oh = lst.get(0);
                Object oc = lst.get(1);
                Object ol = lst.get(2);
                ob = lst.get(3);
                op = lst.get(4);
                if (!(oh instanceof String)) break block11;
                h = (String)oh;
                if (!(oc instanceof String)) break block11;
                c = (String)oc;
                if (!(ol instanceof String)) break block11;
                l = (String)ol;
                if (ob instanceof String) break block12;
            }
            LOGGER.warn("Armor set list expects 4 strings + 1 number: {}", lst);
            return null;
        }
        String b = (String)ob;
        ResourceLocation rh = ResourceLocation.tryParse((String)h);
        ResourceLocation rc = ResourceLocation.tryParse((String)c);
        ResourceLocation rl = ResourceLocation.tryParse((String)l);
        ResourceLocation rb = ResourceLocation.tryParse((String)b);
        if (rh == null || rc == null || rl == null || rb == null) {
            LOGGER.warn("Invalid item id in armor set list: {}", lst);
            return null;
        }
        if (op instanceof Number) {
            Number n = (Number)op;
            pct = n.doubleValue();
        } else if (op instanceof String) {
            String sp = (String)op;
            try {
                pct = Double.parseDouble(sp);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            LOGGER.warn("Armor set percentage must be number or numeric string: {}", lst);
            return null;
        }
        double chance = GearManager.clamp01(GearManager.percentToUnit(pct));
        return new ArmorSet(rh, rc, rl, rb, chance);
    }

    private static double percentToUnit(double pct) {
        return pct / 100.0;
    }

    private static double clamp01(double x) {
        return Math.max(0.0, Math.min(1.0, x));
    }

    private static void equipArmorIfChance(Mob mob, EquipmentSlot slot, String armorType, double chance, List<String> availableArmor, ServerLevel world) {
        List<String> filteredArmor = availableArmor.stream().filter(armor -> armor.contains(armorType)).toList();
        if (!filteredArmor.isEmpty() && RANDOM.nextDouble() < chance) {
            String selectedArmor = filteredArmor.get(RANDOM.nextInt(filteredArmor.size()));
            ItemStack armor2 = GearManager.getItemByName(selectedArmor);
            GearManager.enchantItem(armor2, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get(), world);
            GearManager.giveNBT(armor2);
            mob.setItemSlot(slot, armor2);
        }
    }

    private static double getGearChanceForDifficulty(Difficulty difficulty) {
        return switch (difficulty) {
            case Difficulty.EASY -> (Double)DangerousConfig.CONFIG.easyGearChance.get();
            case Difficulty.NORMAL -> (Double)DangerousConfig.CONFIG.normalGearChance.get();
            case Difficulty.HARD -> (Double)DangerousConfig.CONFIG.hardGearChance.get();
            default -> 0.0;
        };
    }

    private static void giveNBT(ItemStack item) {
        if (item.isEmpty()) {
            return;
        }
        DangerousConfig.CONFIG.enchantmentChance.get();
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(EQUIPMENT_MODIFIED_TAG, true);
        CustomData customData = CustomData.of((CompoundTag)tag);
        item.set(DataComponents.CUSTOM_DATA, (Object)customData);
    }

    private static void giveZombieWeapon(Mob mob, ServerLevel world) {
        List weaponList;
        String weaponName;
        ItemStack weapon;
        double weaponChance = (Double)DangerousConfig.CONFIG.weaponChance.get();
        double randomValue = RANDOM.nextDouble();
        if (randomValue < weaponChance && !(weapon = GearManager.getItemByName(weaponName = (String)(weaponList = mob.getY() >= 64.0 ? (List)DangerousConfig.CONFIG.surfaceWeapons.get() : (mob.getY() >= 0.0 ? (List)DangerousConfig.CONFIG.caveWeapons.get() : (List)DangerousConfig.CONFIG.deepCaveWeapons.get())).get(RANDOM.nextInt(weaponList.size())))).isEmpty()) {
            GearManager.enchantItem(weapon, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get(), world);
            GearManager.giveNBT(weapon);
            mob.setItemSlot(EquipmentSlot.MAINHAND, weapon);
        }
    }

    private static void giveSkeletonWeapon(Mob mob, ServerLevel world) {
        List weaponList;
        String weaponName;
        ItemStack weapon;
        double weaponChance = (Double)DangerousConfig.CONFIG.weaponChance.get();
        double randomValue = RANDOM.nextDouble();
        ItemStack bow = GearManager.getItemByName("minecraft:bow");
        GearManager.enchantItem(bow, (List)DangerousConfig.CONFIG.availableBowEnchantments.get(), world);
        GearManager.giveNBT(bow);
        mob.setItemSlot(EquipmentSlot.MAINHAND, bow);
        if (randomValue < weaponChance && !(weapon = GearManager.getItemByName(weaponName = (String)(weaponList = mob.getY() >= 64.0 ? (List)DangerousConfig.CONFIG.surfaceWeapons.get() : (mob.getY() >= 0.0 ? (List)DangerousConfig.CONFIG.caveWeapons.get() : (List)DangerousConfig.CONFIG.deepCaveWeapons.get())).get(RANDOM.nextInt(weaponList.size())))).isEmpty()) {
            GearManager.enchantItem(weapon, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get(), world);
            GearManager.giveNBT(weapon);
            mob.setItemSlot(EquipmentSlot.OFFHAND, weapon);
        }
    }

    private static void enchantItem(ItemStack item, List<String> availableEnchantments, ServerLevel world) {
        ResourceKey key;
        if (item.isEmpty() || availableEnchantments.isEmpty()) {
            return;
        }
        double enchantmentChance = (Double)DangerousConfig.CONFIG.enchantmentChance.get();
        if (RANDOM.nextDouble() >= enchantmentChance) {
            return;
        }
        String selectedEnch = availableEnchantments.get(RANDOM.nextInt(availableEnchantments.size()));
        if (!selectedEnch.contains(":")) {
            LOGGER.warn("Invalid enchantment format in the config: {}. Correct format: modid:enchantment_name", (Object)selectedEnch);
            return;
        }
        ResourceLocation enchId = ResourceLocation.tryParse((String)selectedEnch);
        if (enchId == null) {
            LOGGER.warn("Invalid enchantment id: {}", (Object)selectedEnch);
            return;
        }
        Registry enchLookup = world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        Optional opt = enchLookup.get(key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)enchId));
        if (opt.isEmpty()) {
            LOGGER.warn("Enchantment not found in the registry: {}", (Object)selectedEnch);
            return;
        }
        Holder holder = (Holder)opt.get();
        int max = ((Enchantment)holder.value()).getMaxLevel();
        int level = 1 + RANDOM.nextInt(Math.max(1, max));
        item.enchant(holder, level);
    }

    private static void increaseCreeperSpeed(Creeper creeper) {
        AttributeInstance speedAttribute = creeper.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null) {
            double speedMultiplier = (Double)DangerousConfig.CONFIG.creeperSpeedMultiplier.get();
            speedAttribute.setBaseValue(speedAttribute.getBaseValue() * speedMultiplier);
        }
    }

    private static ItemStack getItemByName(String itemName) {
        if (!itemName.contains(":")) {
            LOGGER.warn("Invalid item format in the config: {}. Correct format: modid:item_name", (Object)itemName);
            return ItemStack.EMPTY;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)itemName);
        if (id == null) {
            LOGGER.warn("Invalid item id: {}", (Object)itemName);
            return ItemStack.EMPTY;
        }
        Optional opt = BuiltInRegistries.ITEM.get(id);
        if (opt.isEmpty()) {
            LOGGER.warn("Item not found in the registry: {}", (Object)itemName);
            return ItemStack.EMPTY;
        }
        Item item = (Item)((Holder.Reference)opt.get()).value();
        return new ItemStack((ItemLike)item);
    }

    private record ArmorSet(ResourceLocation head, ResourceLocation chest, ResourceLocation legs, ResourceLocation boots, double chance) {
    }
}

