/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger;

import java.util.Iterator;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class MobDeathHandler {
    @SubscribeEvent
    public void onMobDeath(LivingDropsEvent event) {
        Mob mob;
        if (!(event.getEntity().level() instanceof ServerLevel)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (mob = (Mob)livingEntity) instanceof Monster) {
            Iterator iterator = event.getDrops().iterator();
            while (iterator.hasNext()) {
                ItemEntity itemEntity = (ItemEntity)iterator.next();
                ItemStack itemStack = itemEntity.getItem();
                if (!MobDeathHandler.hasDangerousTag(itemStack)) continue;
                iterator.remove();
            }
        }
    }

    private static boolean hasDangerousTag(ItemStack item) {
        if (item.isEmpty()) {
            return false;
        }
        CustomData customData = (CustomData)item.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return false;
        }
        return customData.copyTag().getBoolean("dangerous_equipment_modified");
    }
}

