/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import org.jetbrains.annotations.NotNull;

public class SkeletonWeaponManager {
    private static final Map<UUID, Boolean> skeletonMeleeMode = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> lastSwitchTick = new HashMap<UUID, Long>();
    private static final Map<UUID, ItemStack> stashedBow = new HashMap<UUID, ItemStack>();
    private static final long SWITCH_COOLDOWN_TICKS = 20L;
    private static final double MELEE_IN = 6.0;
    private static final double MELEE_OUT = 8.0;

    @SubscribeEvent
    public void onLivingChangeTarget(LivingChangeTargetEvent event) {
        UUID id;
        AbstractSkeleton skeleton;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof AbstractSkeleton)) break block4;
                skeleton = (AbstractSkeleton)livingEntity;
                if (!skeleton.level().isClientSide) break block5;
            }
            return;
        }
        long now = skeleton.level().getGameTime();
        if (now - lastSwitchTick.getOrDefault(id = skeleton.getUUID(), 0L) < 20L) {
            return;
        }
        this.updateSkeletonWeapon(skeleton);
        lastSwitchTick.put(id, now);
    }

    private void updateSkeletonWeapon(AbstractSkeleton skeleton) {
        boolean shouldBeMelee = this.shouldGoMelee(skeleton);
        UUID id = skeleton.getUUID();
        if (skeletonMeleeMode.getOrDefault(id, false) != shouldBeMelee) {
            if (shouldBeMelee) {
                this.switchToMelee(skeleton);
            } else {
                this.switchToRanged(skeleton);
            }
            this.forceAttackMode(skeleton, shouldBeMelee);
            skeletonMeleeMode.put(id, shouldBeMelee);
        }
    }

    private boolean shouldGoMelee(AbstractSkeleton skeleton) {
        if (!SkeletonWeaponManager.hasMeleeWeapon(skeleton)) {
            return false;
        }
        LivingEntity tgt = skeleton.getTarget();
        boolean nowMelee = skeletonMeleeMode.getOrDefault(skeleton.getUUID(), false);
        if (tgt == null || !tgt.isAlive()) {
            List players = skeleton.level().getEntitiesOfClass(Player.class, skeleton.getBoundingBox().inflate(6.0), EntitySelector.NO_SPECTATORS);
            return !players.isEmpty();
        }
        double d = skeleton.distanceTo((Entity)tgt);
        boolean los = skeleton.hasLineOfSight((Entity)tgt);
        if (!nowMelee) {
            return los && d <= 6.0;
        }
        return !(d >= 8.0) && los;
    }

    private static boolean isMelee(ItemStack s) {
        return !s.isEmpty() && (s.getItem() instanceof SwordItem || s.getItem() instanceof AxeItem);
    }

    private static boolean isBow(ItemStack s) {
        return !s.isEmpty() && s.getItem() instanceof BowItem;
    }

    private static boolean hasMeleeWeapon(AbstractSkeleton sk) {
        return SkeletonWeaponManager.isMelee(sk.getMainHandItem()) || SkeletonWeaponManager.isMelee(sk.getOffhandItem());
    }

    private void switchToMelee(AbstractSkeleton sk) {
        UUID id = sk.getUUID();
        ItemStack main = sk.getMainHandItem();
        ItemStack off = sk.getOffhandItem();
        ItemStack foundBow = ItemStack.EMPTY;
        if (SkeletonWeaponManager.isBow(main)) {
            foundBow = main.copy();
            sk.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        if (SkeletonWeaponManager.isBow(off)) {
            foundBow = off.copy();
            sk.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        }
        if (!foundBow.isEmpty()) {
            stashedBow.put(id, foundBow);
        }
        main = sk.getMainHandItem();
        off = sk.getOffhandItem();
        if (!SkeletonWeaponManager.isMelee(main) && SkeletonWeaponManager.isMelee(off)) {
            sk.setItemSlot(EquipmentSlot.MAINHAND, off.copy());
            sk.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        }
    }

    private void switchToRanged(AbstractSkeleton sk) {
        ItemStack melee;
        UUID id = sk.getUUID();
        ItemStack bow = stashedBow.getOrDefault(id, ItemStack.EMPTY);
        if (bow.isEmpty()) {
            if (SkeletonWeaponManager.isBow(sk.getMainHandItem())) {
                bow = sk.getMainHandItem().copy();
            } else if (SkeletonWeaponManager.isBow(sk.getOffhandItem())) {
                bow = sk.getOffhandItem().copy();
            }
        }
        ItemStack main = sk.getMainHandItem();
        ItemStack off = sk.getOffhandItem();
        ItemStack itemStack = SkeletonWeaponManager.isMelee(main) ? main.copy() : (melee = SkeletonWeaponManager.isMelee(off) ? off.copy() : ItemStack.EMPTY);
        if (!bow.isEmpty()) {
            sk.setItemSlot(EquipmentSlot.MAINHAND, bow.copy());
            stashedBow.remove(id);
        }
        if (!melee.isEmpty()) {
            if (!SkeletonWeaponManager.isBow(melee)) {
                sk.setItemSlot(EquipmentSlot.OFFHAND, melee);
            }
        } else if (SkeletonWeaponManager.isBow(off)) {
            sk.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        }
    }

    private void forceAttackMode(AbstractSkeleton sk, boolean melee) {
        sk.stopUsingItem();
        RangedBowAttackGoal ranged = null;
        MeleeAttackGoal meleeGoal = null;
        for (WrappedGoal wg : sk.goalSelector.getAvailableGoals()) {
            MeleeAttackGoal mg;
            Goal g = wg.getGoal();
            if (g instanceof RangedBowAttackGoal) {
                RangedBowAttackGoal rg;
                ranged = rg = (RangedBowAttackGoal)g;
                continue;
            }
            if (!(g instanceof MeleeAttackGoal)) continue;
            meleeGoal = mg = (MeleeAttackGoal)g;
        }
        if (ranged != null) {
            sk.goalSelector.removeGoal(ranged);
        }
        if (meleeGoal != null) {
            sk.goalSelector.removeGoal(meleeGoal);
        }
        if (melee) {
            sk.goalSelector.addGoal(4, (Goal)new NoPoseMeleeAttackGoal(sk, 1.2, false));
        } else {
            sk.goalSelector.addGoal(4, (Goal)new RangedBowAttackGoal((Monster)sk, 1.0, 20, 15.0f));
        }
        sk.setAggressive(false);
        sk.getNavigation().stop();
    }

    private static class NoPoseMeleeAttackGoal
    extends MeleeAttackGoal {
        private final AbstractSkeleton skel;

        public NoPoseMeleeAttackGoal(AbstractSkeleton mob, double speed, boolean longMemory) {
            super((PathfinderMob)mob, speed, longMemory);
            this.skel = mob;
        }

        public void start() {
            super.start();
            this.skel.setAggressive(false);
        }

        public void stop() {
            super.stop();
            this.skel.setAggressive(false);
        }

        public void tick() {
            super.tick();
            this.skel.setAggressive(false);
        }

        protected void checkAndPerformAttack(@NotNull LivingEntity t) {
            super.checkAndPerformAttack(t);
            this.skel.setAggressive(false);
        }
    }
}

