/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger.Spider;

import com.wardanger.DangerousConfig;
import com.wardanger.Spider.SpiderEffect;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class SpiderSpeedEnhancement {
    private static final String SPIDER_BUFF_TAG = "dangerous_spider_buff";
    private static final int SPIDER_VENOM_DURATION_TICKS = 300;
    private static final double SPIDER_VENOM_REGEN_MULTIPLIER = 0.3;
    private static final double SPIDER_VENOM_APPLY_CHANCE = 0.3;

    @SubscribeEvent
    public void onSpiderAttackApplyVenom(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        if (!(source.getEntity() instanceof Spider)) {
            return;
        }
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (level2.random.nextDouble() >= 0.3) {
            return;
        }
        target.addEffect(new MobEffectInstance(SpiderEffect.SPIDER_VENOM, 300, 0, false, true));
    }

    @SubscribeEvent
    public void onLivingHealReduceWithSpiderVenom(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = entity.getEffect(SpiderEffect.SPIDER_VENOM);
        if (effect == null) {
            return;
        }
        float original = event.getAmount();
        float reduced = (float)((double)original * 0.3);
        if (reduced < 0.01f) {
            reduced = 0.01f;
        }
        event.setAmount(reduced);
    }

    @SubscribeEvent
    public void onSpiderSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Spider) {
            CompoundTag entityData;
            Spider spider = (Spider)entity;
            if (event.getLevel() instanceof ServerLevel && !(entityData = spider.getPersistentData()).getBoolean(SPIDER_BUFF_TAG)) {
                SpiderSpeedEnhancement.increaseSpiderSpeed(spider);
                entityData.putBoolean(SPIDER_BUFF_TAG, true);
            }
        }
    }

    private static void increaseSpiderSpeed(Spider spider) {
        double speedMultiplier = (Double)DangerousConfig.CONFIG.spiderSpeedMultiplier.get();
        AttributeInstance speedAttribute = spider.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null) {
            speedAttribute.setBaseValue(speedAttribute.getBaseValue() * speedMultiplier);
        }
    }
}

