/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger;

import com.wardanger.DangerousConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Spider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class SpiderSpeedEnhancement {
    @SubscribeEvent
    public void onSpiderSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Spider) {
            Spider spider = (Spider)entity;
            if (event.getLevel() instanceof ServerLevel) {
                SpiderSpeedEnhancement.increaseSpiderSpeed(spider);
            }
        }
    }

    private static void increaseSpiderSpeed(Spider spider) {
        double speedMultiplier = (Double)DangerousConfig.CONFIG.spiderSpeedMultiplier.get();
        AttributeInstance speedAttribute = spider.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null) {
            speedAttribute.setBaseValue(speedAttribute.getBaseValue() * speedMultiplier);
        }
    }
}

