/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;

public class IllagerWeaponManager {
    private static final Map<UUID, Boolean> meleeMode = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> lastSwitchTick = new HashMap<UUID, Long>();
    private static final Map<UUID, ItemStack> stashedCrossbow = new HashMap<UUID, ItemStack>();
    private static final Map<UUID, Long> lastModeChangeTick = new HashMap<UUID, Long>();
    private static final long SWITCH_COOLDOWN_TICKS = 20L;
    private static final long MODE_LOCK_TICKS = 120L;
    private static final double MELEE_IN = 6.0;
    private static final double MELEE_OUT = 12.0;
    private static final ResourceLocation OMINOUS_BANNER_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ominous_banner");

    @SubscribeEvent
    public void onLivingChangeTarget(LivingChangeTargetEvent event) {
        UUID id;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Pillager)) {
            return;
        }
        Pillager pillager = (Pillager)livingEntity;
        if (pillager.level().isClientSide) {
            return;
        }
        long now = pillager.level().getGameTime();
        if (now - lastSwitchTick.getOrDefault(id = pillager.getUUID(), 0L) < 20L) {
            return;
        }
        if (now - lastModeChangeTick.getOrDefault(id, 0L) < 120L) {
            return;
        }
        this.updatePillager(pillager, now);
        lastSwitchTick.put(id, now);
    }

    private void updatePillager(Pillager mob, long nowTick) {
        boolean wantMelee = this.shouldGoMelee(mob, IllagerWeaponManager.hasMeleeWeaponConsideringBanner(mob));
        UUID id = mob.getUUID();
        boolean curMelee = meleeMode.getOrDefault(id, false);
        if (curMelee != wantMelee) {
            if (wantMelee) {
                this.switchToMelee(mob);
            } else {
                this.switchToRanged(mob);
            }
            meleeMode.put(id, wantMelee);
            lastModeChangeTick.put(id, nowTick);
        }
    }

    private void switchToMelee(Pillager mob) {
        UUID id = mob.getUUID();
        ItemStack main = mob.getMainHandItem();
        ItemStack off = mob.getOffhandItem();
        if (IllagerWeaponManager.isCrossbow(main)) {
            stashedCrossbow.put(id, main.copy());
            mob.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        if (!IllagerWeaponManager.isOminousBanner(off) && IllagerWeaponManager.isCrossbow(off)) {
            stashedCrossbow.put(id, off.copy());
            mob.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        }
        main = mob.getMainHandItem();
        off = mob.getOffhandItem();
        if (!IllagerWeaponManager.isMelee(main) && IllagerWeaponManager.isMelee(off) && !IllagerWeaponManager.isOminousBanner(off)) {
            mob.setItemSlot(EquipmentSlot.MAINHAND, off.copy());
            mob.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        }
        this.forceAttackMode_melee(mob);
    }

    private void switchToRanged(Pillager mob) {
        ItemStack bow;
        UUID id = mob.getUUID();
        ItemStack main = mob.getMainHandItem();
        ItemStack off = mob.getOffhandItem();
        if (IllagerWeaponManager.isMelee(main)) {
            if (IllagerWeaponManager.isOminousBanner(off)) {
                this.forceAttackMode_melee(mob);
                return;
            }
            if (off.isEmpty() || IllagerWeaponManager.isCrossbow(off)) {
                if (IllagerWeaponManager.isCrossbow(off)) {
                    mob.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                }
                mob.setItemSlot(EquipmentSlot.OFFHAND, main.copy());
                mob.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
        }
        if ((bow = stashedCrossbow.getOrDefault(id, ItemStack.EMPTY)).isEmpty()) {
            if (IllagerWeaponManager.isCrossbow(mob.getMainHandItem())) {
                bow = mob.getMainHandItem().copy();
            } else if (IllagerWeaponManager.isCrossbow(mob.getOffhandItem()) && !IllagerWeaponManager.isOminousBanner(mob.getOffhandItem())) {
                bow = mob.getOffhandItem().copy();
            }
        }
        if (!bow.isEmpty()) {
            mob.setItemSlot(EquipmentSlot.MAINHAND, bow.copy());
            stashedCrossbow.remove(id);
        }
        if (!IllagerWeaponManager.isOminousBanner(mob.getOffhandItem()) && IllagerWeaponManager.isCrossbow(mob.getOffhandItem())) {
            mob.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        }
        this.forceAttackMode_ranged(mob);
    }

    private void forceAttackMode_melee(Pillager mob) {
        mob.stopUsingItem();
        mob.setChargingCrossbow(false);
        mob.getNavigation().stop();
        mob.setAggressive(true);
        this.removeAllGoals(mob, RangedCrossbowAttackGoal.class);
        this.removeAllGoals(mob, MeleeAttackGoal.class);
        mob.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)mob, 1.2, false));
    }

    private void forceAttackMode_ranged(Pillager mob) {
        mob.stopUsingItem();
        mob.setChargingCrossbow(false);
        mob.getNavigation().stop();
        mob.setAggressive(false);
        this.removeAllGoals(mob, RangedCrossbowAttackGoal.class);
        this.removeAllGoals(mob, MeleeAttackGoal.class);
        mob.goalSelector.addGoal(4, (Goal)new RangedCrossbowAttackGoal((Monster)mob, 1.0, 15.0f));
    }

    private void removeAllGoals(Pillager mob, Class<? extends Goal> type) {
        ArrayList<WrappedGoal> toRemove = new ArrayList<WrappedGoal>();
        for (WrappedGoal wg : mob.goalSelector.getAvailableGoals()) {
            if (!type.isInstance(wg.getGoal())) continue;
            toRemove.add(wg);
        }
        for (WrappedGoal wg : toRemove) {
            mob.goalSelector.removeGoal(wg.getGoal());
        }
    }

    private boolean shouldGoMelee(Pillager mob, boolean hasMelee) {
        if (!hasMelee) {
            return false;
        }
        LivingEntity tgt = mob.getTarget();
        boolean nowMelee = meleeMode.getOrDefault(mob.getUUID(), false);
        if (tgt == null || !tgt.isAlive()) {
            List players = mob.level().getEntitiesOfClass(Player.class, mob.getBoundingBox().inflate(6.0), EntitySelector.NO_SPECTATORS);
            return !players.isEmpty();
        }
        double d = mob.distanceTo((Entity)tgt);
        if (!nowMelee) {
            return mob.hasLineOfSight((Entity)tgt) && d <= 6.0;
        }
        return !(d <= 12.0);
    }

    private static boolean isMelee(ItemStack s) {
        return !s.isEmpty() && (s.is(ItemTags.SWORDS) || s.is(ItemTags.AXES));
    }

    private static boolean isCrossbow(ItemStack s) {
        return !s.isEmpty() && s.getItem() instanceof CrossbowItem;
    }

    private static boolean isOminousBanner(ItemStack s) {
        if (s.isEmpty()) {
            return false;
        }
        return OMINOUS_BANNER_ID.equals((Object)BuiltInRegistries.ITEM.getKey((Object)s.getItem()));
    }

    private static boolean hasMeleeWeaponConsideringBanner(Pillager m) {
        if (IllagerWeaponManager.isMelee(m.getMainHandItem())) {
            return true;
        }
        return IllagerWeaponManager.isMelee(m.getOffhandItem()) && !IllagerWeaponManager.isOminousBanner(m.getOffhandItem());
    }
}

