/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class EntityBullet
extends AbstractHurtingProjectile {
    protected double damage = 1.0;
    protected boolean ignoreInvulnerability = false;
    protected int maxTick = 100;
    protected double knockbackStrength = 0.0;
    protected int ticksSinceFired;

    public EntityBullet(EntityType<? extends EntityBullet> p_i50160_1_, Level p_i50160_2_) {
        super(p_i50160_1_, p_i50160_2_);
    }

    public EntityBullet(EntityType<? extends EntityBullet> p_i50160_1_, Level worldIn, LivingEntity shooter) {
        this(p_i50160_1_, worldIn, shooter, 0.0, 0.0, 0.0);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
    }

    public EntityBullet(EntityType<? extends EntityBullet> p_i50160_1_, Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(p_i50160_1_, shooter, accelX, accelY, accelZ, worldIn);
    }

    public EntityBullet(EntityType<? extends EntityBullet> p_i50160_1_, Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(p_i50160_1_, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("tsf", this.ticksSinceFired);
        compound.m_128347_("damage", this.damage);
        if (this.ignoreInvulnerability) {
            compound.m_128379_("ignoreinv", this.ignoreInvulnerability);
        }
        if (this.knockbackStrength != 0.0) {
            compound.m_128347_("knockback", this.knockbackStrength);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksSinceFired = compound.m_128451_("tsf");
        this.damage = compound.m_128459_("damage");
        this.ignoreInvulnerability = compound.m_128471_("ignoreinv");
        this.knockbackStrength = compound.m_128459_("knockback");
    }

    public void m_8119_() {
        ++this.ticksSinceFired;
        if (this.ticksSinceFired > this.getMaxTick() || this.m_20184_().m_82556_() < 0.01) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!(this.m_9236_().m_5776_() || this.f_19794_ && result.m_6662_() == HitResult.Type.BLOCK)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_5790_(EntityHitResult raytrace) {
        super.m_5790_(raytrace);
        if (!this.m_9236_().m_5776_()) {
            boolean damaged;
            Entity target = raytrace.m_82443_();
            Entity shooter = this.m_19749_();
            int lastHurtResistant = target.f_19802_;
            if (this.ignoreInvulnerability) {
                target.f_19802_ = 0;
            }
            if ((damaged = target.m_6469_(this.m_269291_().m_269390_((Entity)this, shooter), (float)this.damage)) && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (this.knockbackStrength > 0.0) {
                    double actualKnockback = this.knockbackStrength;
                    Vec3 vec = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(actualKnockback);
                    if (vec.m_82556_() > 0.0) {
                        livingTarget.m_6027_(vec.f_82479_, 0.1, vec.f_82481_);
                    }
                }
                if (shooter instanceof LivingEntity) {
                    this.m_19970_((LivingEntity)shooter, target);
                }
                this.onLivingEntityHit(this, livingTarget, shooter, this.m_9236_());
            } else if (!damaged && this.ignoreInvulnerability) {
                target.f_19802_ = lastHurtResistant;
            }
        }
    }

    public abstract void onLivingEntityHit(EntityBullet var1, LivingEntity var2, Entity var3, Level var4);

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ParticleOptions m_5967_() {
        return ParticleTypes.f_123762_;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setIgnoreInvulnerability(boolean ignoreInvulnerability) {
        this.ignoreInvulnerability = ignoreInvulnerability;
    }

    public boolean isIgnoreInvulnerability() {
        return this.ignoreInvulnerability;
    }

    public int getMaxTick() {
        return this.maxTick;
    }

    public void setMaxTick(int maxTick) {
        this.maxTick = maxTick;
    }

    public boolean m_5931_() {
        return false;
    }

    protected float m_6884_() {
        return 1.0f;
    }

    public boolean m_6087_() {
        return false;
    }

    public void setKnockbackStrength(double knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }
}

