/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import org.slf4j.Logger;

public abstract class AbstractConditionalDatapackEntriesProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final Predicate<String> namespacePredicate;

    public AbstractConditionalDatapackEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, Set<String> modIds) {
        this.namespacePredicate = modIds == null ? namespace -> true : modIds::contains;
        this.registries = registries;
        this.output = output;
    }

    public AbstractConditionalDatapackEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, RegistrySetBuilder datapackEntriesBuilder, Set<String> modIds) {
        this(output, (CompletableFuture<HolderLookup.Provider>)registries.thenApply(r -> AbstractConditionalDatapackEntriesProvider.constructDatapackRegistries(r, datapackEntriesBuilder)), modIds);
    }

    private static HolderLookup.Provider constructDatapackRegistries(HolderLookup.Provider original, RegistrySetBuilder datapackEntriesBuilder) {
        HashSet builderKeys = new HashSet(datapackEntriesBuilder.getEntryKeys());
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().filter(data -> !builderKeys.contains(data.f_243794_())).forEach(data -> datapackEntriesBuilder.m_254916_(data.f_243794_(), context -> {}));
        return datapackEntriesBuilder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), original);
    }

    public abstract <T> Map<ResourceKey<T>, List<ICondition>> getConditions();

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        return this.registries.thenCompose(p_256533_ -> {
            RegistryOps dynamicops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)p_256533_);
            return CompletableFuture.allOf((CompletableFuture[])DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().flatMap(arg_0 -> this.lambda$run$5(pOutput, p_256533_, (DynamicOps)dynamicops, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistry(CachedOutput pOutput, HolderLookup.Provider pRegistries, DynamicOps<JsonElement> pOps, RegistryDataLoader.RegistryData<T> pRegistryData) {
        ResourceKey resourcekey = pRegistryData.f_243794_();
        return pRegistries.m_254861_(resourcekey).map(p_255847_ -> {
            PackOutput.PathProvider packoutput$pathprovider = this.output.m_245269_(PackOutput.Target.DATA_PACK, ForgeHooks.prefixNamespace((ResourceLocation)resourcekey.m_135782_()));
            return CompletableFuture.allOf((CompletableFuture[])p_255847_.m_214062_().filter(holder -> this.namespacePredicate.test(holder.m_205785_().m_135782_().m_135827_())).map(reference -> {
                JsonArray conditions = new JsonArray();
                if (this.getConditions().containsKey(reference.m_205785_())) {
                    for (ICondition c : this.getConditions().get(reference.m_205785_())) {
                        conditions.add((JsonElement)CraftingHelper.serialize((ICondition)c));
                    }
                }
                return AbstractConditionalDatapackEntriesProvider.dumpConditionalValue(packoutput$pathprovider.m_245731_(reference.m_205785_().m_135782_()), pOutput, pOps, pRegistryData.f_244580_(), reference.m_203334_(), conditions);
            }).toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> dumpConditionalValue(Path pValuePath, CachedOutput pOutput, DynamicOps<JsonElement> pOps, Encoder<E> pEncoder, E pValue, JsonArray conditions) {
        Optional optional = pEncoder.encodeStart(pOps, pValue).resultOrPartial(p_255999_ -> LOGGER.error("Couldn't serialize element {}: {}", (Object)pValuePath, p_255999_));
        if (optional.isPresent()) {
            JsonObject result = ((JsonElement)optional.get()).getAsJsonObject();
            if (!conditions.isJsonNull() && !conditions.isEmpty()) {
                result.add("forge:conditions", (JsonElement)conditions);
            }
            return DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)result, (Path)pValuePath);
        }
        return CompletableFuture.completedFuture(null);
    }

    private /* synthetic */ Stream lambda$run$5(CachedOutput pOutput, HolderLookup.Provider p_256533_, DynamicOps dynamicops, RegistryDataLoader.RegistryData p_256552_) {
        return this.dumpRegistry(pOutput, p_256533_, (DynamicOps<JsonElement>)dynamicops, p_256552_).stream();
    }
}

