/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lightup;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.loohp.lightup.hooks.CoreProtectHook;
import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.BlockStateArgument;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.SafeSuggestions;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LightUp
extends JavaPlugin
implements Listener {
    public static final Map<UUID, Future<?>> playerTask = new ConcurrentHashMap();
    public static final Map<UUID, List<List<Location>>> playerUndo = new ConcurrentHashMap<UUID, List<List<Location>>>();
    public static final ExecutorService service = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("LightUp Task Thread #%d").build());
    public static LightUp lightUp;
    public String messageReload;
    public String messageOnlyPlayerCommand;
    public String messageNoActiveTask;
    public String messageNothingToUndo;
    public String messageWaitComplete;
    public String messageLightUpBegin;
    public String messageLightUpComplete;
    public String messageLightUpCancelled;
    public String messageUndoUnloadedWorld;
    public String messageUndoComplete;
    public boolean progressActionBarEnabled;
    public String progressActionBarFormatting;
    public int maxBlocksPerTick;

    public void onEnable() {
        lightUp = this;
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.loadConfig();
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "LightUp has been enabled!");
        for (Player player : Bukkit.getOnlinePlayers()) {
            playerUndo.put(player.getUniqueId(), Collections.synchronizedList(new LinkedList()));
        }
    }

    public void onDisable() {
        service.shutdown();
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "LightUp has been disabled!");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        playerUndo.put(event.getPlayer().getUniqueId(), Collections.synchronizedList(new LinkedList()));
    }

    public void loadConfig() {
        this.reloadConfig();
        this.messageReload = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Reload"));
        this.messageOnlyPlayerCommand = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.OnlyPlayerCommand"));
        this.messageNoActiveTask = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.NoActiveTask"));
        this.messageNothingToUndo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.NothingToUndo"));
        this.messageWaitComplete = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.WaitComplete"));
        this.messageLightUpBegin = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.LightUpBegin"));
        this.messageLightUpComplete = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.LightUpComplete"));
        this.messageLightUpCancelled = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.LightUpCancelled"));
        this.messageUndoUnloadedWorld = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.UndoUnloadedWorld"));
        this.messageUndoComplete = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.UndoComplete"));
        this.maxBlocksPerTick = this.getConfig().getInt("Options.MaxBlocksPerTick");
        this.progressActionBarEnabled = this.getConfig().getBoolean("Options.ProgressActionBar.Enabled");
        this.progressActionBarFormatting = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Options.ProgressActionBar.Formatting"));
    }

    public void registerCommands() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("lightup").withAliases(new String[]{"lu"})).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("reload").withPermission("lightup.reload")).executes((sender, args) -> this.getServer().getScheduler().runTask((Plugin)this, () -> {
            this.loadConfig();
            sender.sendMessage(this.messageReload);
        }), new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("cancel").withPermission("lightup.cancel")).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                Future<?> task = playerTask.get(player.getUniqueId());
                if (task == null) {
                    player.sendMessage(this.messageNoActiveTask);
                } else {
                    task.cancel(true);
                }
            } else {
                sender.sendMessage(this.messageOnlyPlayerCommand);
            }
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("undo").withPermission("lightup.undo")).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                List<List<Location>> undos = playerUndo.get(player.getUniqueId());
                if (undos.isEmpty()) {
                    player.sendMessage(this.messageNothingToUndo);
                } else {
                    this.undo(player);
                }
            } else {
                sender.sendMessage(this.messageOnlyPlayerCommand);
            }
        }, new ExecutorType[0])))).withPermission("lightup.use")).withArguments((AbstractArgument[])new Argument[]{new BlockStateArgument("block"), (Argument)new IntegerArgument("min_light_level", 0, 15).replaceSafeSuggestions(SafeSuggestions.suggest((Object[])((Integer[])IntStream.range(0, 16).boxed().toArray(Integer[]::new)))), (Argument)new IntegerArgument("range", 0).includeSafeSuggestions(SafeSuggestions.suggest((Object[])new Integer[]{50})), new BooleanArgument("include_skylight"), (Argument)new StringArgument("lightup_type").includeSuggestions(ArgumentSuggestions.strings((String[])((String[])Arrays.stream(LightUpType.values()).map(each -> each.name().toLowerCase()).toArray(String[]::new))))})).executes((sender, args) -> {
            if (sender instanceof Player) {
                LightUpType type;
                Player player = (Player)sender;
                BlockState blockState = (BlockState)args.get(0);
                int minLightLevel = (Integer)args.get(1);
                int distanceMax = (Integer)args.get(2);
                boolean includeSkylight = (Boolean)args.get(3);
                try {
                    type = LightUpType.valueOf(((String)args.get(4)).toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    type = LightUpType.ALL;
                }
                this.lightUp(player, blockState, player.getLocation(), minLightLevel, distanceMax, includeSkylight, type);
            } else {
                sender.sendMessage(this.messageOnlyPlayerCommand);
            }
        }, new ExecutorType[0])).register();
    }

    public void lightUp(Player player, BlockState blockState, Location origin, int minLightLevel, int distanceMax, boolean includeSkylight, LightUpType type) {
        if (playerTask.get(player.getUniqueId()) != null) {
            player.sendMessage(this.messageWaitComplete);
            return;
        }
        Future<?> task = service.submit(() -> {
            try {
                boolean continueQueue;
                player.sendMessage(this.messageLightUpBegin);
                int minimumLightLevel = Math.min(15, minLightLevel);
                Queue blocks = (Queue)this.getServer().getScheduler().callSyncMethod((Plugin)this, () -> this.collectBlocks(origin, distanceMax)).get();
                int totalBlocks = blocks.size();
                int totalPlaced = 0;
                LinkedList<Location> placementRecord = new LinkedList<Location>();
                playerUndo.get(player.getUniqueId()).add(placementRecord);
                do {
                    CompletableFuture future = new CompletableFuture();
                    this.getServer().getScheduler().runTaskLater((Plugin)this, () -> future.complete(this.continueLightUp(player, blocks, blockState, minimumLightLevel, includeSkylight, type)), 1L);
                    ContinueLightUpResult result = (ContinueLightUpResult)future.get();
                    boolean bl = continueQueue = !result.isFinished();
                    if (!continueQueue) continue;
                    Block block = result.getBlock();
                    if (block != null) {
                        ++totalPlaced;
                        placementRecord.add(block.getLocation());
                    }
                    if (!this.progressActionBarEnabled) continue;
                    int percentage = Math.round((1.0f - (float)blocks.size() / (float)totalBlocks) * 100.0f);
                    String format = this.progressActionBarFormatting.replace("{ScannedBlocks}", String.valueOf(totalBlocks - blocks.size())).replace("{TotalBlocks}", String.valueOf(totalBlocks)).replace("{PlacedLights}", String.valueOf(totalPlaced)).replace("{CompletedPercentage}", String.valueOf(percentage));
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(format));
                } while (continueQueue);
                if (this.progressActionBarEnabled) {
                    String format = this.progressActionBarFormatting.replace("{ScannedBlocks}", String.valueOf(totalBlocks)).replace("{TotalBlocks}", String.valueOf(totalBlocks)).replace("{PlacedLights}", String.valueOf(totalPlaced)).replace("{CompletedPercentage}", "100");
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(format));
                }
                player.sendMessage(this.messageLightUpComplete.replace("{TotalBlocks}", String.valueOf(totalBlocks)).replace("{TotalPlaced}", String.valueOf(totalPlaced)));
            }
            catch (InterruptedException | ExecutionException e) {
                player.sendMessage(this.messageLightUpCancelled);
            }
            playerTask.remove(player.getUniqueId());
        });
        playerTask.put(player.getUniqueId(), task);
    }

    public Queue<Block> collectBlocks(Location origin, int distanceMax) {
        LinkedList<Block> blocks = new LinkedList<Block>();
        World world = origin.getWorld();
        for (int y = Math.max(origin.getBlockY() - distanceMax, world.getMinHeight()); y <= Math.min(origin.getBlockY() + distanceMax, world.getMaxHeight() - 1); ++y) {
            for (int x = origin.getBlockX() - distanceMax; x <= origin.getBlockX() + distanceMax; ++x) {
                for (int z = origin.getBlockZ() - distanceMax; z <= origin.getBlockZ() + distanceMax; ++z) {
                    blocks.add(world.getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    public ContinueLightUpResult continueLightUp(Player player, Queue<Block> blocks, BlockState blockState, int minLightLevel, boolean includeSkylight, LightUpType type) {
        Block block;
        int count = 0;
        while ((block = blocks.poll()) != null) {
            boolean validType;
            if (++count > this.maxBlocksPerTick) {
                return new ContinueLightUpResult(null, false);
            }
            Material down = block.getRelative(BlockFace.DOWN).getType();
            boolean bl = validType = type.equals((Object)LightUpType.ALL) || type.equals((Object)LightUpType.SURFACE) && this.hasSkyAccess(block, 0) || type.equals((Object)LightUpType.CAVE) && !this.hasSkyAccess(block, 7);
            if (!down.isSolid() || !down.isOccluding() || down.equals((Object)Material.BEDROCK) || !block.getType().isAir() || !validType) continue;
            if (includeSkylight) {
                if (block.getLightLevel() >= minLightLevel) continue;
                BlockData placedBlockData = blockState.getBlockData();
                block.setBlockData(placedBlockData);
                CoreProtectHook.logPlacement(player.getName(), block.getLocation(), placedBlockData.getMaterial(), placedBlockData);
                return new ContinueLightUpResult(block, false);
            }
            if (block.getLightFromBlocks() >= minLightLevel) continue;
            BlockData placedBlockData = blockState.getBlockData();
            block.setBlockData(placedBlockData);
            CoreProtectHook.logPlacement(player.getName(), block.getLocation(), placedBlockData.getMaterial(), placedBlockData);
            return new ContinueLightUpResult(block, false);
        }
        return new ContinueLightUpResult(null, true);
    }

    public boolean hasSkyAccess(Block block, int minLight) {
        return block.getLightFromSky() > minLight;
    }

    public void undo(Player player) {
        if (playerTask.get(player.getUniqueId()) != null) {
            player.sendMessage(this.messageWaitComplete);
            return;
        }
        List<List<Location>> undos = playerUndo.get(player.getUniqueId());
        List<Location> locations = undos.remove(undos.size() - 1);
        this.getServer().getScheduler().runTask((Plugin)this, () -> {
            if (!locations.isEmpty() && !((Location)locations.get(0)).isWorldLoaded()) {
                undos.add(locations);
                player.sendMessage(this.messageUndoUnloadedWorld);
                return;
            }
            for (Location location : locations) {
                Block block = location.getBlock();
                CoreProtectHook.logRemoval(player.getName(), block.getLocation(), block.getType(), block.getBlockData());
                block.setType(Material.AIR);
            }
            player.sendMessage(this.messageUndoComplete.replace("{BlocksUndone}", String.valueOf(locations.size())));
        });
    }

    public static enum LightUpType {
        SURFACE,
        CAVE,
        ALL;

    }

    public static class ContinueLightUpResult {
        private final Block block;
        private final boolean finished;

        public ContinueLightUpResult(Block block, boolean finished) {
            this.block = block;
            this.finished = finished;
        }

        public Block getBlock() {
            return this.block;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

