/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.bootifulcuneiforminterface.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.common.util.i18n.StringTranslate;
import net.tracystacktrace.bootifulcuneiforminterface.BootifulCuneiformInterface;
import net.tracystacktrace.bootifulcuneiforminterface.mixins.AccessorGuiScreen;

public abstract class InterfaceHelper {
    protected final GuiScreen screen;
    protected GuiButton eraseButton;
    protected boolean eraseProceed = false;
    protected boolean finishProceed = false;

    public InterfaceHelper(GuiScreen screen) {
        this.screen = screen;
    }

    public boolean isEraseProceed() {
        return this.eraseProceed;
    }

    public boolean isFinishProceed() {
        return this.finishProceed;
    }

    public void initReset() {
        this.eraseProceed = false;
        this.finishProceed = false;
    }

    public void initColorButtons(int x, int y) {
        for (int i = 0; i < BootifulCuneiformInterface.COLORS.length; ++i) {
            this.addButton(new GuiButton(i + 100, x + i / 8 * 16, y + i % 8 * 16, 16, 16, "\u00a7" + BootifulCuneiformInterface.COLORS[i] + BootifulCuneiformInterface.COLORS[i]));
        }
    }

    public void initFormatButtons(int x, int y) {
        for (int i = 0; i < BootifulCuneiformInterface.FORMATS.length; ++i) {
            this.addButton(new GuiButton(i + BootifulCuneiformInterface.COLORS.length + 100, x + i / 3 * 16, y + i % 3 * 16, 16, 16, "\u00a7" + BootifulCuneiformInterface.FORMATS[i] + BootifulCuneiformInterface.FORMATS[i]));
        }
    }

    public void initHelperButtons(int x, int y) {
        StringTranslate translate = StringTranslate.getInstance();
        GuiButton buttonPaste = new GuiButton(122, x, y, 16, 16, "\u00a7a\u2193", translate.translateKey("bootifulcuneiforminterface.paste"));
        buttonPaste.canDisplayInfo = true;
        GuiButton buttonCopy = new GuiButton(124, x, y + 16, 16, 16, "\u00a7e\u2191", translate.translateKey("bootifulcuneiforminterface.copy"));
        buttonCopy.canDisplayInfo = true;
        GuiButton insertEscape = new GuiButton(125, x + 16, y + 16, 16, 16, "\u00a7d\\n", translate.translateKey("bootifulcuneiforminterface.escapechar"));
        insertEscape.canDisplayInfo = true;
        this.eraseButton = new GuiButton(123, x + 16, y, 16, 16, "\u00a7c\u274c", translate.translateKey("bootifulcuneiforminterface.erase"));
        this.eraseButton.canDisplayInfo = true;
        this.addButton(insertEscape);
        this.addButton(buttonCopy);
        this.addButton(this.eraseButton);
        this.addButton(buttonPaste);
    }

    public boolean onClickColorFormatButtons(GuiButton button) {
        if (button.id >= 100 && button.id <= 115) {
            this.appendText("\u00a7" + BootifulCuneiformInterface.COLORS[button.id - 100]);
            return true;
        }
        if (button.id >= 116 && button.id <= 121) {
            this.appendText("\u00a7" + BootifulCuneiformInterface.FORMATS[button.id - 116]);
            return true;
        }
        return false;
    }

    public void onClickFinishButton() {
        if (!this.finishProceed) {
            this.finishProceed = true;
        } else {
            this.finishWriting();
            Minecraft.getInstance().displayGuiScreen(null);
        }
    }

    public void onClickToResetState(GuiButton button, int closeId) {
        if (button.enabled && button.id != 123 && this.eraseProceed) {
            this.eraseProceed = false;
            this.eraseButton.displayString = "\u00a7c\u274c";
        }
        if (button.enabled && button.id != closeId && this.finishProceed) {
            this.finishProceed = false;
        }
    }

    public boolean onClickHelperButtons(GuiButton button) {
        if (button.id == 122) {
            int availableSpace;
            String clipboardText = GuiScreen.getClipboardString();
            if (clipboardText != null && !clipboardText.isEmpty() && (availableSpace = 256 - this.getText().length()) > 0) {
                this.appendText(clipboardText.substring(0, Math.min(availableSpace, clipboardText.length())).replaceAll("[\n\r\t\u0000\f\ufffd]", ""));
            }
            return true;
        }
        if (button.id == 123) {
            if (!this.eraseProceed) {
                button.displayString = "\u00a74\u274c";
                this.eraseProceed = true;
            } else {
                button.displayString = "\u00a7c\u274c";
                this.setText("");
                this.eraseProceed = false;
            }
            return true;
        }
        if (button.id == 124) {
            GuiScreen.setClipboardString((String)this.getText());
            return true;
        }
        if (button.id == 125) {
            this.appendText("\n");
            return true;
        }
        return false;
    }

    public void onKeyPressedToResetState() {
        if (this.eraseProceed) {
            this.eraseProceed = false;
            this.eraseButton.displayString = "\u00a7c\u274c";
        }
        if (this.finishProceed) {
            this.finishProceed = false;
        }
    }

    protected void addButton(GuiButton button) {
        ((AccessorGuiScreen)this.screen).getControlListElements().add(button);
    }

    protected GuiButton getButton(int index) {
        return ((AccessorGuiScreen)this.screen).getControlListElements().get(index);
    }

    protected abstract void setText(String var1);

    protected abstract void appendText(String var1);

    protected abstract String getText();

    protected abstract void finishWriting();
}

